/* 
 * This	file contains formatting information for the automatic
 * generation of html or tex documentation
 */

#include "cpptcl.h"

//@Section: Demonstration classes
//@Man: 
/** 
 * Simple class	which derives from 'tcl_object',	this means
 * it allows the configuration of contained	information	from
 * the command line, totally automatically.
 * 
 * Information may be of the following types:
 *	   
 * bool, int, float, double, long, ... which may be interfaced
 * to Tcl by defining a static array of pointers to members.
 * 
 * info_file_i --- wraps up	an 'ifstream' inside a data	member
 * 
 * info_file_o --- wraps up	an 'ofstream' inside a data	member
 * 
 * There are a number of other options:	info_socket, info_event,
 * info_gatherer, info_matrix, ... which are not discussed here.
 */
class Toaster: public tcl_object {
  public:
	/// Constructor, takes argument 'tcl_args&'
	/** 
	 * The argument	wraps up all the information contained
	 * in the Tcl command line into	a stream based object
	 * for easy	extraction and configuration.
     * 	  Toaster::Toaster(tcl_args& arg)
     * 	  :tcl_object(arg),
     * 	   timeleft("Time left till done",this)
     * 	  {
     * 	      timeleft.min(0.0) = 0.0;
     * 	  }
	 */
    Toaster(tcl_args& arg);
	/// Destructor, currently empty
    ~Toaster(void){}
	/// Declare the class to the Cpptcl system
	/** 
	 * Cpptcl keeps a record of all object	types, their relationship
	 * in the object hierarchy,	and	creation commands; use the command
	 * 'cppmeta' to access that database.
	 */
	Cpptcl_Class(Toaster);
	/// Allows you to add commands to this object
	/** 
	 * Cpptcl automatically supplies a	wide range of configuration
	 * options which you must inherit, but you will	often want to add
	 * your	own	commands (e.g. to call the 'wait' function below)
	 *
     *    int Toaster::parse_tcl_command(tcl_args& arg) {
     *        if(arg("#seconds","set timer on toaster")=="addTime") {
     *            float add;
     *            arg >> add >> done;
     *            NO_EXCEPTIONS(arg,TCL_ERROR);
     *            if(add <0) {
     *                tcl_ << "You can only increment the timer" 
     *                     << tcl_error;
     *            } else {
     *                timeleft += add;
     *                tcl_ << timeleft << result;
     *            }
     *            return tcl_;
     *        } else if(arg("","Wait a second")=="wait") {
     *            arg >> done;
     *            NO_EXCEPTIONS(arg,TCL_ERROR);
     *            if(timeleft >= 1) {
     *                wait();
     *                timeleft -= 1;
     *            } else {
     *                timeleft = 0;
     *            }
     *            tcl_ << timeleft << " seconds left" << result;
     *            return tcl_;
     *        } else {
     *            return tcl_object::parse_tcl_command(arg);
     *        }
     *    }
	 */
    int parse_tcl_command(tcl_args& arg);
	/// An example Tcl-C++ interfaced data member
    float timeleft;
	/// A member function which will be called in Tcl with 'obj wait'
	 /**	
	  *	You	will fill in this function definition
	  *	   void	Toaster::wait(void)	{
	  *		   // do something
	  *	   }
	  */
    void wait(void);
};
/**
 *  Here's the source code for telling Cpptcl and Tcl about
 *  your new class, and for making a dynamically loadable
 *  Tcl package.
 *
 *    /* 
 *     * You can either create Toasters directly in C++ by
 *     * calling the constructor (it needs a trivial argument list
 *     * with its name), or you create a 'tcl_class' to deal with
 *     * it in C++.  This happens automatically if you register
 *     * with 'cppmeta', like this:
 *     *     Cpptcl_Object(Toaster, tcl_object);
 *     *
 *
 *    /// This defines the C++ package init procedure
 *    int Cpptcl_InitFunction(Demoone_Init) {
 *    	// Declare a new C++ class and from what it derives.
 *    	Cpptcl_ObjectWithMembers(Toaster, tcl_object);
 *    	// Tell Tcl about this package
 *    	Tcl_PkgProvide(interp,"Demoone","0.1");
 *    	// Everything went ok, so return
 *    	return TCL_OK;	
 *    }
 */
/**
 * Here's the end result:
 * 
 *    % package require Demoone
 *    0.1
 *    % Toaster t
 *    t
 *    % documentObject t
 *    t addTime : set timer on toaster
 *    t areYou : am I of the given type?
 *    t canAdd : can this type be put inside me?
 *    t cget : return value of a configuration option
 *    t config : set a configuration option
 *    t configure : set a configuration option
 *    t contains : Do I directly contain this object?
 *    t doesContain : no help available.
 *    t getContents : list all things I contain
 *    t getInformation : return name of a piece of information I contain
 *    t getType : returns cpx_type of this object
 *    t ready : am I ready to run?
 *    t rename : changes the Tcl command name of the object
 *    t wait : Wait a second
 *    
 *    % contentsList t
 *    {{Time left till done} 0}
 *    % prettyContentsList t
 *    "Time left till done" 0
 *    
 *    % t
 *    No argument given to 't' should be one of: addTime, areYou, canAdd, cget, 
 *    config, configure, contains, doesContain, getContents, getInformation, 
 *    getType, ready, rename, wait
 *    % t configure
 *    t: need a configuration option and value, any of: Time_left_till_done
 *    % t configure -Time_left_till_done 5
 *    5
 *    % t wait
 *    4 seconds left
 *    % t wait
 *    3 seconds left
 *    % t addTime -1
 *    You can only increment the timer
 *    % t addTime 1
 *    4
 *    % t wait
 *    3 seconds left
 *    % t wait
 *    2 seconds left
 *    % t wait
 *    1 seconds left
 *    % t wait
 *    0 seconds left
 *    % t wait
 *    0 seconds left
 *    % 
 *    % rename t {}
 */
 
 
