/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.ExportTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportOptions;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class ForteNgExportTemplate
extends ExportTemplate {
    protected ForteNgExportTemplate(String name, Path prefix) {
        super(name, prefix);
    }

    protected CharSequence generateDependencyIncludes(Iterable<? extends INamedElement> dependencies) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateTypeIncludes = this.generateTypeIncludes(Iterables.filter(dependencies, DataType.class));
        _builder.append((Object)_generateTypeIncludes);
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function = it -> ForteNgExportUtil.generateDefiningInclude((EObject)it);
        List _sort = IterableExtensions.sort((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.reject(dependencies, DataType.class), (Functions.Function1)_function)));
        for (String include : _sort) {
            CharSequence _generateDependencyInclude = this.generateDependencyInclude(include);
            _builder.append((Object)_generateDependencyInclude);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateTypeIncludes(Iterable<DataType> types) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> ForteNgExportUtil.generateDefiningInclude((EObject)it);
        List _sort = IterableExtensions.sort((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.map(types, (Functions.Function1)_function)));
        for (String include : _sort) {
            CharSequence _generateDependencyInclude = this.generateDependencyInclude(include);
            _builder.append((Object)_generateDependencyInclude);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _generateDependencyInclude_1 = this.generateDependencyInclude("iec61131_functions.h");
        _builder.append((Object)_generateDependencyInclude_1);
        _builder.newLineIfNotEmpty();
        CharSequence _generateDependencyInclude_2 = this.generateDependencyInclude("forte_array_common.h");
        _builder.append((Object)_generateDependencyInclude_2);
        _builder.newLineIfNotEmpty();
        CharSequence _generateDependencyInclude_3 = this.generateDependencyInclude("forte_array.h");
        _builder.append((Object)_generateDependencyInclude_3);
        _builder.newLineIfNotEmpty();
        CharSequence _generateDependencyInclude_4 = this.generateDependencyInclude("forte_array_fixed.h");
        _builder.append((Object)_generateDependencyInclude_4);
        _builder.newLineIfNotEmpty();
        CharSequence _generateDependencyInclude_5 = this.generateDependencyInclude("forte_array_variable.h");
        _builder.append((Object)_generateDependencyInclude_5);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateDependencyInclude(String path) {
        StringConcatenation _xifexpression = null;
        boolean _useSystemIncludes = ForteNgExportOptions.useSystemIncludes();
        if (_useSystemIncludes) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#include <");
            _builder.append(path);
            _builder.append(">");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("#include \"");
            _builder_1.append(path);
            _builder_1.append("\"");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    public String getFileBasename() {
        return this.getName().replaceAll("\\.[^.]+$", "");
    }
}

