/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.validation;

import java.lang.runtime.SwitchBootstraps;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public final class ValidationPreferences {
    public static final String QUALIFIER = "org.eclipse.fordiac.ide.model.validation";
    public static final String HAS_PROJECT_SPECIFIC_OPTIONS = "hasProjectSpecificOptions";
    public static final String SEVERITY_IGNORE = "ignore";
    public static final String SEVERITY_INFO = "info";
    public static final String SEVERITY_WARNING = "warning";
    public static final String SEVERITY_ERROR = "error";
    public static final String COLLISION_SEVERITY = "collisionSeverity";
    public static final String RIGHT_INTERFACE_BAR_COLLISION_SEVERITY = "rightInterfaceBarCollisionSeverity";

    public static int getDiagnosticSeverity(String key, int defaultValue, EObject context) {
        Resource resource = context != null ? context.eResource() : null;
        return ValidationPreferences.getDiagnosticSeverity(key, defaultValue, resource);
    }

    public static int getDiagnosticSeverity(String key, int defaultValue, Resource resource) {
        URI uri = resource != null ? resource.getURI() : null;
        return ValidationPreferences.getDiagnosticSeverity(key, defaultValue, uri);
    }

    public static int getDiagnosticSeverity(String key, int defaultValue, URI uri) {
        IResource resource = uri != null && uri.isPlatformResource() ? ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toPlatformString(true)) : null;
        return ValidationPreferences.getDiagnosticSeverity(key, defaultValue, resource);
    }

    public static int getDiagnosticSeverity(String key, int defaultValue, IResource resource) {
        IProject project = resource != null ? resource.getProject() : null;
        return ValidationPreferences.getDiagnosticSeverity(key, defaultValue, project);
    }

    public static int getDiagnosticSeverity(String key, int defaultValue, IProject project) {
        IScopeContext[] iScopeContextArray;
        if (project != null) {
            IScopeContext[] iScopeContextArray2 = new IScopeContext[2];
            iScopeContextArray2[0] = new ProjectScope(project);
            iScopeContextArray = iScopeContextArray2;
            iScopeContextArray2[1] = InstanceScope.INSTANCE;
        } else {
            IScopeContext[] iScopeContextArray3 = new IScopeContext[1];
            iScopeContextArray = iScopeContextArray3;
            iScopeContextArray3[0] = InstanceScope.INSTANCE;
        }
        IScopeContext[] contexts = iScopeContextArray;
        return ValidationPreferences.getDiagnsoticSeverity(Platform.getPreferencesService().getString(QUALIFIER, key, null, contexts), defaultValue);
    }

    private static int getDiagnsoticSeverity(String value, int defaultValue) {
        String string = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SEVERITY_IGNORE, SEVERITY_INFO, SEVERITY_WARNING, SEVERITY_ERROR}, (Object)string, n)) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 4;
            default -> defaultValue;
        };
    }

    private ValidationPreferences() {
        throw new UnsupportedOperationException();
    }
}

