/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.model.util;

import java.util.Comparator;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class VersionComparator
implements Comparator<String> {
    @Override
    public int compare(String o1, String o2) {
        if (o1 == null || o1.isBlank()) {
            return o2 == null || o2.isBlank() ? 0 : -1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        if (o2 == null || o2.isBlank()) {
            return 1;
        }
        Version v1 = new Version(o1);
        Version v2 = new Version(o2);
        return v1.compareTo(v2);
    }

    public static boolean contains(String range, String version) {
        if (range == null || range.isBlank() || version == null || version.isBlank()) {
            return false;
        }
        VersionRange parsedRange = VersionComparator.parseVersionRange(range);
        Version parsedVersion = new Version(version);
        return parsedRange.includes(parsedVersion);
    }

    public static boolean contains(VersionRange range, String version) {
        if (range == null || version == null || version.isBlank()) {
            return false;
        }
        Version parsedVersion = new Version(version);
        return range.includes(parsedVersion);
    }

    public static VersionRange parseVersionRange(String range) {
        if (range == null || range.isBlank()) {
            return new VersionRange('(', Version.emptyVersion, Version.emptyVersion, ')');
        }
        VersionRange parsedRange = new VersionRange(range.replace('-', ','));
        if (parsedRange.getRight() == null) {
            return new VersionRange('[', parsedRange.getLeft(), parsedRange.getLeft(), ']');
        }
        return parsedRange;
    }

    public static String formatVersionRange(VersionRange range) {
        if (range.getLeftType() == '[' && range.getRightType() == ']' && range.getLeft().equals((Object)range.getRight())) {
            return range.getLeft().toString();
        }
        return range.toString().replace(',', '-');
    }
}

