/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.widgets;

import java.util.function.Consumer;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveInterfaceCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterface;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class InterfaceSelectorButton {
    private final Button interfaceSelector;
    private Primitive type;

    public InterfaceSelectorButton(Composite parent, final Consumer<Command> executeCommand) {
        this.interfaceSelector = new Button(parent, 8);
        this.interfaceSelector.setText(Messages.InterfaceSelectorButton_Interface);
        this.interfaceSelector.setImage(FordiacImage.ICON_LEFT_INPUT_PRIMITIVE.getImage());
        this.interfaceSelector.pack();
        this.interfaceSelector.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceInterface current = InterfaceSelectorButton.this.type.getInterface();
                ServiceInterface other = current.isLeftInterface() ? current.getService().getRightInterface() : current.getService().getLeftInterface();
                ChangePrimitiveInterfaceCommand cmd = new ChangePrimitiveInterfaceCommand(InterfaceSelectorButton.this.type, other);
                executeCommand.accept(cmd);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setType(Primitive primitive) {
        this.type = primitive;
        this.setPrimitiveIcon();
    }

    private void setPrimitiveIcon() {
        if (this.type.getInterface().isLeftInterface()) {
            this.interfaceSelector.setImage(FordiacImage.ICON_LEFT_INPUT_PRIMITIVE.getImage());
        } else {
            this.interfaceSelector.setImage(FordiacImage.ICON_RIGHT_INPUT_PRIMITIVE.getImage());
        }
    }
}

