/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;

class VisibleLinesTracker
implements PaintListener {
    private static final String DATA_KEY = VisibleLinesTracker.class.getName();
    private final ITextViewer viewer;
    private Map<Integer, Rectangle> oldVisibleLineBounds = Collections.emptyMap();
    private final LinkedHashSet<Consumer<StyledText>> handlers = new LinkedHashSet();

    private VisibleLinesTracker(ITextViewer viewer) {
        this.viewer = viewer;
    }

    public void paintControl(PaintEvent e) {
        StyledText textWidget = this.viewer.getTextWidget();
        Map<Integer, Rectangle> newBounds = this.getVisibleLineBounds();
        if (!this.oldVisibleLineBounds.equals(newBounds)) {
            this.oldVisibleLineBounds = newBounds;
            this.handlers.forEach(handler -> handler.accept(textWidget));
        }
    }

    private Map<Integer, Rectangle> getVisibleLineBounds() {
        StyledText textWidget = this.viewer.getTextWidget();
        if (textWidget.isDisposed() || !textWidget.isVisible()) {
            return Collections.emptyMap();
        }
        TreeMap<Integer, Rectangle> res = new TreeMap<Integer, Rectangle>();
        int lastVisibleLineIndex = textWidget.getLineIndex(textWidget.getClientArea().height);
        int widgetLine = textWidget.getLineIndex(0);
        while (widgetLine <= lastVisibleLineIndex) {
            int widgetLineOffset = textWidget.getOffsetAtLine(widgetLine);
            res.put(JFaceTextUtil.widgetLine2ModelLine(this.viewer, widgetLine), new Rectangle(0, textWidget.getLinePixel(widgetLine), 0, textWidget.getLineHeight(widgetLineOffset)));
            ++widgetLine;
        }
        return res;
    }

    static void track(ITextViewer viewer, Consumer<StyledText> handler) {
        StyledText textWidget;
        StyledText styledText = textWidget = viewer != null ? viewer.getTextWidget() : null;
        if (textWidget == null || textWidget.isDisposed()) {
            return;
        }
        VisibleLinesTracker tracker = (VisibleLinesTracker)textWidget.getData(DATA_KEY);
        if (tracker == null) {
            tracker = new VisibleLinesTracker(viewer);
            textWidget.setData(DATA_KEY, (Object)tracker);
        }
        tracker.addHandler(handler);
    }

    static void untrack(ITextViewer viewer, Consumer<StyledText> handler) {
        StyledText textWidget;
        StyledText styledText = textWidget = viewer != null ? viewer.getTextWidget() : null;
        if (textWidget == null || textWidget.isDisposed()) {
            return;
        }
        VisibleLinesTracker tracker = (VisibleLinesTracker)textWidget.getData(DATA_KEY);
        if (tracker != null) {
            tracker.removeHandler(handler);
        }
    }

    private void addHandler(Consumer<StyledText> handler) {
        if (this.handlers.isEmpty()) {
            this.viewer.getTextWidget().addPaintListener((PaintListener)this);
        }
        this.handlers.add(handler);
    }

    private void removeHandler(Consumer<StyledText> handler) {
        this.handlers.remove(handler);
        if (this.handlers.isEmpty()) {
            this.viewer.getTextWidget().removePaintListener((PaintListener)this);
        }
    }
}

