/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.ecore;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.sirius.common.tools.api.ecore.EPackageMetaData;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.tools.internal.ecore.EPackageMetaDataRegistry;

public class EPackageMetaDataRegistryReader {
    private static final String EPACKAGE_META_DATA_EXTENSION_POINT = "org.eclipse.sirius.common.package_meta_data";
    private static final String EPACKAGE_META_DATA_ELEMENT = "ePackageMetaData";
    private static final String NS_URI_ATTRIBUTE = "nsURI";
    private static final String DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String DOCUMENTATION_ATTRIBUTE = "documentation";
    private static final String DOCUMENT_ROOT_ELEMENT = "documentRoot";
    private static final String DOCUMENT_ROOT_CLASS_NAME_ATTRIBUTE = "className";
    private static final String SUGGESTED_ROOT_ELEMENT = "suggestedRoot";
    private static final String SUGGESTED_ROOT_CLASS_NAME_ATTRIBUTE = "className";
    private final IExtensionRegistry extensionRegistry;
    private final EPackageMetaDataRegistry metaDataRegistry;
    private IRegistryEventListener listener = new EPackageExtraDataListener();

    public EPackageMetaDataRegistryReader(IExtensionRegistry extRegistry, EPackageMetaDataRegistry mdRegistry) {
        this.extensionRegistry = extRegistry;
        this.metaDataRegistry = mdRegistry;
    }

    public synchronized void start() {
        IConfigurationElement[] iConfigurationElementArray = this.extensionRegistry.getConfigurationElementsFor(EPACKAGE_META_DATA_EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            EPackageMetaData data = this.parse(cfg);
            if (data != null) {
                this.metaDataRegistry.register(data);
            }
            ++n2;
        }
        this.extensionRegistry.addListener(this.listener, EPACKAGE_META_DATA_EXTENSION_POINT);
    }

    public synchronized void stop() {
        this.extensionRegistry.removeListener(this.listener);
        this.metaDataRegistry.clear();
    }

    private EPackageMetaData parse(IConfigurationElement cfg) {
        if (EPACKAGE_META_DATA_ELEMENT.equals(cfg.getName())) {
            String className;
            IConfigurationElement child;
            EPackageMetaData result = new EPackageMetaData(cfg.getAttribute(NS_URI_ATTRIBUTE));
            result.setDisplayName(cfg.getAttribute(DISPLAY_NAME_ATTRIBUTE));
            result.setDocumentation(cfg.getAttribute(DOCUMENTATION_ATTRIBUTE));
            IConfigurationElement[] iConfigurationElementArray = cfg.getChildren(SUGGESTED_ROOT_ELEMENT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                child = iConfigurationElementArray[n2];
                className = child.getAttribute("className");
                if (!StringUtil.isEmpty(className)) {
                    result.getSuggestedRoots().add(className.trim());
                }
                ++n2;
            }
            iConfigurationElementArray = cfg.getChildren(DOCUMENT_ROOT_ELEMENT);
            n = iConfigurationElementArray.length;
            n2 = 0;
            while (n2 < n) {
                child = iConfigurationElementArray[n2];
                className = child.getAttribute("className");
                if (!StringUtil.isEmpty(className)) {
                    result.getDocumentRootClassNames().add(className.trim());
                }
                ++n2;
            }
            return result;
        }
        return null;
    }

    private final class EPackageExtraDataListener
    implements IRegistryEventListener {
        private EPackageExtraDataListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void added(IExtension[] extensions) {
            EPackageMetaDataRegistryReader ePackageMetaDataRegistryReader = EPackageMetaDataRegistryReader.this;
            synchronized (ePackageMetaDataRegistryReader) {
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ext = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement cfg = iConfigurationElementArray[n4];
                        EPackageMetaData data = EPackageMetaDataRegistryReader.this.parse(cfg);
                        if (data != null) {
                            EPackageMetaDataRegistryReader.this.metaDataRegistry.register(data);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removed(IExtension[] extensions) {
            EPackageMetaDataRegistryReader ePackageMetaDataRegistryReader = EPackageMetaDataRegistryReader.this;
            synchronized (ePackageMetaDataRegistryReader) {
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ext = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement cfg = iConfigurationElementArray[n4];
                        if (EPackageMetaDataRegistryReader.EPACKAGE_META_DATA_ELEMENT.equals(cfg.getName())) {
                            String nsURI = cfg.getAttribute(EPackageMetaDataRegistryReader.NS_URI_ATTRIBUTE);
                            EPackageMetaDataRegistryReader.this.metaDataRegistry.unregister(nsURI);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }
    }
}

