/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.collections;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.acceleo.query.collections.LazyCollection;
import org.eclipse.acceleo.query.collections.Operation;

public class LazyList<E>
extends LazyCollection<E>
implements List<E> {
    public LazyList(Iterable<E> iterable) {
        super(iterable);
    }

    public LazyList(Iterable<E> iterable, int step) {
        super(iterable, step);
    }

    @Override
    protected Collection<E> createRealizedCollection() {
        return Lists.newArrayList();
    }

    @Override
    public void add(int arg0, E arg1) {
        throw new UnsupportedOperationException("operation isn't supported in LazyList instances");
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends E> arg1) {
        throw new UnsupportedOperationException("operation isn't supported in LazyList instances");
    }

    @Override
    public E get(int rank) {
        this.realize(rank);
        return ((List)this.getRealizedElements()).get(rank);
    }

    @Override
    public int indexOf(Object o) {
        boolean found = false;
        int currentIndex = ((List)this.getRealizedElements()).indexOf(o);
        if (currentIndex < 0) {
            currentIndex = this.getRealizedElements().size();
            while (!found && this.sourceHasNext()) {
                List elements = this.realizeNext();
                if (elements.contains(o)) {
                    found = true;
                    currentIndex += elements.indexOf(o);
                    continue;
                }
                currentIndex += elements.size();
            }
        }
        if (!found) {
            currentIndex = -1;
        }
        return currentIndex;
    }

    @Override
    public Iterator<E> iterator() {
        return new LazyListIterator(this);
    }

    @Override
    public int lastIndexOf(Object o) {
        LastIndexOperation operation = new LastIndexOperation(o);
        this.runFull(operation);
        return operation.lastIndex;
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException("operation isn't supported in LazyList instances");
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException("operation isn't supported in LazyList instances");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("operation isn't supported in LazyList instances");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("operation isn't supported in LazyList instances");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        while (this.sourceHasNext() && this.getRealizedElements().size() < toIndex) {
            this.realizeNext();
        }
        return ((List)this.getRealizedElements()).subList(fromIndex, toIndex);
    }

    class LastIndexOperation<E>
    implements Operation<E> {
        int lastIndex = 0;
        int currentIndex = 0;
        Object searchedElt;

        LastIndexOperation(Object elt) {
            this.searchedElt = elt;
        }

        @Override
        public void execute(E element) {
            if (this.searchedElt.equals(element)) {
                this.lastIndex = this.currentIndex;
            }
            ++this.currentIndex;
        }
    }

    class LazyListIterator<E>
    implements Iterator<E> {
        private List<E> iterated;
        private int currentRank;

        LazyListIterator(List<E> list) {
            this.iterated = list;
        }

        @Override
        public boolean hasNext() {
            return this.currentRank < this.iterated.size();
        }

        @Override
        public E next() {
            return this.iterated.get(this.currentRank++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("removal operatino is not supported");
        }
    }
}

