/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorCollectionCall;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorFeatureAccessOrCall;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorVariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.CompletionServices;
import org.eclipse.acceleo.query.runtime.impl.completion.ServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.TextCompletionProposal;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;

public class AstCompletor
extends AstSwitch<List<ICompletionProposal>> {
    private static final String SPACE = " ";
    private final CompletionServices services;
    private List<String> variableNames;
    private IValidationResult validationResult;

    public AstCompletor(CompletionServices services) {
        this.services = services;
    }

    public List<ICompletionProposal> getProposals(Set<String> varNames, IValidationResult validationRes) {
        List<ICompletionProposal> result;
        this.validationResult = validationRes;
        this.variableNames = new ArrayList<String>(varNames);
        Collections.sort(this.variableNames);
        List<Error> errors = validationRes.getAstResult().getErrors();
        if (errors.size() > 0) {
            result = (List<ICompletionProposal>)this.doSwitch(errors.get(0));
        } else {
            Set<IType> possibleTypes = this.validationResult.getPossibleTypes(this.validationResult.getAstResult().getAst());
            result = this.getExpressionTextFollows(possibleTypes);
        }
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorExpression(ErrorExpression object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.addAll(this.getExpressionTextPrefixes());
        result.addAll(this.services.getVariableProposals(this.variableNames));
        result.addAll(this.services.getEClassifierProposals());
        result.addAll(this.services.getEEnumLiteralProposals());
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorFeatureAccessOrCall(ErrorFeatureAccessOrCall object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        Set<IType> possibleTypes = this.validationResult.getPossibleTypes(object.getTarget());
        result.addAll(this.services.getEStructuralFeatureProposals(possibleTypes));
        result.addAll(this.services.getServiceProposals(possibleTypes, false));
        result.addAll(this.services.getEOperationProposals(possibleTypes));
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorTypeLiteral(ErrorTypeLiteral object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (object.getSegments().size() == 0) {
            result.addAll(this.services.getEClassifierProposals());
            result.addAll(this.services.getEEnumLiteralProposals());
        } else if (object.getSegments().size() == 1) {
            result.addAll(this.services.getEClassifierProposals((String)object.getSegments().get(0)));
            result.addAll(this.services.getEEnumLiteralProposals((String)object.getSegments().get(0)));
        } else if (object.getSegments().size() == 2) {
            result.addAll(this.services.getEEnumLiteralProposals((String)object.getSegments().get(0), (String)object.getSegments().get(1)));
        }
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorCollectionCall(ErrorCollectionCall object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        LinkedHashSet<IType> collectionTypes = new LinkedHashSet<IType>();
        for (IType type : this.validationResult.getPossibleTypes(object.getTarget())) {
            collectionTypes.add(new SequenceType(type));
            collectionTypes.add(new SetType(type));
        }
        result.addAll(this.services.getServiceProposals(collectionTypes, false));
        return result;
    }

    @Override
    public List<ICompletionProposal> caseErrorVariableDeclaration(ErrorVariableDeclaration object) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.addAll(this.services.getVariableDeclarationProposals(this.validationResult.getPossibleTypes(object.getExpression())));
        return result;
    }

    public List<ICompletionProposal> getExpressionTextPrefixes() {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.add(new TextCompletionProposal("not ", 0));
        result.add(new TextCompletionProposal("- ", 0));
        result.add(new TextCompletionProposal("()", 1));
        result.add(new TextCompletionProposal("true", 0));
        result.add(new TextCompletionProposal("false", 0));
        result.add(new TextCompletionProposal("null", 0));
        result.add(new TextCompletionProposal("{}", 1));
        result.add(new TextCompletionProposal("[]", 1));
        result.add(new TextCompletionProposal("Sequence{}", 1));
        result.add(new TextCompletionProposal("OrderedSet{}", 1));
        return result;
    }

    private List<ICompletionProposal> getExpressionTextFollows(Set<IType> possibleTypes) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        List<ServiceCompletionProposal> servicesProposal = this.services.getServiceProposals(possibleTypes, true);
        HashSet<String> serviceNames = new HashSet<String>();
        for (ServiceCompletionProposal proposal : servicesProposal) {
            serviceNames.add(proposal.getObject().getServiceMethod().getName());
        }
        if (serviceNames.contains("add")) {
            result.add(new TextCompletionProposal("+ ", 0));
        }
        if (serviceNames.contains("sub")) {
            result.add(new TextCompletionProposal("- ", 0));
        }
        if (serviceNames.contains("lessThanEqual")) {
            result.add(new TextCompletionProposal("<= ", 0));
        }
        if (serviceNames.contains("greaterThanEqual")) {
            result.add(new TextCompletionProposal(">= ", 0));
        }
        if (serviceNames.contains("differs")) {
            result.add(new TextCompletionProposal("<> ", 0));
        }
        if (serviceNames.contains("equals")) {
            result.add(new TextCompletionProposal("= ", 0));
        }
        if (serviceNames.contains("lessThan")) {
            result.add(new TextCompletionProposal("< ", 0));
        }
        if (serviceNames.contains("greaterThan")) {
            result.add(new TextCompletionProposal("> ", 0));
        }
        if (serviceNames.contains("mult")) {
            result.add(new TextCompletionProposal("* ", 0));
        }
        if (serviceNames.contains("div")) {
            result.add(new TextCompletionProposal("/ ", 0));
        }
        if (serviceNames.contains("and")) {
            result.add(new TextCompletionProposal("and ", 0));
        }
        if (serviceNames.contains("or")) {
            result.add(new TextCompletionProposal("or ", 0));
        }
        return result;
    }
}

