/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EPackageProvider {
    private Map<String, EPackage> ePackages = new HashMap<String, EPackage>();
    private final Map<Class<?>, Set<EClassifier>> class2classifiers = new HashMap();
    private final Map<Integer, Map<String, List<EOperation>>> eOperations = new HashMap<Integer, Map<String, List<EOperation>>>();
    private final List<EOperation> eOperationsList = new ArrayList<EOperation>();
    private final Map<EClass, Set<EStructuralFeature>> containingFeatures = new HashMap<EClass, Set<EStructuralFeature>>();
    private final Map<EClass, Set<EClass>> subTypes = new HashMap<EClass, Set<EClass>>();
    private Logger logger;

    public EPackageProvider(Logger logger) {
        this.logger = logger;
    }

    public EPackageProvider() {
        this.logger = Logger.getLogger("EPackageProvider");
    }

    public EPackage getEPackage(String nsPrefix) {
        return this.ePackages.get(nsPrefix);
    }

    public void removePackage(String nsPrefix) {
        EPackage ePackage = this.ePackages.remove(nsPrefix);
        if (ePackage != null) {
            for (EClassifier eCls : ePackage.getEClassifiers()) {
                this.removeEClassifierClass(eCls);
                if (!(eCls instanceof EClass)) continue;
                this.removeEOperations((EClass)eCls);
                this.removeContainingFeature((EClass)eCls);
                this.removeSubType((EClass)eCls);
            }
            for (EPackage childPkg : ePackage.getESubpackages()) {
                this.removePackage(childPkg.getNsPrefix());
            }
        }
    }

    private void removeSubType(EClass eCls) {
        for (EClass superECls : eCls.getESuperTypes()) {
            Set<EClass> types = this.subTypes.get(superECls);
            if (types == null || !types.remove(eCls) || types.size() != 0) continue;
            types = new LinkedHashSet<EClass>();
            this.subTypes.remove(superECls);
        }
    }

    private void removeContainingFeature(EClass eCls) {
        for (EStructuralFeature feature : eCls.getEStructuralFeatures()) {
            Set<EStructuralFeature> possibleContainementFeatures;
            if (!(feature.getEType() instanceof EClass) || (!(feature instanceof EReference) || !((EReference)feature).isContainment()) && !(feature instanceof EAttribute) || (possibleContainementFeatures = this.containingFeatures.get(feature.getEType())) == null || !possibleContainementFeatures.remove(feature) || possibleContainementFeatures.size() != 0) continue;
            this.containingFeatures.remove(feature.getEType());
        }
    }

    private void removeEOperations(EClass eCls) {
        for (EOperation eOperation : eCls.getEOperations()) {
            List<EOperation> multiEOperation = this.getMultiEOperation(eOperation.getName(), eOperation.getEParameters().size());
            if (multiEOperation != null && multiEOperation.remove(eOperation) && multiEOperation.size() == 0) {
                this.eOperations.get(eOperation.getEParameters().size()).remove(eOperation.getName());
            }
            this.eOperationsList.remove(eOperation);
        }
    }

    private void removeEClassifierClass(EClassifier eCls) {
        Class instanceClass = eCls.getInstanceClass();
        Set<EClassifier> classifiers = this.class2classifiers.get(instanceClass);
        if (classifiers.size() == 1) {
            this.class2classifiers.remove(instanceClass);
        } else {
            classifiers.remove(eCls);
        }
    }

    public void registerPackage(EPackage ePackage) {
        if (ePackage.getNsPrefix() != null) {
            this.ePackages.put(ePackage.getNsPrefix(), ePackage);
            for (EClassifier eCls : ePackage.getEClassifiers()) {
                this.registerEClassifierClass(eCls);
                if (!(eCls instanceof EClass)) continue;
                this.registerEOperations((EClass)eCls);
                this.registerContainingFeature((EClass)eCls);
                this.registerSubTypes((EClass)eCls);
            }
            for (EPackage childPkg : ePackage.getESubpackages()) {
                this.registerPackage(childPkg);
            }
        } else {
            this.logger.log(Level.WARNING, "Couldn't register package " + ePackage.getName() + " because it's nsPrefix is null.");
        }
    }

    private void registerSubTypes(EClass eCls) {
        for (EClass superECls : eCls.getESuperTypes()) {
            Set<EClass> types = this.subTypes.get(superECls);
            if (types == null) {
                types = new LinkedHashSet<EClass>();
                this.subTypes.put(superECls, types);
            }
            types.add(eCls);
        }
    }

    private void registerContainingFeature(EClass eCls) {
        for (EStructuralFeature feature : eCls.getEStructuralFeatures()) {
            if (!(feature.getEType() instanceof EClass) || (!(feature instanceof EReference) || !((EReference)feature).isContainment()) && !(feature instanceof EAttribute)) continue;
            Set<EStructuralFeature> possibleContainementFeatures = this.containingFeatures.get(feature.getEType());
            if (possibleContainementFeatures == null) {
                possibleContainementFeatures = new LinkedHashSet<EStructuralFeature>();
                this.containingFeatures.put((EClass)feature.getEType(), possibleContainementFeatures);
            }
            possibleContainementFeatures.add(feature);
        }
    }

    private void registerEClassifierClass(EClassifier eCls) {
        Class instanceClass = eCls.getInstanceClass();
        Set<EClassifier> classifiers = this.class2classifiers.get(instanceClass);
        if (classifiers == null) {
            classifiers = new LinkedHashSet<EClassifier>();
            this.class2classifiers.put(instanceClass, classifiers);
        }
        classifiers.add(eCls);
    }

    private void registerEOperations(EClass eCls) {
        for (EOperation eOperation : eCls.getEOperations()) {
            List<EOperation> multiEOperation = this.getOrCreateMultimethod(eOperation.getName(), eOperation.getEParameters().size());
            multiEOperation.add(eOperation);
            this.eOperationsList.add(eOperation);
        }
    }

    public EOperation lookupEOperation(EClass receiverEClass, String eOperationName, List<EParameter> parameterTypes) {
        EOperation result;
        List<EOperation> multiEOperations = this.getMultiEOperation(eOperationName, parameterTypes.size());
        if (multiEOperations != null) {
            EOperation compatibleEOperation = null;
            Iterator<EOperation> iterator = multiEOperations.iterator();
            while (iterator.hasNext()) {
                EOperation eOperation;
                compatibleEOperation = eOperation = iterator.next();
                if (eOperation.getEContainingClass().isSuperTypeOf(receiverEClass)) {
                    Iterator<EParameter> it = parameterTypes.iterator();
                    for (EParameter parameter : eOperation.getEParameters()) {
                        if (this.isCompatibleType(parameter, it.next())) continue;
                        compatibleEOperation = null;
                        break;
                    }
                }
                if (compatibleEOperation != null) break;
            }
            result = compatibleEOperation;
        } else {
            result = null;
        }
        return result;
    }

    public Set<EOperation> getEOperations(Set<EClass> receiverTypes) {
        LinkedHashSet<EOperation> result = new LinkedHashSet<EOperation>();
        for (EClass eCls : receiverTypes) {
            for (EOperation eOperation : this.eOperationsList) {
                if (!eOperation.getEContainingClass().isSuperTypeOf(eCls)) continue;
                result.add(eOperation);
            }
        }
        return result;
    }

    private boolean isCompatibleType(EParameter parameter, EParameter passedParameter) {
        boolean result = parameter.isMany() == passedParameter.isMany() ? (parameter.getEType() instanceof EClass && passedParameter.getEType() instanceof EClass ? ((EClass)parameter.getEType()).isSuperTypeOf((EClass)passedParameter.getEType()) : (passedParameter.getEType() != null ? parameter.getEType() == passedParameter.getEType() : true)) : false;
        return result;
    }

    public EClassifier getType(String nsPrefix, String classifierName) {
        EPackage ePackage = this.ePackages.get(nsPrefix);
        if (ePackage != null) {
            return ePackage.getEClassifier(classifierName);
        }
        return null;
    }

    public EClassifier getType(String classifierName) {
        EClassifier result = null;
        for (EPackage ePackage : this.ePackages.values()) {
            EClassifier foundClassifier = ePackage.getEClassifier(classifierName);
            if (foundClassifier == null) continue;
            if (result == null) {
                result = foundClassifier;
                continue;
            }
            String firstFullyQualifiedName = String.valueOf(result.getEPackage().getNsPrefix()) + "." + result.getName();
            String secondFullyQualifiedName = String.valueOf(foundClassifier.getEPackage().getNsPrefix()) + "." + foundClassifier.getName();
            String message = "Ambiguous classifier request. At least two classifiers matches %s : %s and %s";
            this.logger.warning(String.format(message, classifierName, firstFullyQualifiedName, secondFullyQualifiedName));
        }
        return result;
    }

    public EEnumLiteral getEnumLiteral(String nsPrefix, String enumName, String literalName) {
        EEnumLiteral result;
        EPackage ePackage = this.ePackages.get(nsPrefix);
        if (ePackage != null) {
            EClassifier eClassifier = ePackage.getEClassifier(enumName);
            result = this.getEnumLiteral(eClassifier, literalName);
        } else {
            result = null;
        }
        return result;
    }

    public EEnumLiteral getEnumLiteral(String enumName, String literalName) {
        EClassifier eClassifier = this.getType(enumName);
        if (eClassifier == null) {
            return null;
        }
        return this.getEnumLiteral(eClassifier, literalName);
    }

    private EEnumLiteral getEnumLiteral(EClassifier eClassifier, String literalName) {
        EEnumLiteral result = eClassifier instanceof EEnum ? ((EEnum)eClassifier).getEEnumLiteral(literalName) : null;
        return result;
    }

    public Set<EClassifier> getEClass(Class<?> cls) {
        return this.class2classifiers.get(cls);
    }

    public Class<?> getClass(EClassifier eCls) {
        return eCls.getInstanceClass();
    }

    public Set<EStructuralFeature> getEStructuralFeatures(Set<EClass> receiverEClasses) {
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
        for (EClass eCls : receiverEClasses) {
            result.addAll((Collection<EStructuralFeature>)eCls.getEAllStructuralFeatures());
        }
        return result;
    }

    public Set<EClassifier> getEClassifiers() {
        LinkedHashSet<EClassifier> result = new LinkedHashSet<EClassifier>();
        for (EPackage ePkg : this.ePackages.values()) {
            result.addAll((Collection<EClassifier>)ePkg.getEClassifiers());
        }
        return result;
    }

    public Set<EEnumLiteral> getEEnumLiterals() {
        LinkedHashSet<EEnumLiteral> result = new LinkedHashSet<EEnumLiteral>();
        for (EPackage ePkg : this.ePackages.values()) {
            for (EClassifier eClassifier : ePkg.getEClassifiers()) {
                if (!(eClassifier instanceof EEnum)) continue;
                result.addAll((Collection<EEnumLiteral>)((EEnum)eClassifier).getELiterals());
            }
        }
        return result;
    }

    private List<EOperation> getMultiEOperation(String eOperationName, int argc) {
        Map<String, List<EOperation>> argcServices = this.eOperations.get(argc);
        if (argcServices == null) {
            return null;
        }
        return argcServices.get(eOperationName);
    }

    private List<EOperation> getOrCreateMultimethod(String eOperationName, int argc) {
        List<EOperation> result;
        Map<String, List<EOperation>> argcEOperations = this.eOperations.get(argc);
        if (argcEOperations == null) {
            argcEOperations = new HashMap<String, List<EOperation>>();
            this.eOperations.put(argc, argcEOperations);
        }
        if ((result = argcEOperations.get(eOperationName)) == null) {
            result = new ArrayList<EOperation>();
            argcEOperations.put(eOperationName, result);
        }
        return result;
    }

    public Set<EClass> getAllContainingEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        result.addAll(this.getContainingClasses(eCls));
        for (EClass superType : eCls.getEAllSuperTypes()) {
            result.addAll(this.getContainingClasses(superType));
        }
        for (EClass subType : this.getAllSubTypes(eCls)) {
            result.addAll(this.getContainingClasses(subType));
        }
        return result;
    }

    private Set<EClass> getContainingClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EStructuralFeature> features = this.containingFeatures.get(eCls);
        if (features != null) {
            for (EStructuralFeature feature : features) {
                result.add(feature.getEContainingClass());
            }
        }
        return result;
    }

    public Set<EClass> getAllSubTypes(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EClass> types = this.subTypes.get(eCls);
        if (types != null) {
            for (EClass type : types) {
                result.add(type);
                result.addAll(this.getAllSubTypes(type));
            }
        }
        return result;
    }
}

