/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.logging.Logger;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.InvalidAcceleoPackageException;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.acceleo.query.runtime.lookup.basic.BasicLookupEngine;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.services.BooleanServices;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.acceleo.query.services.NumberServices;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.emf.ecore.EPackage;

public class QueryEnvironment
implements IQueryEnvironment {
    private Logger logger;
    private BasicLookupEngine lookupEngine;
    private EPackageProvider ePackageProvider = new EPackageProvider();

    public QueryEnvironment(CrossReferenceProvider crossReferencer) {
        this.lookupEngine = new BasicLookupEngine(crossReferencer);
        this.initStandardServices();
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public QueryEnvironment(CrossReferenceProvider crossReferencer, Logger providedLogger) {
        this(crossReferencer);
        this.logger = providedLogger;
    }

    @Override
    public void registerServicePackage(Class<?> services) throws InvalidAcceleoPackageException {
        this.lookupEngine.addServices(services);
    }

    @Override
    public void registerEPackage(EPackage ePackage) {
        this.ePackageProvider.registerPackage(ePackage);
    }

    @Override
    public void removeEPackage(String nsPrefix) {
        this.ePackageProvider.removePackage(nsPrefix);
    }

    @Override
    public BasicLookupEngine getLookupEngine() {
        return this.lookupEngine;
    }

    @Override
    public EPackageProvider getEPackageProvider() {
        return this.ePackageProvider;
    }

    private void initStandardServices() {
        try {
            this.registerServicePackage(AnyServices.class);
            this.registerServicePackage(EObjectServices.class);
            this.registerServicePackage(NumberServices.class);
            this.registerServicePackage(StringServices.class);
            this.registerServicePackage(BooleanServices.class);
            this.registerServicePackage(CollectionServices.class);
        }
        catch (InvalidAcceleoPackageException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

