/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl;

import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.acceleo.ui.interpreter.completeocl.AbstractExporter;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.ConstraintElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.ConstraintResult;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OCLElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OCLResult;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OperationElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.Severity;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;

public class HTMLExporter
extends AbstractExporter {
    protected final OCL ocl;

    public HTMLExporter(OCL ocl) {
        this.ocl = ocl;
    }

    @Override
    public void createContents(Appendable html, String outputFileName, OCLElement resultRoot) throws IOException {
        this.appendHeader(html);
        this.appendGeneralInformation(html, outputFileName);
        html.append("\n");
        html.append("\n");
        int constraintstotal = this.getConstraintsCount();
        int operationstotal = this.getOperationsCount();
        this.appendMetrics(html, constraintstotal, operationstotal);
        this.appendConstraintsLogs(html, constraintstotal);
        this.appendOperationsLogs(html);
        this.appendFooter(html);
    }

    private void appendHeader(Appendable html) throws IOException {
        html.append("<html>\n");
        html.append("\t<head></head>\n");
        html.append("\t<body>\n");
    }

    private void appendGeneralInformation(Appendable html, String outputFileName) throws IOException {
        html.append("\t\t<h1>1. GENERAL INFORMATION</h1>\n");
        html.append("\t\t<table border=\"1\">\n");
        if (outputFileName != null) {
            html.append("\t\t\t<tr>\n");
            html.append("\t\t\t\t<td><b>Output file name: </b></td>\n");
            html.append("\t\t\t\t<td>" + outputFileName + "</td>\n");
            html.append("\t\t\t</tr>\n");
        }
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Author: </b></td>\n");
        html.append("\t\t\t\t<td>" + System.getProperty("user.name") + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t</table>\n");
    }

    private void appendMetrics(Appendable html, int constraintstotal, int operationstotal) throws IOException {
        html.append("\t\t<h1>2. METRICS</h1>\n");
        html.append("\n");
        html.append("\t\t<h1>2.1. Constraints METRICS</h1>\n");
        html.append("\n");
        html.append("\t\t<table border=\"1\">\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Total number of evaluated constraints: </b></td>\n");
        html.append("\t\t\t\t<td>" + constraintstotal + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Success: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.constraintsSuccess.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Infos: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.constraintsInfos.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Warnings: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.constraintsWarnings.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Errors: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.constraintsErrors.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t</table>\n");
        html.append("\n");
        html.append("\t\t<h1>2.2. Statistics METRICS</h1>\n");
        html.append("\n");
        html.append("\t\t<table border=\"1\">\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Total number of evaluated operations: </b></td>\n");
        html.append("\t\t\t\t<td>" + operationstotal + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Success: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.operationsSuccess.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Infos: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.operationsInfos.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Warnings: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.operationsWarnings.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t\t<tr>\n");
        html.append("\t\t\t\t<td><b>Number of Errors: </b></td>\n");
        html.append("\t\t\t\t<td>" + this.operationsErrors.size() + "</td>\n");
        html.append("\t\t\t</tr>\n");
        html.append("\t\t</table>\n");
    }

    private void appendConstraintsLogs(Appendable html, int constraintstotal) throws IOException {
        html.append("\t\t<h1>3. LOGS</h1>\n");
        if (this.constraintsSuccess.size() == constraintstotal) {
            html.append("<p>No log to display: all constraints has been successfully evaluated on the current model.</p>\n");
        } else {
            int section = 1;
            if (!this.constraintsInfos.isEmpty()) {
                html.append("\t\t<h2>3." + section + ". Infos</h2>\n");
                html.append("\t\t<table border=\"1\">\n");
                this.appendConstraintsTitlesTable(html);
                for (ConstraintElement infoElement : this.constraintsInfos) {
                    this.appendConstraintLog(html, infoElement, Severity.INFO.getLiteral());
                }
                html.append("\t\t</table>\n");
                ++section;
            }
            if (!this.constraintsWarnings.isEmpty()) {
                html.append("\t\t<h2>3." + section + ". Warnings</h2>\n");
                html.append("\t\t<table border=\"1\">\n");
                this.appendConstraintsTitlesTable(html);
                for (ConstraintElement warningElement : this.constraintsWarnings) {
                    this.appendConstraintLog(html, warningElement, Severity.WARNING.getLiteral());
                }
                html.append("\t\t</table>\n");
                ++section;
            }
            if (!this.constraintsErrors.isEmpty()) {
                html.append("\t\t<h2>3." + section + ". Errors</h2>\n");
                html.append("\t\t<table border=\"1\">\n");
                this.appendConstraintsTitlesTable(html);
                for (ConstraintElement errorElement : this.constraintsErrors) {
                    this.appendConstraintLog(html, errorElement, Severity.ERROR.getLiteral());
                }
                html.append("\t\t</table>\n");
                ++section;
            }
        }
    }

    private void appendConstraintsTitlesTable(Appendable s) throws IOException {
        s.append("\t\t\t<tr>\n");
        s.append("\t\t\t\t<td><b>Context</b></td>\n");
        s.append("\t\t\t\t<td><b>Invariant</b></td>\n");
        s.append("\t\t\t\t<td><b>Expression</b></td>\n");
        s.append("\t\t\t\t<td><b>Evaluation Target</b></td>\n");
        s.append("\t\t\t\t<td><b>Severity</b></td>\n");
        s.append("\t\t\t\t<td><b>Message</b></td>\n");
        s.append("\t\t\t</tr>\n");
    }

    private void appendConstraintLog(Appendable s, ConstraintElement constraintElement, String severity) throws IOException {
        EObject element = constraintElement.getElement();
        if (element instanceof Constraint) {
            Constraint constraint = (Constraint)element;
            String context = constraint.getContext().toString();
            String identifier = constraint.getName();
            try {
                LanguageExpression spec = constraint.getOwnedSpecification();
                ExpressionInOCL expressionInOCL = this.ocl.parseSpecification((EObject)constraint, spec);
                String expression = expressionInOCL.toString();
                for (ConstraintResult result : constraintElement.getConstraintResults()) {
                    s.append("\t\t\t<tr>\n");
                    this.appendConstraintsResult(s, context, identifier, expression, severity, result);
                    s.append("\t\t\t</tr>\n");
                }
            }
            catch (ParserException parserException) {}
        }
    }

    private void appendConstraintsResult(Appendable s, String context, String identifier, String expression, String severity, OCLResult result) throws IOException {
        if (context != null) {
            s.append("\t\t\t\t<td>" + context + "</td>\n");
        } else {
            s.append("\t\t\t\t<td>The context of this constraint is unattainable</td>\n");
        }
        if (identifier != null) {
            s.append("\t\t\t\t<td>" + identifier + "</td>\n");
        } else {
            s.append("\t\t\t\t<td>The identifier of this constraint is unattainable</td>\n");
        }
        if (expression != null) {
            s.append("\t\t\t\t<td>" + expression + "</td>\n");
        } else {
            s.append("\t\t\t\t<td>The Expression of this constraint is unattainable</td>\n");
        }
        s.append("\t\t\t\t<td>" + this.getEvaluationTargetText(result.getEvaluationTarget()) + "</td>\n");
        s.append("\t\t\t\t<td>" + severity + "</td>\n");
        s.append("\t\t\t\t<td>" + StringEscapeUtils.escapeHtml((String)this.getMessage(result)) + "</td>\n");
    }

    private void appendOperationsLogs(Appendable html) throws IOException {
        html.append("\t\t<h1>4. STATISTICS</h1>\n");
        int section = 1;
        if (this.operationsSuccess.isEmpty() && this.operationsInfos.isEmpty() && this.operationsWarnings.isEmpty() && this.operationsErrors.isEmpty()) {
            html.append("<p>No log to display: there is no operation to evaluate on the current model.</p>\n");
            return;
        }
        if (!this.operationsSuccess.isEmpty()) {
            html.append("\t\t<h2>4." + section + ". Success</h2>\n");
            html.append("\t\t<table border=\"1\">\n");
            this.appendOperationsTitlesTable(html);
            for (OperationElement successElement : this.operationsSuccess) {
                this.appendOperationLog(html, successElement, Severity.OK.getLiteral());
            }
            html.append("\t\t</table>\n");
            ++section;
        }
        if (!this.operationsInfos.isEmpty()) {
            html.append("\t\t<h2>4." + section + ". Infos</h2>\n");
            html.append("\t\t<table border=\"1\">\n");
            this.appendOperationsTitlesTable(html);
            for (OperationElement infoElement : this.operationsInfos) {
                this.appendOperationLog(html, infoElement, Severity.INFO.getLiteral());
            }
            html.append("\t\t</table>\n");
            ++section;
        }
        if (!this.operationsWarnings.isEmpty()) {
            html.append("\t\t<h2>4." + section + ". Warnings</h2>\n");
            html.append("\t\t<table border=\"1\">\n");
            this.appendOperationsTitlesTable(html);
            for (OperationElement warningElement : this.operationsWarnings) {
                this.appendOperationLog(html, warningElement, Severity.WARNING.getLiteral());
            }
            html.append("\t\t</table>\n");
            ++section;
        }
        if (!this.operationsErrors.isEmpty()) {
            html.append("\t\t<h2>4." + section + ". Errors</h2>\n");
            html.append("\t\t<table border=\"1\">\n");
            this.appendOperationsTitlesTable(html);
            for (OperationElement errorElement : this.operationsErrors) {
                this.appendOperationLog(html, errorElement, Severity.ERROR.getLiteral());
            }
            html.append("\t\t</table>\n");
            ++section;
        }
    }

    private void appendOperationsTitlesTable(Appendable s) throws IOException {
        s.append("\t\t\t<tr>\n");
        s.append("\t\t\t\t<td><b>Context</b></td>\n");
        s.append("\t\t\t\t<td><b>Operation</b></td>\n");
        s.append("\t\t\t\t<td><b>Expression</b></td>\n");
        s.append("\t\t\t\t<td><b>Evaluation Target</b></td>\n");
        s.append("\t\t\t\t<td><b>Severity</b></td>\n");
        s.append("\t\t\t\t<td><b>Result</b></td>\n");
        s.append("\t\t\t</tr>\n");
    }

    private void appendOperationLog(Appendable s, OperationElement operationElement, String severity) throws IOException {
        EObject element = operationElement.getElement();
        if (element instanceof Operation) {
            Operation operation = (Operation)element;
            String context = operation.getOwningClass().toString();
            String identifier = operation.getName();
            try {
                LanguageExpression spec = operation.getBodyExpression();
                ExpressionInOCL expressionInOCL = this.ocl.parseSpecification((EObject)operation, spec);
                String expression = expressionInOCL.toString();
                for (OCLResult result : operationElement.getEvaluationResults()) {
                    s.append("\t\t\t<tr>\n");
                    this.appendOperationsResult(s, context, identifier, expression, severity, result);
                    s.append("\t\t\t</tr>\n");
                }
            }
            catch (ParserException parserException) {}
        }
    }

    private void appendOperationsResult(Appendable s, String context, String identifier, String expression, String severity, OCLResult result) throws IOException {
        if (context != null) {
            s.append("\t\t\t\t<td>" + context + "</td>\n");
        } else {
            s.append("\t\t\t\t<td>The context of this operation is unattainable</td>\n");
        }
        if (identifier != null) {
            s.append("\t\t\t\t<td>" + identifier + "</td>\n");
        } else {
            s.append("\t\t\t\t<td>The identifier of this operation is unattainable</td>\n");
        }
        if (expression != null) {
            s.append("\t\t\t\t<td>" + expression + "</td>\n");
        } else {
            s.append("\t\t\t\t<td>The Expression of this operation is unattainable</td>\n");
        }
        s.append("\t\t\t\t<td>" + this.getEvaluationTargetText(result.getEvaluationTarget()) + "</td>\n");
        s.append("\t\t\t\t<td>" + severity + "</td>\n");
        s.append("\t\t\t\t<td>" + result.getInterpreterResult().getEvaluationResult() + "</td>\n");
    }

    private void appendFooter(Appendable html) throws IOException {
        html.append("</body>\n");
        html.append("</html>\n");
    }

    private String getEvaluationTargetText(EObject evaluationTarget) {
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemLabelProvider provider = (IItemLabelProvider)factory.adapt((Notifier)evaluationTarget, IItemLabelProvider.class);
        if (provider != null) {
            return provider.getText((Object)evaluationTarget);
        }
        return evaluationTarget.toString();
    }
}

