/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.core;

import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.compatibility.model.mt.Resource;
import org.eclipse.acceleo.compatibility.model.mt.ResourceSet;
import org.eclipse.acceleo.compatibility.model.mt.core.CoreFactory;
import org.eclipse.acceleo.compatibility.model.mt.core.Method;
import org.eclipse.acceleo.compatibility.model.mt.core.Parameter;
import org.eclipse.acceleo.compatibility.model.mt.core.Service;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class ServiceParser {
    private ServiceParser() {
    }

    public static Service createImportedService(String qualifiedName, ResourceSet root) {
        String shortName = qualifiedName;
        String path = "";
        int jDot = qualifiedName.lastIndexOf(".");
        if (jDot > -1) {
            shortName = qualifiedName.substring(jDot + 1);
            path = qualifiedName.substring(0, jDot);
        }
        if (shortName.length() > 0) {
            shortName = String.valueOf(shortName.substring(0, 1).toUpperCase()) + shortName.substring(1);
        }
        if (path.length() > 0) {
            return ServiceParser.getOrCreateService(String.valueOf(path) + '.' + shortName, root);
        }
        return ServiceParser.getOrCreateService(shortName, root);
    }

    public static Service createImplicitService(IFile file, ResourceSet root) {
        String name = new Path(file.getName()).removeFileExtension().lastSegment();
        if (name.length() > 0) {
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        }
        String[] segments = ServiceParser.getPackagePath(file).append(name).segments();
        StringBuffer qualifiedName = new StringBuffer();
        qualifiedName.append(segments[0]);
        int i = 1;
        while (i < segments.length) {
            qualifiedName.append('.');
            qualifiedName.append(segments[i]);
            ++i;
        }
        return ServiceParser.getOrCreateService(qualifiedName.toString(), root);
    }

    private static IPath getPackagePath(IFile file) {
        if (file != null && file.isAccessible()) {
            return file.getProjectRelativePath().removeLastSegments(1).removeFirstSegments(1);
        }
        return new Path("");
    }

    private static Service getOrCreateService(String qualifiedName, ResourceSet root) {
        for (Resource resource : root.getResources()) {
            if (!(resource instanceof Service) || resource.getName() == null || !resource.getName().equals(qualifiedName)) continue;
            return (Service)resource;
        }
        Class javaClass = AcceleoWorkspaceUtil.INSTANCE.getClass(qualifiedName, false);
        Service result = javaClass != null ? ServiceParser.createService(javaClass, root) : null;
        return result;
    }

    private static Service createService(Class<?> javaClass, ResourceSet root) {
        Service service = CoreFactory.eINSTANCE.createService();
        root.getResources().add((Object)service);
        service.setName(javaClass.getName());
        java.lang.reflect.Method[] javaMethods = javaClass.getDeclaredMethods();
        int i = 0;
        while (i < javaMethods.length) {
            java.lang.reflect.Method javaMethod = javaMethods[i];
            Method method = CoreFactory.eINSTANCE.createMethod();
            service.getMethods().add((Object)method);
            method.setName(javaMethod.getName());
            if (javaMethod.getReturnType() != null) {
                method.setReturn(javaMethod.getReturnType().getName());
            } else {
                method.setReturn("void");
            }
            Class<?>[] javaParameters = javaMethod.getParameterTypes();
            int j = 0;
            while (j < javaParameters.length) {
                Class<?> javaParameter = javaParameters[j];
                Parameter parameter = CoreFactory.eINSTANCE.createParameter();
                method.getParameters().add((Object)parameter);
                if (javaParameter != null) {
                    parameter.setType(javaParameter.getName());
                } else {
                    parameter.setType("void");
                }
                ++j;
            }
            ++i;
        }
        return service;
    }
}

