/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Literal;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.parser.AstEvaluator;
import org.eclipse.acceleo.query.parser.QueryBaseListener;
import org.eclipse.acceleo.query.parser.QueryParser;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;

public class AstBuilderListener
extends QueryBaseListener {
    public static final String NOT_SERVICE_NAME = "not";
    public static final String NOT_OPERATOR = "not";
    public static final String DIFFERS_SERVICE_NAME = "differs";
    public static final String DIFFERS_OPERATOR = "<>";
    public static final String EQUALS_SERVICE_NAME = "equals";
    public static final String EQUALS_OPERATOR = "=";
    public static final String GREATER_THAN_EQUAL_SERVICE_NAME = "greaterThanEqual";
    public static final String GREATER_THAN_EQUAL_OPERATOR = ">=";
    public static final String GREATER_THAN_SERVICE_NAME = "greaterThan";
    public static final String GREATER_THAN_OPERATOR = ">";
    public static final String LESS_THAN_EQUAL_SERVICE_NAME = "lessThanEqual";
    public static final String LESS_THAN_EQUAL_OPERATOR = "<=";
    public static final String LESS_THAN_SERVICE_NAME = "lessThan";
    public static final String LESS_THAN_OPERATOR = "<";
    public static final String DIV_SERVICE_NAME = "divOp";
    public static final String DIV_OPERATOR = "/";
    public static final String MULT_SERVICE_NAME = "mult";
    public static final String MULT_OPERATOR = "*";
    public static final String SUB_SERVICE_NAME = "sub";
    public static final String SUB_OPERATOR = "-";
    public static final String ADD_SERVICE_NAME = "add";
    public static final String ADD_OPERATOR = "+";
    public static final String UNARY_MIN_SERVICE_NAME = "unaryMin";
    public static final String UNARY_MIN_OPERATOR = "-";
    public static final String AND_SERVICE_NAME = "and";
    public static final String AND_OPERATOR = "and";
    public static final String OR_SERVICE_NAME = "or";
    public static final String OR_OPERATOR = "or";
    public static final String XOR_SERVICE_NAME = "xor";
    public static final String XOR_OPERATOR = "xor";
    public static final String IMPLIES_SERVICE_NAME = "implies";
    public static final String IMPLIES_OPERATOR = "implies";
    public static final Set<String> OPERATOR_SERVICE_NAMES = AstBuilderListener.initOperatorServiceNames();
    private static final String THIS_SHOULDN_T_HAPPEN = "This shouldn't happen.";
    private static final int NO_ERROR = -1;
    private static final int FULLY_QUALIFIED_NAME = 3;
    private static final String INTERNAL_ERROR_MSG = "Internal exception occured while evaluating an expression";
    private Stack<Object> stack = new Stack();
    private int errorRule = -1;
    private final List<Error> errors = new ArrayList<Error>();
    private final ANTLRErrorListener errorListener = new QueryErrorListener();
    private AstBuilder builder = new AstBuilder();
    private IQueryEnvironment environment;

    public AstBuilderListener(IQueryEnvironment environment) {
        this.environment = environment;
    }

    private static Set<String> initOperatorServiceNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(ADD_SERVICE_NAME);
        result.add("and");
        result.add(DIFFERS_SERVICE_NAME);
        result.add(DIV_SERVICE_NAME);
        result.add(EQUALS_SERVICE_NAME);
        result.add(GREATER_THAN_EQUAL_SERVICE_NAME);
        result.add(GREATER_THAN_SERVICE_NAME);
        result.add("implies");
        result.add(LESS_THAN_EQUAL_SERVICE_NAME);
        result.add(LESS_THAN_SERVICE_NAME);
        result.add(MULT_SERVICE_NAME);
        result.add("not");
        result.add("or");
        result.add(SUB_SERVICE_NAME);
        result.add(UNARY_MIN_SERVICE_NAME);
        result.add("xor");
        return result;
    }

    public IQueryBuilderEngine.AstResult getAstResult() {
        return new IQueryBuilderEngine.AstResult(this.pop(), this.errors);
    }

    private Expression pop() {
        try {
            return (Expression)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException cce) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, cce);
        }
    }

    private String popString() {
        try {
            return (String)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private VariableDeclaration popVariableDeclaration() {
        try {
            return (VariableDeclaration)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private TypeLiteral popTypeLiteral() {
        try {
            return (TypeLiteral)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private Expression[] popArgs() {
        try {
            return (Expression[])this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private void push(Object obj) {
        this.stack.push(obj);
    }

    private void pushError(Error error) {
        this.errors.add(error);
        this.stack.push(error);
    }

    @Override
    public void exitIntType(QueryParser.IntTypeContext ctx) {
        this.push(this.builder.typeLiteral(Boolean.class));
    }

    @Override
    public void exitFalseLit(QueryParser.FalseLitContext ctx) {
        this.push(this.builder.booleanLiteral(false));
    }

    @Override
    public void exitRealType(QueryParser.RealTypeContext ctx) {
        this.push(this.builder.realLiteral(Double.parseDouble(ctx.getText())));
    }

    @Override
    public void exitTrueLit(QueryParser.TrueLitContext ctx) {
        this.push(this.builder.booleanLiteral(true));
    }

    @Override
    public void exitSeqType(QueryParser.SeqTypeContext ctx) {
        TypeLiteral elementType = this.popTypeLiteral();
        this.push(this.builder.collectionTypeLiteral(List.class, elementType));
    }

    @Override
    public void exitSetType(QueryParser.SetTypeContext ctx) {
        TypeLiteral elementType = this.popTypeLiteral();
        this.push(this.builder.collectionTypeLiteral(Set.class, elementType));
    }

    @Override
    public void exitNot(QueryParser.NotContext ctx) {
        this.push(this.builder.callService(CallType.CALLSERVICE, "not", this.pop()));
    }

    @Override
    public void exitStringLit(QueryParser.StringLitContext ctx) {
        String text = ctx.getText();
        this.push(this.builder.stringLiteral(text.substring(1, text.length() - 1)));
    }

    @Override
    public void exitRealLit(QueryParser.RealLitContext ctx) {
        this.push(this.builder.realLiteral(Double.valueOf(ctx.getText())));
    }

    @Override
    public void exitStrType(QueryParser.StrTypeContext ctx) {
        this.push(this.builder.typeLiteral(String.class));
    }

    @Override
    public void exitOr(QueryParser.OrContext ctx) {
        this.pushBinary("or");
    }

    @Override
    public void exitXor(QueryParser.XorContext ctx) {
        this.pushBinary("xor");
    }

    @Override
    public void exitImplies(QueryParser.ImpliesContext ctx) {
        this.pushBinary("implies");
    }

    @Override
    public void exitBooleanType(QueryParser.BooleanTypeContext ctx) {
        this.push(this.builder.typeLiteral(Boolean.class));
    }

    @Override
    public void exitIntegerLit(QueryParser.IntegerLitContext ctx) {
        this.push(this.builder.integerLiteral(Integer.valueOf(ctx.getText())));
    }

    @Override
    public void exitAnd(QueryParser.AndContext ctx) {
        this.pushBinary("and");
    }

    @Override
    public void exitVarRef(QueryParser.VarRefContext ctx) {
        this.push(this.builder.varRef(ctx.getText()));
    }

    @Override
    public void exitFeature(QueryParser.FeatureContext ctx) {
        Expression receiver = this.pop();
        this.push(this.builder.featureAccess(receiver, ctx.getChild(1).getText()));
    }

    private void pushBinary(String service) {
        Expression op2 = this.pop();
        Expression op1 = this.pop();
        this.push(this.builder.callService(CallType.CALLSERVICE, service, op1, op2));
    }

    @Override
    public void exitServiceCall(QueryParser.ServiceCallContext ctx) {
        int childCount = ctx.getChild(2).getChildCount();
        int argc = 1 + (childCount == 0 ? 0 : 1 + childCount / 2);
        Expression[] args = new Expression[argc];
        int i = argc - 1;
        while (i >= 1) {
            args[i] = this.pop();
            --i;
        }
        String serviceName = ctx.getChild(0).getText().replace("::", ".");
        args[0] = this.pop();
        this.push(serviceName);
        this.push(args);
    }

    @Override
    public void exitMin(QueryParser.MinContext ctx) {
        this.push(this.builder.callService(CallType.CALLSERVICE, UNARY_MIN_SERVICE_NAME, this.pop()));
    }

    @Override
    public void exitAdd(QueryParser.AddContext ctx) {
        String op = ctx.getChild(1).getText();
        if (ADD_OPERATOR.equals(op)) {
            this.pushBinary(ADD_SERVICE_NAME);
        } else if ("-".equals(op)) {
            this.pushBinary(SUB_SERVICE_NAME);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitMult(QueryParser.MultContext ctx) {
        String op = ctx.getChild(1).getText();
        if (MULT_OPERATOR.equals(op)) {
            this.pushBinary(MULT_SERVICE_NAME);
        } else if (DIV_OPERATOR.equals(op)) {
            this.pushBinary(DIV_SERVICE_NAME);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitComp(QueryParser.CompContext ctx) {
        String op = ctx.getChild(1).getText();
        if (LESS_THAN_OPERATOR.equals(op)) {
            this.pushBinary(LESS_THAN_SERVICE_NAME);
        } else if (LESS_THAN_EQUAL_OPERATOR.equals(op)) {
            this.pushBinary(LESS_THAN_EQUAL_SERVICE_NAME);
        } else if (GREATER_THAN_OPERATOR.equals(op)) {
            this.pushBinary(GREATER_THAN_SERVICE_NAME);
        } else if (GREATER_THAN_EQUAL_OPERATOR.equals(op)) {
            this.pushBinary(GREATER_THAN_EQUAL_SERVICE_NAME);
        } else if (EQUALS_OPERATOR.equals(op)) {
            this.pushBinary(EQUALS_SERVICE_NAME);
        } else if (DIFFERS_OPERATOR.equals(op)) {
            this.pushBinary(DIFFERS_SERVICE_NAME);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    private TypeLiteral createModelType(QueryParser.ModelObjectTypeContext ctx) {
        TypeLiteral result;
        EClassifier type;
        String nsPrefix = null;
        String name = null;
        if (ctx.getChild(0).getChildCount() == 3) {
            nsPrefix = ctx.getChild(0).getChild(0).getText();
            name = ctx.getChild(0).getChild(2).getText();
            type = this.environment.getEPackageProvider().getType(nsPrefix, name);
        } else {
            name = ctx.getChild(0).getChild(0).getText();
            type = this.environment.getEPackageProvider().getType(name);
        }
        if (type == null) {
            ArrayList<String> segments = new ArrayList<String>(2);
            if (nsPrefix != null) {
                segments.add(nsPrefix);
            }
            if (name != null) {
                segments.add(name);
            }
            result = this.builder.errorTypeLiteral(segments.toArray(new String[segments.size()]));
            this.errors.add((ErrorTypeLiteral)result);
        } else {
            result = this.builder.typeLiteral(type);
        }
        return result;
    }

    private void callFilteredService(String serviceName, ParserRuleContext ctx) {
        if (this.errorRule == -1) {
            if (ctx.getChildCount() == 3) {
                Expression type = ctx.getChild(1) instanceof QueryParser.ModelObjectTypeContext ? this.createModelType((QueryParser.ModelObjectTypeContext)ctx.getChild(1)) : this.pop();
                Expression receiver = this.pop();
                this.push(serviceName);
                this.push(new Expression[]{receiver, type});
            } else {
                Expression receiver = this.pop();
                this.push(serviceName);
                this.push(new Expression[]{receiver});
            }
        } else {
            TypeLiteral type = this.popTypeLiteral();
            Expression receiver = this.pop();
            this.push(serviceName);
            this.push(new Expression[]{receiver, type});
        }
    }

    @Override
    public void exitEContent(QueryParser.EContentContext ctx) {
        this.callFilteredService("eContents", ctx);
    }

    @Override
    public void exitEAContent(QueryParser.EAContentContext ctx) {
        this.callFilteredService("eAllContents", ctx);
    }

    @Override
    public void exitEContainer(QueryParser.EContainerContext ctx) {
        this.callFilteredService("eContainer", ctx);
    }

    @Override
    public void exitEInverse(QueryParser.EInverseContext ctx) {
        this.callFilteredService("eInverse", ctx);
    }

    @Override
    public void exitFilter(QueryParser.FilterContext ctx) {
        this.callFilteredService("filter", ctx);
    }

    @Override
    public void exitAs(QueryParser.AsContext ctx) {
        this.callFilteredService("oclAsType", ctx);
    }

    @Override
    public void exitAsType(QueryParser.AsTypeContext ctx) {
        this.callFilteredService("oclAsType", ctx);
    }

    @Override
    public void exitCallService(QueryParser.CallServiceContext ctx) {
        if (this.errorRule != 5) {
            Expression[] args = this.popArgs();
            String serviceName = this.popString();
            this.push(this.builder.callService(CallType.COLLECTIONCALL, serviceName, args));
        }
    }

    @Override
    public void exitApply(QueryParser.ApplyContext ctx) {
        Expression[] args = this.popArgs();
        String serviceName = this.popString();
        this.push(this.builder.callService(CallType.CALLORAPPLY, serviceName, args));
    }

    @Override
    public void exitIsType(QueryParser.IsTypeContext ctx) {
        this.callFilteredService("oclIsTypeOf", ctx);
    }

    @Override
    public void exitIsKind(QueryParser.IsKindContext ctx) {
        this.callFilteredService("oclIsKindOf", ctx);
    }

    @Override
    public void exitVariableDefinition(QueryParser.VariableDefinitionContext ctx) {
        if (this.errorRule == -1) {
            Expression variableExpression = this.pop();
            VariableDeclaration variableDeclaration = ctx.getChildCount() == 4 ? this.builder.variableDeclaration(ctx.getChild(0).getText(), this.createModelType((QueryParser.ModelObjectTypeContext)ctx.getChild(2)), variableExpression) : this.builder.variableDeclaration(ctx.getChild(0).getText(), variableExpression);
            this.stack.push(variableDeclaration);
        }
    }

    @Override
    public void exitIterationCall(QueryParser.IterationCallContext ctx) {
        String serviceName = ctx.getChild(0).getText();
        Expression ast = this.pop();
        EvaluationServices service = new EvaluationServices(this.environment, true);
        VariableDeclaration iterator = this.popVariableDeclaration();
        Lambda lambda = this.builder.lambda(ast, new AstEvaluator(service), iterator);
        this.push(serviceName);
        this.push(new Expression[]{iterator.getExpression(), lambda});
    }

    @Override
    public void enterIterationCall(QueryParser.IterationCallContext ctx) {
        super.enterIterationCall(ctx);
    }

    @Override
    public void exitEnumOrClassifierLit(QueryParser.EnumOrClassifierLitContext ctx) {
        if (this.errorRule == -1) {
            String literalName = ctx.getChild(2).getText();
            Literal toPush = ctx.getChild(0).getChildCount() == 1 ? this.twoSegmentEnumOrClassifierLiteral(ctx, literalName) : this.threeSegmentEnumLiteral(ctx, literalName);
            this.push(toPush);
        }
    }

    private Literal twoSegmentEnumOrClassifierLiteral(QueryParser.EnumOrClassifierLitContext ctx, String literalName) {
        EClassifier classifier;
        String enumName = ctx.getChild(0).getChild(0).getText();
        EEnumLiteral literal = this.environment.getEPackageProvider().getEnumLiteral(enumName, literalName);
        Literal toPush = literal != null ? this.builder.enumLiteral(literal) : ((classifier = this.environment.getEPackageProvider().getType(enumName, literalName)) != null ? this.builder.typeLiteral(classifier) : this.builder.errorTypeLiteral(enumName, literalName));
        return toPush;
    }

    private Literal threeSegmentEnumLiteral(QueryParser.EnumOrClassifierLitContext ctx, String literalName) {
        String nsPrefix = ctx.getChild(0).getChild(0).getText();
        String enumName = ctx.getChild(0).getChild(2).getText();
        EEnumLiteral literal = this.environment.getEPackageProvider().getEnumLiteral(nsPrefix, enumName, literalName);
        Literal toPush = literal != null ? this.builder.enumLiteral(literal) : this.builder.errorTypeLiteral(nsPrefix, enumName, literalName);
        return toPush;
    }

    public ANTLRErrorListener getErrorListener() {
        return this.errorListener;
    }

    @Override
    public void exitNullLit(QueryParser.NullLitContext ctx) {
        this.push(this.builder.nullLiteral());
    }

    @Override
    public void exitSetLit(QueryParser.SetLitContext ctx) {
        this.push(this.builder.setInExtension(this.getExpressions(ctx)));
    }

    @Override
    public void exitExplicitSetLit(QueryParser.ExplicitSetLitContext ctx) {
        this.push(this.builder.setInExtension(this.getExpressions(ctx)));
    }

    private List<Expression> getExpressions(QueryParser.LiteralContext ctx) {
        int nbExpressions = (ctx.getChild(1).getChildCount() + 1) / 2;
        Expression[] expressions = new Expression[nbExpressions];
        int i = nbExpressions - 1;
        while (i >= 0) {
            expressions[i] = this.pop();
            --i;
        }
        return Arrays.asList(expressions);
    }

    @Override
    public void exitSeqLit(QueryParser.SeqLitContext ctx) {
        this.push(this.builder.sequenceInExtension(this.getExpressions(ctx)));
    }

    @Override
    public void exitExplicitSeqLit(QueryParser.ExplicitSeqLitContext ctx) {
        this.push(this.builder.sequenceInExtension(this.getExpressions(ctx)));
    }

    private final class QueryErrorListener
    extends BaseErrorListener {
        private QueryErrorListener() {
        }

        public void syntaxError(@NotNull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @NotNull String msg, @Nullable RecognitionException e) {
            QueryParser parser;
            if (e != null) {
                if (e.getCtx() instanceof QueryParser.IterationCallContext) {
                    AstBuilderListener.this.errorRule = 1;
                    AstBuilderListener.this.pushError(AstBuilderListener.this.builder.errorExpression());
                } else if (e.getCtx() instanceof QueryParser.TypeLiteralContext) {
                    if (e.getCtx().getParent() instanceof QueryParser.VariableDefinitionContext) {
                        AstBuilderListener.this.errorRule = 1;
                        String variableName = e.getCtx().getParent().getChild(0).getText();
                        ErrorTypeLiteral type = AstBuilderListener.this.builder.errorTypeLiteral(new String[0]);
                        AstBuilderListener.this.errors.add(type);
                        Expression variableExpression = AstBuilderListener.this.pop();
                        AstBuilderListener.this.push(AstBuilderListener.this.builder.variableDeclaration(variableName, type, variableExpression));
                        AstBuilderListener.this.pushError(AstBuilderListener.this.builder.errorExpression());
                    } else if (!(AstBuilderListener.this.stack.peek() instanceof TypeLiteral)) {
                        AstBuilderListener.this.errorRule = 12;
                        AstBuilderListener.this.pushError(AstBuilderListener.this.builder.errorTypeLiteral(new String[0]));
                    }
                } else if (e.getCtx() instanceof QueryParser.VariableDefinitionContext) {
                    if (e.getCtx().getChildCount() > 0) {
                        AstBuilderListener.this.errorRule = 1;
                        String variableName = e.getCtx().getChild(0).getText();
                        TypeLiteral type = AstBuilderListener.this.createModelType((QueryParser.ModelObjectTypeContext)e.getCtx().getChild(2));
                        Expression variableExpression = AstBuilderListener.this.pop();
                        AstBuilderListener.this.push(AstBuilderListener.this.builder.variableDeclaration(variableName, type, variableExpression));
                    } else {
                        Expression variableExpression = AstBuilderListener.this.pop();
                        AstBuilderListener.this.errorRule = 10;
                        AstBuilderListener.this.pushError(AstBuilderListener.this.builder.errorVariableDeclaration(variableExpression));
                    }
                    AstBuilderListener.this.pushError(AstBuilderListener.this.builder.errorExpression());
                } else if (e.getCtx() instanceof QueryParser.CallExpContext) {
                    AstBuilderListener.this.errorRule = 5;
                    AstBuilderListener.this.pushError(AstBuilderListener.this.builder.errorCollectionCall(AstBuilderListener.this.pop()));
                } else if (e.getCtx() instanceof QueryParser.NavigationSegmentContext) {
                    AstBuilderListener.this.errorRule = 5;
                    AstBuilderListener.this.pushError(AstBuilderListener.this.builder.errorFeatureAccessOrCall(AstBuilderListener.this.pop()));
                } else {
                    AstBuilderListener.this.errorRule = e.getCtx().getRuleIndex();
                    switch (e.getCtx().getRuleIndex()) {
                        case 1: {
                            AstBuilderListener.this.pushError(AstBuilderListener.this.builder.errorExpression());
                            break;
                        }
                    }
                }
            } else if (recognizer instanceof QueryParser && (parser = (QueryParser)recognizer).getContext() instanceof QueryParser.EnumOrClassifierLitContext) {
                AstBuilderListener.this.errorRule = 12;
                ParseTree firstChild = parser.getContext().getChild(0);
                if (firstChild.getChildCount() == 1) {
                    AstBuilderListener.this.pushError(AstBuilderListener.this.builder.errorTypeLiteral(firstChild.getChild(0).getText()));
                } else if (firstChild.getChildCount() == 3) {
                    AstBuilderListener.this.pushError(AstBuilderListener.this.builder.errorTypeLiteral(firstChild.getChild(0).getText(), firstChild.getChild(2).getText()));
                } else {
                    throw new UnsupportedOperationException("there is no error then...");
                }
            }
        }
    }
}

