/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.acceleo.query.parser.CombineIterator;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractLanguageServices;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class EvaluationServices
extends AbstractLanguageServices {
    private static final String SERVICE_RETURNED_NULL = "Service %s returned a null value";
    private static final String INTERNAL_ERROR_MSG = "An internal error occured during evaluation of a query";

    public EvaluationServices(IQueryEnvironment queryEnv, boolean doLog) {
        super(queryEnv, doLog);
    }

    public Object getVariableValue(Map<String, Object> variableDefinitions, String variableName) {
        try {
            Object result = variableDefinitions.get(variableName);
            return result == null ? this.nothing("Couldn't find the %s variable", variableName) : result;
        }
        catch (NullPointerException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    public Object featureAccess(Object context, String featureName) {
        EClass eClass;
        EStructuralFeature feature;
        Object result = context instanceof EObject ? ((feature = (eClass = ((EObject)context).eClass()).getEStructuralFeature(featureName)) == null ? this.nothing("Feature %s not found in EClass %s", featureName, eClass.getName()) : ((EObject)context).eGet(feature)) : (context instanceof List ? this.applyGetFeatureOnSequence((List)context, featureName) : (context instanceof Set ? this.applyGetFeatureOnSet((Set)context, featureName) : (context != null ? this.nothing("Attempt to access feature (%s) on a non ModelObject value (%s).", featureName, context.getClass().getCanonicalName()) : this.nothing("Attempt to access feature (%s) on a non ModelObject value (%s).", featureName, "null"))));
        return result;
    }

    private Object applyGetFeatureOnSet(Set<Object> context, String featureName) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(context.size());
        for (Object element : context) {
            Object newElt = this.featureAccess(element, featureName);
            if (newElt == NOTHING) continue;
            if (newElt instanceof Collection) {
                result.addAll((Collection)newElt);
                continue;
            }
            result.add(newElt);
        }
        return result;
    }

    private Object applyGetFeatureOnSequence(List<Object> context, String featureName) {
        ArrayList<Object> result = new ArrayList<Object>(context.size());
        for (Object element : context) {
            Object newElt = this.featureAccess(element, featureName);
            if (newElt == NOTHING) continue;
            if (newElt instanceof Collection) {
                result.addAll((Collection)newElt);
                continue;
            }
            result.add(newElt);
        }
        return result;
    }

    private Nothing nothing(String message, Object ... msgArgs) {
        if (this.doLog) {
            String formatedMessage = String.format(message, msgArgs);
            this.logger.log(Level.WARNING, formatedMessage, msgArgs);
        }
        return NOTHING;
    }

    private Nothing nothing(String serviceName, Class<?>[] parameterTypes, Exception e) {
        if (this.doLog) {
            Throwable cause = e instanceof InvocationTargetException && e.getCause() != null ? e.getCause() : e;
            String message = "Exception while calling " + this.serviceSignature(serviceName, parameterTypes);
            this.logger.log(Level.WARNING, message, cause);
        }
        return NOTHING;
    }

    private Class<?>[] getArgumentTypes(Object[] arguments) {
        Class[] argumentTypes = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            argumentTypes[i] = arguments[i] == null ? null : arguments[i].getClass();
            ++i;
        }
        return argumentTypes;
    }

    private Object callService(IService service, Object[] arguments) {
        Method method = service.getServiceMethod();
        try {
            Object result = method.invoke(service.getServiceInstance(), arguments);
            if (result == null) {
                Object[] argumentTypes = this.getArgumentTypes(arguments);
                this.nothing(SERVICE_RETURNED_NULL, this.serviceSignature(method.getName(), argumentTypes));
            }
            return result;
        }
        catch (Exception e) {
            Class<?>[] argumentTypes = this.getArgumentTypes(arguments);
            return this.nothing(service.getServiceMethod().getName(), argumentTypes, e);
        }
    }

    public Object call(String serviceName, Object ... arguments) {
        Object result;
        if (arguments.length == 0) {
            throw new AcceleoQueryEvaluationException("An internal error occured during evaluation of a query : at least one argument must be specified for service " + serviceName + ".");
        }
        try {
            Object[] argumentTypes = this.getArgumentTypes(arguments);
            IService service = this.lookupEngine.lookup(serviceName, (Class<?>[])argumentTypes);
            if (service == null) {
                if (arguments[0] instanceof EObject) {
                    List eClassifiers = this.getEParameters(Arrays.copyOfRange(arguments, 1, arguments.length));
                    EOperation eOperation = null;
                    if (arguments.length > 1) {
                        CombineIterator it = new CombineIterator(eClassifiers);
                        while (eOperation == null && it.hasNext()) {
                            eOperation = this.ePackageProvider.lookupEOperation(((EObject)arguments[0]).eClass(), serviceName, (List)it.next());
                        }
                    } else {
                        eOperation = this.ePackageProvider.lookupEOperation(((EObject)arguments[0]).eClass(), serviceName, new ArrayList<EParameter>());
                    }
                    if (eOperation != null) {
                        BasicEList eArguments = new BasicEList();
                        int i = 1;
                        while (i < arguments.length) {
                            eArguments.add(arguments[i]);
                            ++i;
                        }
                        result = ((EObject)arguments[0]).eInvoke(eOperation, (EList)eArguments);
                    } else {
                        result = this.nothing("Couldn't find the %s service or EOperation", this.serviceSignature(serviceName, argumentTypes));
                    }
                } else {
                    result = this.nothing("Couldn't find the %s service", this.serviceSignature(serviceName, argumentTypes));
                }
            } else {
                result = this.callService(service, arguments);
            }
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        return result;
    }

    private List<Set<EParameter>> getEParameters(Object[] objects) {
        ArrayList<Set<EParameter>> result = new ArrayList<Set<EParameter>>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            EParameter parameter;
            Object object = objectArray[n2];
            LinkedHashSet<EParameter> eParamters = new LinkedHashSet<EParameter>();
            if (object instanceof List) {
                parameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
                parameter.setUpperBound(-1);
                parameter.setEType(null);
                eParamters.add(parameter);
            } else if (object instanceof EObject) {
                parameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
                parameter.setEType((EClassifier)((EObject)object).eClass());
                eParamters.add(parameter);
            } else if (object != null) {
                for (EClassifier eClassifier : this.ePackageProvider.getEClass(object.getClass())) {
                    EParameter parameter2 = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
                    parameter2.setEType(eClassifier);
                    eParamters.add(parameter2);
                }
            } else {
                parameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
                parameter.setEType(null);
                eParamters.add(parameter);
            }
            result.add(eParamters);
            ++n2;
        }
        return result;
    }

    public Object callOrApply(String serviceName, Object[] arguments) {
        try {
            Object result;
            if (arguments[0] instanceof List) {
                List list = (List)arguments[0];
                result = this.applyCallOnSequence(serviceName, list, arguments);
            } else if (arguments[0] instanceof Set) {
                Set set = (Set)arguments[0];
                result = this.applyCallOnSet(serviceName, set, arguments);
            } else {
                result = this.call(serviceName, arguments);
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    public Object collectionServiceCall(String serviceName, Object[] arguments) {
        try {
            Object[] newArguments;
            LinkedHashSet receiver = arguments[0];
            if (!(receiver instanceof Collection) && !(receiver instanceof Nothing)) {
                LinkedHashSet newReceiver = new LinkedHashSet();
                newReceiver.add(receiver);
                receiver = newReceiver;
                newArguments = (Object[])arguments.clone();
                newArguments[0] = newReceiver;
            } else {
                newArguments = arguments;
            }
            return this.call(serviceName, newArguments);
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    private Object applyCallOnSequence(String serviceName, List<Object> origin, Object ... arguments) {
        try {
            ArrayList<Object> result = new ArrayList<Object>(origin.size());
            Object[] innerArguments = (Object[])arguments.clone();
            Iterator<Object> iterator = origin.iterator();
            while (iterator.hasNext()) {
                Object obj;
                innerArguments[0] = obj = iterator.next();
                Object newResult = this.callOrApply(serviceName, innerArguments);
                if (newResult == NOTHING) continue;
                if (newResult instanceof Collection) {
                    result.addAll((Collection)newResult);
                    continue;
                }
                result.add(newResult);
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException("empty argument array passed to callOrApply", e);
        }
    }

    private Object applyCallOnSet(String serviceName, Set<Object> origin, Object[] arguments) {
        try {
            LinkedHashSet<Object> result = new LinkedHashSet<Object>(origin.size());
            Object[] innerArguments = (Object[])arguments.clone();
            Iterator<Object> iterator = origin.iterator();
            while (iterator.hasNext()) {
                Object obj;
                innerArguments[0] = obj = iterator.next();
                Object newResult = this.callOrApply(serviceName, innerArguments);
                if (newResult == NOTHING) continue;
                if (newResult instanceof Collection) {
                    result.addAll((Collection)newResult);
                    continue;
                }
                result.add(newResult);
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    protected String serviceSignature(String serviceName, Object[] argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(serviceName).append('(');
        boolean first = true;
        Object[] objectArray = argumentTypes;
        int n = argumentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object argType = objectArray[n2];
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            if (argType instanceof Class) {
                builder.append(((Class)argType).getCanonicalName());
            } else if (argType instanceof EClass) {
                builder.append("EClass=" + ((EClass)argType).getName());
            } else if (argType == null) {
                builder.append("Object=null");
            } else {
                builder.append("Object=" + argType.toString());
            }
            ++n2;
        }
        return builder.append(')').toString();
    }
}

