/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.lookup.basic;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IServiceProvider;
import org.eclipse.acceleo.query.runtime.InvalidAcceleoPackageException;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;

public class BasicLookupEngine {
    public static final String INSTANTIATION_PROBLEM_MSG = "Couldn't instantiate class ";
    private static final String SET_CROSS_REFERENCER_METHOD_NAME = "setCrossReferencer";
    private static final String PACKAGE_PROBLEM_MSG = "No zero argument constructor found in class ";
    private final Map<Integer, Map<String, List<IService>>> services = new HashMap<Integer, Map<String, List<IService>>>();
    private final List<IService> servicesList = new ArrayList<IService>();
    private CrossReferenceProvider crossReferencer;

    public BasicLookupEngine(CrossReferenceProvider crossReferencer) {
        this.crossReferencer = crossReferencer;
    }

    public CrossReferenceProvider getCrossReferencer() {
        return this.crossReferencer;
    }

    private List<IService> getOrCreateMultimethod(String methodName, int argc) {
        List<IService> result;
        Map<String, List<IService>> argcServices = this.services.get(argc);
        if (argcServices == null) {
            argcServices = new HashMap<String, List<IService>>();
            this.services.put(argc, argcServices);
        }
        if ((result = argcServices.get(methodName)) == null) {
            result = new ArrayList<IService>();
            argcServices.put(methodName, result);
        }
        return result;
    }

    private List<IService> getMultimethod(String methodName, int argc) {
        Map<String, List<IService>> argcServices = this.services.get(argc);
        if (argcServices == null) {
            return null;
        }
        return argcServices.get(methodName);
    }

    private boolean matches(Method method, Class<?>[] argumentTypes) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != argumentTypes.length) {
            throw new IllegalArgumentException("the specified method doesn't have the right parameter number");
        }
        int i = 0;
        while (i < parameterTypes.length) {
            if (argumentTypes[i] != null && !parameterTypes[i].isAssignableFrom(argumentTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean lower(Method method1, Method method2) {
        Class<?>[] params1 = method1.getParameterTypes();
        Class<?>[] params2 = method2.getParameterTypes();
        int size = params1.length;
        int i = 0;
        while (i < size) {
            Class<?> param2 = params2[i];
            Class<?> param1 = params1[i];
            if (param2.isAssignableFrom(param1) && param1 != param2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IService lookup(String name, Class<?>[] argumentTypes) {
        List<IService> multiMethod = this.getMultimethod(name, argumentTypes.length);
        if (multiMethod == null) {
            return null;
        }
        IService result = null;
        for (IService service : multiMethod) {
            Method method = service.getServiceMethod();
            if (!this.matches(method, argumentTypes) || result != null && !this.lower(method, result.getServiceMethod())) continue;
            result = service;
        }
        return result;
    }

    public boolean registerMethod(Method method) {
        boolean objectMethod = method.getDeclaringClass() != Object.class;
        return objectMethod;
    }

    public boolean isCrossReferencerMethod(Method method) {
        boolean crossRefSet = SET_CROSS_REFERENCER_METHOD_NAME.equals(method.getName()) && method.getParameterTypes().length > 0 && CrossReferenceProvider.class.isAssignableFrom(method.getParameterTypes()[0]);
        return crossRefSet;
    }

    public void addServices(IServiceProvider provider) throws InvalidAcceleoPackageException {
        for (IService service : provider.getServices(this)) {
            List<IService> multiMethod = this.getOrCreateMultimethod(service.getServiceMethod().getName(), service.getServiceMethod().getParameterTypes().length);
            multiMethod.add(service);
            this.servicesList.add(service);
        }
    }

    public void addServices(Class<?> newServices) throws InvalidAcceleoPackageException {
        try {
            Constructor<?> cstr = newServices.getConstructor(new Class[0]);
            Object instance = cstr.newInstance(new Object[0]);
            if (instance instanceof IServiceProvider) {
                this.addServices((IServiceProvider)instance);
            } else {
                Method[] methods = newServices.getMethods();
                this.getServicesFromInstance(instance, methods);
            }
        }
        catch (NoSuchMethodException e) {
            throw new InvalidAcceleoPackageException(PACKAGE_PROBLEM_MSG + newServices.getCanonicalName(), e);
        }
        catch (SecurityException e) {
            throw new InvalidAcceleoPackageException(PACKAGE_PROBLEM_MSG + newServices.getCanonicalName(), e);
        }
        catch (InstantiationException e) {
            throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
        }
        catch (InvocationTargetException e) {
            throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
        }
    }

    private void getServicesFromInstance(Object instance, Method[] methods) throws IllegalAccessException, InvocationTargetException {
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (this.isCrossReferencerMethod(method)) {
                method.invoke(instance, this.crossReferencer);
            } else if (this.registerMethod(method)) {
                List<IService> multiMethod = this.getOrCreateMultimethod(method.getName(), method.getParameterTypes().length);
                Service service = new Service(method, instance);
                multiMethod.add(service);
                this.servicesList.add(service);
            }
            ++n2;
        }
    }

    public Set<IService> getServices(Set<Class<?>> receiverTypes) {
        LinkedHashSet<IService> result = new LinkedHashSet<IService>();
        for (Class<?> cls : receiverTypes) {
            for (IService service : this.servicesList) {
                if (!service.getServiceMethod().getParameterTypes()[0].isAssignableFrom(cls)) continue;
                result.add(service);
            }
        }
        return result;
    }
}

