/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;

public class EObjectServices
extends AbstractServiceProvider {
    private CrossReferenceProvider crossReferencer;

    @Override
    protected IService getService(Method publicMethod) {
        Service result = "eContents".equals(publicMethod.getName()) ? new EContentsService(publicMethod, this) : ("eAllContents".equals(publicMethod.getName()) ? new EAllContentsService(publicMethod, this) : ("eContainer".equals(publicMethod.getName()) ? new EContainerService(publicMethod, this) : ("ancestors".equals(publicMethod.getName()) ? new AncestorsService(publicMethod, this) : ("eInverse".equals(publicMethod.getName()) ? new EInverseService(publicMethod, this) : ("followingSiblings".equals(publicMethod.getName()) ? new FollowingSiblingsService(publicMethod, this) : ("precedingSiblings".equals(publicMethod.getName()) ? new PrecedingSiblingsService(publicMethod, this) : ("siblings".equals(publicMethod.getName()) ? new SiblingsService(publicMethod, this) : new Service(publicMethod, this))))))));
        return result;
    }

    public List<EObject> eAllContents(EObject eObject) {
        ArrayList result = Lists.newArrayList();
        TreeIterator it = eObject.eAllContents();
        while (it.hasNext()) {
            result.add((EObject)it.next());
        }
        return result;
    }

    public List<EObject> eAllContents(EObject eObject, EClass type) {
        ArrayList result = Lists.newArrayList();
        TreeIterator it = eObject.eAllContents();
        while (it.hasNext()) {
            EObject input = (EObject)it.next();
            if (!type.isSuperTypeOf(input.eClass())) continue;
            result.add(input);
        }
        return result;
    }

    public List<EObject> eContents(EObject eObject) {
        return eObject.eContents();
    }

    public List<EObject> eContents(EObject eObject, EClass type) {
        ArrayList result = Lists.newArrayList();
        for (EObject input : eObject.eContents()) {
            if (!type.isSuperTypeOf(input.eClass())) continue;
            result.add(input);
        }
        return result;
    }

    public EObject eContainer(EObject eObject) {
        return eObject.eContainer();
    }

    public EObject eContainer(EObject eObject, EClass type) {
        EObject current = eObject.eContainer();
        while (current != null && !type.isSuperTypeOf(current.eClass())) {
            current = current.eContainer();
        }
        EObject result = current != null && type.isSuperTypeOf(current.eClass()) ? current : null;
        return result;
    }

    public EClass eClass(EObject eObject) {
        return eObject.eClass();
    }

    public void setCrossReferencer(CrossReferenceProvider crossReferencer) {
        this.crossReferencer = crossReferencer;
    }

    public Set<EObject> eInverse(EObject self) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public Set<EObject> eInverse(EObject self, EClassifier filter) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null || filter == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                if (!filter.isInstance((Object)setting.getEObject())) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public Set<EObject> eInverse(EObject self, String featureName) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                if (!setting.getEStructuralFeature().getName().equals(featureName)) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public List<EObject> ancestors(EObject object) {
        return this.ancestors(object, null);
    }

    public List<EObject> ancestors(EObject object, EClassifier filter) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject container = object.eContainer();
        while (container != null) {
            if (filter == null || filter.isInstance((Object)container)) {
                result.add(container);
            }
            container = container.eContainer();
        }
        return result;
    }

    public Object eGet(EObject source, String featureName) {
        for (EStructuralFeature feature : source.eClass().getEAllStructuralFeatures()) {
            if (!feature.getName().equals(featureName)) continue;
            return source.eGet(feature);
        }
        return null;
    }

    public List<EObject> followingSiblings(EObject eObject) {
        return this.siblings(eObject, null, false);
    }

    public List<EObject> followingSiblings(EObject eObject, EClassifier filter) {
        return this.siblings(eObject, filter, false);
    }

    public List<EObject> precedingSiblings(EObject eObject) {
        return this.siblings(eObject, null, true);
    }

    public List<EObject> precedingSiblings(EObject eObject, EClassifier filter) {
        return this.siblings(eObject, filter, true);
    }

    public List<EObject> siblings(EObject eObject) {
        return this.siblings(eObject, null);
    }

    public List<EObject> siblings(EObject eObject, EClassifier filter) {
        List<Object> result;
        Object container = this.getContainer(eObject);
        if (container != null) {
            result = Lists.newArrayList();
            for (EObject input : this.getContents(container)) {
                if (input == eObject || filter != null && !filter.isInstance((Object)input.eClass()) && !filter.equals(input.eClass())) continue;
                result.add(input);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<EObject> siblings(EObject eObject, EClassifier filter, Boolean preceding) {
        ArrayList result;
        Object container = this.getContainer(eObject);
        if (container != null) {
            List<EObject> siblings = this.getContents(container);
            int startIndex = 0;
            int endIndex = siblings.size();
            if (preceding.booleanValue()) {
                endIndex = siblings.indexOf(eObject);
            } else {
                startIndex = siblings.indexOf(eObject) + 1;
            }
            result = Lists.newArrayList();
            for (EObject input : siblings.subList(startIndex, endIndex)) {
                if (filter != null && !filter.isInstance((Object)input.eClass()) && !filter.equals(input.eClass())) continue;
                result.add(input);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private Object getContainer(EObject object) {
        EObject result = object.eContainer();
        if (result == null && object instanceof InternalEObject) {
            result = ((InternalEObject)object).eDirectResource();
        }
        return result;
    }

    private List<EObject> getContents(Object container) {
        List<Object> contents = container instanceof EObject ? this.getContents((EObject)container) : (container instanceof Resource ? this.getRoots((Resource)container) : Collections.emptyList());
        return contents;
    }

    private List<EObject> getContents(EObject eObject) {
        ArrayList<EObject> result = new ArrayList<EObject>((Collection<EObject>)eObject.eContents());
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            if (!reference.isContainment() || !reference.isDerived()) continue;
            Object value = eObject.eGet((EStructuralFeature)reference);
            if (value instanceof Collection) {
                for (Object newValue : (Collection)value) {
                    if (result.contains(newValue) || !(newValue instanceof EObject)) continue;
                    result.add((EObject)newValue);
                }
                continue;
            }
            if (result.contains(value) || !(value instanceof EObject)) continue;
            result.add((EObject)value);
        }
        return result;
    }

    private List<EObject> getRoots(Resource resource) {
        Object result = resource.getContents();
        ListIterator iter = result.listIterator();
        while (iter.hasNext()) {
            if (((EObject)iter.next()).eContainer() == null) continue;
            int where = iter.previousIndex();
            ArrayList newResult = new ArrayList(result.size() - 1);
            newResult.addAll(result.subList(0, where));
            result = newResult;
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                if (next.eContainer() != null) continue;
                result.add(next);
            }
        }
        return result;
    }

    private static final class AncestorsService
    extends FilterService {
        private AncestorsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SequenceType(new EClassifierType(((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, provider, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(services.nothing("Only EClass can be contained into other EClasses not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, EPackageProvider provider, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass containingEClass : provider.getAllContainingEClasses(receiverEClass)) {
                    result.add(new SequenceType(new EClassifierType((EClassifier)containingEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s can't be contained", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containingEClass : provider.getAllContainingEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType((EClassifier)containingEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SequenceType(lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s can't contain directly or indirectly %s", filterType, argTypes.get(0))));
                }
            }
            return result;
        }
    }

    private static final class EAllContentsService
    extends FilterService {
        private EAllContentsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SequenceType(new EClassifierType(((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, provider, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(services.nothing("Only EClass can contain other EClasses not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, EPackageProvider provider, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            LinkedHashSet<SequenceType> containedTypes = new LinkedHashSet<SequenceType>();
            for (EClass contained : provider.getAllContainedEClasses(receiverEClass)) {
                containedTypes.add(new SequenceType(new EClassifierType((EClassifier)contained)));
            }
            if (argTypes.size() == 1) {
                result.addAll(containedTypes);
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s doesn't contain any other EClass", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containedEClass : provider.getAllContainedEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType((EClassifier)containedEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SequenceType(lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s can't contain %s direclty or indirectly", argTypes.get(0), filterType)));
                }
            }
            return result;
        }
    }

    private static final class EContainerService
    extends FilterService {
        private EContainerService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(argTypes.get(0));
                    } else if (argTypes.size() == 2) {
                        result.add(new EClassifierType(((EClassifierLiteralType)argTypes.get(1)).getType()));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, provider, argTypes, eCls));
                }
            } else {
                result.add(services.nothing("Only EClass can be contained into other EClasses not %s", argTypes.get(0)));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, EPackageProvider provider, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass containingEClass : provider.getContainingEClasses(receiverEClass)) {
                    result.add(new EClassifierType((EClassifier)containingEClass));
                }
                if (result.isEmpty()) {
                    result.add(services.nothing("%s can't be contained", argTypes.get(0)));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containingEClass : provider.getAllContainingEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType((EClassifier)containingEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(lowerType);
                }
                if (result.isEmpty()) {
                    result.add(services.nothing("%s can't contain directly or indirectly %s", filterType, argTypes.get(0)));
                }
            }
            return result;
        }
    }

    private static final class EContentsService
    extends FilterService {
        private EContentsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SequenceType(new EClassifierType(((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, provider, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(services.nothing("Only EClass can contain other EClasses not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, EPackageProvider provider, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            LinkedHashSet<SequenceType> containedTypes = new LinkedHashSet<SequenceType>();
            for (EClass contained : provider.getContainedEClasses(receiverEClass)) {
                containedTypes.add(new SequenceType(new EClassifierType((EClassifier)contained)));
            }
            if (argTypes.size() == 1) {
                result.addAll(containedTypes);
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s doesn't contain any other EClass", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containedEClass : provider.getContainedEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType((EClassifier)containedEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SequenceType(lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s can't contain %s direclty", argTypes.get(0), filterType)));
                }
            }
            return result;
        }
    }

    private static final class EInverseService
    extends FilterService {
        private EInverseService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SetType(argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SetType(new EClassifierType(((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, provider, argTypes, eCls));
                }
            } else {
                result.add(new SetType(services.nothing("Only EClass can have inverse not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, EPackageProvider provider, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1 || !(argTypes.get(1).getType() instanceof EClassifier)) {
                for (EClass inverseEClass : provider.getInverseEClasses(receiverEClass)) {
                    result.add(new SetType(new EClassifierType((EClassifier)inverseEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SetType(services.nothing("%s don't have inverse", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass inverseEClass : provider.getInverseEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType((EClassifier)inverseEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SetType(lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SetType(services.nothing("%s don't have inverse to %s", argTypes.get(0), filterType)));
                }
            }
            return result;
        }
    }

    private static final class FollowingSiblingsService
    extends FilterService {
        private FollowingSiblingsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SequenceType(new EClassifierType(((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, provider, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(services.nothing("Only EClass can have following siblings not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, EPackageProvider provider, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass containingEClass : provider.getFollowingSiblingsEClasses(receiverEClass)) {
                    result.add(new SequenceType(new EClassifierType((EClassifier)containingEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s can't have following siblings", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containingEClass : provider.getFollowingSiblingsEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType((EClassifier)containingEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SequenceType(lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s can't be a following sibling of %s", filterType, argTypes.get(0))));
                }
            }
            return result;
        }
    }

    private static final class PrecedingSiblingsService
    extends FilterService {
        private PrecedingSiblingsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SequenceType(new EClassifierType(((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, provider, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(services.nothing("Only EClass can have preceding siblings not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, EPackageProvider provider, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass containingEClass : provider.getPrecedingSiblingsEClasses(receiverEClass)) {
                    result.add(new SequenceType(new EClassifierType((EClassifier)containingEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s can't have preceding siblings", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containingEClass : provider.getPrecedingSiblingsEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType((EClassifier)containingEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SequenceType(lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s can't be a preceding sibling of %s", filterType, argTypes.get(0))));
                }
            }
            return result;
        }
    }

    private static final class SiblingsService
    extends FilterService {
        private SiblingsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, EPackageProvider provider, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SequenceType(new EClassifierType(((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, provider, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(services.nothing("Only EClass can have siblings not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, EPackageProvider provider, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass containingEClass : provider.getSiblingsEClasses(receiverEClass)) {
                    result.add(new SequenceType(new EClassifierType((EClassifier)containingEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s can't have siblings", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containingEClass : provider.getSiblingsEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType((EClassifier)containingEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SequenceType(lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(services.nothing("%s can't be a sibling of %s", filterType, argTypes.get(0))));
                }
            }
            return result;
        }
    }
}

