/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;

public class FilterService
extends Service {
    final int filterIndex = 1;

    public FilterService(Method serviceMethod, Object serviceInstance) {
        super(serviceMethod, serviceInstance);
    }

    @Override
    public Set<IType> validateAllType(ValidationServices services, EPackageProvider provider, Map<List<IType>, Set<IType>> allTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        StringBuilder builder = new StringBuilder();
        block0: for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            if (entry.getKey().size() > 1) {
                IType filterType = entry.getKey().get(1);
                for (IType possibleType : entry.getValue()) {
                    if (possibleType instanceof NothingType) {
                        builder.append("\n");
                        builder.append(((NothingType)possibleType).getMessage());
                        continue;
                    }
                    IType rawType = possibleType instanceof ICollectionType ? ((ICollectionType)possibleType).getCollectionType() : possibleType;
                    IType loweredType = services.lower(filterType, rawType);
                    if (loweredType == null) continue;
                    result.add(this.unrawType(possibleType, loweredType));
                    continue block0;
                }
                continue;
            }
            for (IType possibleType : entry.getValue()) {
                if (possibleType instanceof NothingType) {
                    builder.append("\n");
                    builder.append(((NothingType)possibleType).getMessage());
                    continue;
                }
                result.add(possibleType);
            }
        }
        if (result.isEmpty()) {
            NothingType nothing = services.nothing("Nothing will be left after calling %s:" + builder.toString(), this.getServiceMethod().getName());
            if (List.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SequenceType(nothing));
            } else if (Set.class.isAssignableFrom(this.getServiceMethod().getReturnType())) {
                result.add(new SetType(nothing));
            } else {
                result.add(nothing);
            }
        }
        return result;
    }

    private IType unrawType(IType originalType, IType rawType) {
        IType result = originalType instanceof SequenceType ? new SequenceType(rawType) : (originalType instanceof SetType ? new SetType(rawType) : rawType);
        return result;
    }
}

