/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class EObjectServices
extends AbstractServiceProvider {
    private static final String ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S = "Only EClass can be contained into other EClasses not %s";
    private static final String S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S = "%s can't contain directly or indirectly %s";
    private CrossReferenceProvider crossReferencer;

    @Override
    protected IService getService(Method publicMethod) {
        Service result = "eContents".equals(publicMethod.getName()) ? new EContentsService(publicMethod, this) : ("eAllContents".equals(publicMethod.getName()) ? new EAllContentsService(publicMethod, this) : ("eContainer".equals(publicMethod.getName()) ? new EContainerService(publicMethod, this) : ("eContainerOrSelf".equals(publicMethod.getName()) ? new EContainerOrSelfService(publicMethod, this) : ("eInverse".equals(publicMethod.getName()) ? new EInverseService(publicMethod, this) : new Service(publicMethod, this)))));
        return result;
    }

    public List<EObject> eAllContents(EObject eObject) {
        ArrayList result = Lists.newArrayList();
        TreeIterator it = eObject.eAllContents();
        while (it.hasNext()) {
            result.add((EObject)it.next());
        }
        return result;
    }

    public List<EObject> eAllContents(EObject eObject, EClass type) {
        ArrayList result = Lists.newArrayList();
        TreeIterator it = eObject.eAllContents();
        while (it.hasNext()) {
            EObject input = (EObject)it.next();
            if (!type.isSuperTypeOf(input.eClass())) continue;
            result.add(input);
        }
        return result;
    }

    public List<EObject> eContents(EObject eObject) {
        return eObject.eContents();
    }

    public List<EObject> eContents(EObject eObject, EClass type) {
        ArrayList result = Lists.newArrayList();
        for (EObject input : eObject.eContents()) {
            if (!type.isSuperTypeOf(input.eClass())) continue;
            result.add(input);
        }
        return result;
    }

    public EObject eContainer(EObject eObject) {
        return eObject.eContainer();
    }

    public EObject eContainer(EObject eObject, EClass type) {
        EObject current = eObject.eContainer();
        while (current != null && !type.isSuperTypeOf(current.eClass())) {
            current = current.eContainer();
        }
        EObject result = current != null && type.isSuperTypeOf(current.eClass()) ? current : null;
        return result;
    }

    public EObject eContainerOrSelf(EObject eObject, EClass type) {
        EObject result = type.isSuperTypeOf(eObject.eClass()) ? eObject : this.eContainer(eObject, type);
        return result;
    }

    public EClass eClass(EObject eObject) {
        return eObject.eClass();
    }

    public void setCrossReferencer(CrossReferenceProvider crossReferencer) {
        this.crossReferencer = crossReferencer;
    }

    public Set<EObject> eInverse(EObject self) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public Set<EObject> eInverse(EObject self, EClassifier filter) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null || filter == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                if (!filter.isInstance((Object)setting.getEObject())) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public Set<EObject> eInverse(EObject self, String featureName) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                if (!setting.getEStructuralFeature().getName().equals(featureName)) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public Object eGet(EObject source, String featureName) {
        for (EStructuralFeature feature : source.eClass().getEAllStructuralFeatures()) {
            if (!feature.getName().equals(featureName)) continue;
            return source.eGet(feature);
        }
        return null;
    }

    private static final class EAllContentsService
    extends FilterService {
        private EAllContentsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can contain other EClasses not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            LinkedHashSet<SequenceType> containedTypes = new LinkedHashSet<SequenceType>();
            for (EClass contained : queryEnvironment.getEPackageProvider().getAllContainedEClasses(receiverEClass)) {
                containedTypes.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)contained)));
            }
            if (argTypes.size() == 1) {
                result.addAll(containedTypes);
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s doesn't contain any other EClass", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containedEClass : queryEnvironment.getEPackageProvider().getAllContainedEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containedEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SequenceType(queryEnvironment, lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't contain %s direclty or indirectly", argTypes.get(0), filterType)));
                }
            }
            return result;
        }
    }

    private static final class EContainerOrSelfService
    extends FilterService {
        private EContainerOrSelfService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvoronment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    result.add(new EClassifierType(queryEnvoronment, ((EClassifierLiteralType)argTypes.get(1)).getType()));
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvoronment, argTypes, eCls));
                }
            } else {
                result.add(services.nothing(EObjectServices.ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S, argTypes.get(0)));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            IType lowerSelfType = services.lower(argTypes.get(0), argTypes.get(1));
            if (lowerSelfType != null) {
                result.add(lowerSelfType);
            }
            IType filterType = argTypes.get(1);
            for (EClass containingEClass : queryEnvironment.getEPackageProvider().getAllContainingEClasses(receiverEClass)) {
                IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containingEClass), filterType);
                if (lowerType == null) continue;
                result.add(lowerType);
            }
            if (result.isEmpty()) {
                result.add(services.nothing(EObjectServices.S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S, filterType, argTypes.get(0)));
            }
            return result;
        }
    }

    private static final class EContainerService
    extends FilterService {
        private EContainerService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(argTypes.get(0));
                    } else if (argTypes.size() == 2) {
                        result.add(new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType()));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(services.nothing(EObjectServices.ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S, argTypes.get(0)));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass containingEClass : queryEnvironment.getEPackageProvider().getContainingEClasses(receiverEClass)) {
                    result.add(new EClassifierType(queryEnvironment, (EClassifier)containingEClass));
                }
                if (result.isEmpty()) {
                    result.add(services.nothing("%s can't be contained", argTypes.get(0)));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containingEClass : queryEnvironment.getEPackageProvider().getAllContainingEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containingEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(lowerType);
                }
                if (result.isEmpty()) {
                    result.add(services.nothing(EObjectServices.S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S, filterType, argTypes.get(0)));
                }
            }
            return result;
        }
    }

    private static final class EContentsService
    extends FilterService {
        private EContentsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can contain other EClasses not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            LinkedHashSet<SequenceType> containedTypes = new LinkedHashSet<SequenceType>();
            for (EClass contained : queryEnvironment.getEPackageProvider().getContainedEClasses(receiverEClass)) {
                containedTypes.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)contained)));
            }
            if (argTypes.size() == 1) {
                result.addAll(containedTypes);
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s doesn't contain any other EClass", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containedEClass : queryEnvironment.getEPackageProvider().getContainedEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containedEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SequenceType(queryEnvironment, lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't contain %s direclty", argTypes.get(0), filterType)));
                }
            }
            return result;
        }
    }

    private static final class EInverseService
    extends FilterService {
        private EInverseService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1 || !(argTypes.get(1).getType() instanceof EClass)) {
                        result.add(new SetType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SetType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SetType(queryEnvironment, services.nothing("Only EClass can have inverse not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            Set<EClass> inverseEClasses = queryEnvironment.getEPackageProvider().getInverseEClasses(receiverEClass);
            if (argTypes.size() == 1 || !(argTypes.get(1).getType() instanceof EClass)) {
                for (EClass inverseEClass : inverseEClasses) {
                    result.add(new SetType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)inverseEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SetType(queryEnvironment, services.nothing("%s don't have inverse", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass inverseEClass : inverseEClasses) {
                    IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)inverseEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SetType(queryEnvironment, lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SetType(queryEnvironment, services.nothing("%s don't have inverse to %s", argTypes.get(0), filterType)));
                }
            }
            return result;
        }
    }
}

