/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.completion;

import java.lang.reflect.Method;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.emf.ecore.EClass;

public class ServiceCompletionProposal
implements ICompletionProposal {
    private final IService service;

    public ServiceCompletionProposal(IService service) {
        this.service = service;
    }

    @Override
    public String getProposal() {
        return String.valueOf(this.service.getServiceMethod().getName()) + "()";
    }

    @Override
    public int getCursorOffset() {
        Method serviceMethod = this.service.getServiceMethod();
        int namelength = serviceMethod.getName().length();
        if (serviceMethod.getParameterTypes().length == 1) {
            return namelength + 2;
        }
        return namelength + 1;
    }

    @Override
    public IService getObject() {
        return this.service;
    }

    public String toString() {
        return this.getProposal();
    }

    @Override
    public String getDescription() {
        StringBuffer result = new StringBuffer();
        result.append("Service ");
        result.append(this.service.getServiceMethod().getName()).append('(');
        boolean first = true;
        Class<?>[] classArray = this.service.getServiceMethod().getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> argType = classArray[n2];
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            if (argType instanceof Class) {
                result.append(argType.getCanonicalName());
            } else if (argType instanceof EClass) {
                result.append("EClass=" + ((EClass)argType).getName());
            } else {
                result.append("Object=" + ((Object)argType).toString());
            }
            ++n2;
        }
        result.append(')');
        return result.toString();
    }
}

