/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IJavaType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;

public abstract class AbstractLanguageServices {
    protected static final String NON_EOBJECT_FEATURE_ACCESS = "Attempt to access feature (%s) on a non ModelObject value (%s).";
    protected static final String SERVICE_NOT_FOUND = "Couldn't find the %s service";
    protected static final String SERVICE_EOPERATION_NOT_FOUND = "Couldn't find the %s service or EOperation";
    protected static final String VARIABLE_NOT_FOUND = "Couldn't find the %s variable";
    protected static final String UNKNOWN_FEATURE = "Feature %s not found in EClass %s";
    protected final IReadOnlyQueryEnvironment queryEnvironment;

    public AbstractLanguageServices(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    protected Class<?>[] getArgumentTypes(Collection<IType> list) {
        Class[] result = new Class[list.size()];
        List<Class<?>> types = this.getClasses(list);
        int i = 0;
        while (i < types.size()) {
            result[i] = types.get(i);
            ++i;
        }
        return result;
    }

    protected List<Class<?>> getClasses(Collection<IType> iTypes) {
        ArrayList result = new ArrayList(iTypes.size());
        for (IType iType : iTypes) {
            result.add(this.getClass(iType));
        }
        return result;
    }

    protected Class<?> getClass(IType iType) {
        Class result;
        if (iType instanceof EClassifierLiteralType) {
            result = EClass.class;
        } else if (iType instanceof EClassifierType) {
            result = this.queryEnvironment.getEPackageProvider().getClass(((EClassifierType)iType).getType());
        } else if (iType instanceof IJavaType) {
            result = ((IJavaType)iType).getType();
        } else {
            throw new AcceleoQueryValidationException(iType.getClass().getCanonicalName());
        }
        if (result != null) {
            if ("boolean".equals(result.getName())) {
                result = Boolean.class;
            } else if ("int".equals(result.getName())) {
                result = Integer.class;
            } else if ("double".equals(result.getName())) {
                result = Double.class;
            }
        }
        return result;
    }

    public IReadOnlyQueryEnvironment getQueryEnvironment() {
        return this.queryEnvironment;
    }
}

