/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions;

import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Expression;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Operator;
import org.eclipse.acceleo.internal.compatibility.AcceleoCompatibilityMessages;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.CallSetParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.LiteralParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.NotParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.OperatorParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.ParenthesisParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TextSearch;

public final class ExpressionParser {
    private ExpressionParser() {
    }

    public static Expression createExpression(int offset, String buffer, Region range, Template template) throws TemplateSyntaxException {
        Operator res = null;
        Region localRange = range;
        Region trim = TextSearch.trim(buffer, localRange.b(), localRange.e());
        if (trim.b() == -1) {
            throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingElement"), template, localRange);
        }
        localRange = trim;
        Expression expression = OperatorParser.createOperator(offset, buffer, localRange, template);
        if (expression != null) {
            res = expression;
        }
        if (expression == null && (expression = NotParser.createNot(offset, buffer, localRange, template)) != null) {
            res = expression;
        }
        if (expression == null && (expression = ParenthesisParser.createParenthesis(offset, buffer, localRange, template)) != null) {
            res = expression;
        }
        if (expression == null && (expression = LiteralParser.createLiteral(offset, buffer, localRange, template)) != null) {
            res = expression;
        }
        if (expression == null) {
            res = expression = CallSetParser.createCallSet(offset, buffer, localRange, template);
        }
        return res;
    }
}

