/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;

public class CacheEPackageProvider
extends EPackageProvider {
    private static final EOperation NO_OPERATION = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
    private final Map<String, Node> cache = new HashMap<String, Node>();

    @Override
    public EOperation lookupEOperation(EClass receiverEClass, String eOperationName, List<EParameter> parameters) {
        EOperation result;
        List<ParameterType> parameterTypes = this.getParameterTypes(receiverEClass, parameters);
        Node cachedNode = this.getNodeFromCache(eOperationName, parameterTypes);
        if (cachedNode != null) {
            if (cachedNode.operation == NO_OPERATION) {
                result = null;
            } else if (cachedNode.operation == null) {
                result = super.lookupEOperation(receiverEClass, eOperationName, parameters);
                cachedNode.operation = result;
            } else {
                result = cachedNode.operation;
            }
        } else {
            result = super.lookupEOperation(receiverEClass, eOperationName, parameters);
            this.cacheOperation(eOperationName, parameterTypes, result);
        }
        return result;
    }

    private List<ParameterType> getParameterTypes(EClass receiverEClass, List<EParameter> parameters) {
        ArrayList<ParameterType> result = new ArrayList<ParameterType>(parameters.size() + 1);
        result.add(new ParameterType((EClassifier)receiverEClass, false));
        for (EParameter parameter : parameters) {
            result.add(new ParameterType(parameter.getEType(), parameter.isMany()));
        }
        return result;
    }

    private void cacheOperation(String eOperationName, List<ParameterType> parameterTypes, EOperation operation) {
        Node currentNode = this.cache.get(eOperationName);
        if (currentNode == null) {
            currentNode = new Node();
            this.cache.put(eOperationName, currentNode);
        }
        for (ParameterType parameterType : parameterTypes) {
            Node nextNode = (Node)currentNode.children.get(parameterType);
            if (nextNode == null) {
                nextNode = new Node();
                currentNode.children.put(parameterType, nextNode);
            }
            currentNode = nextNode;
        }
        if (operation == null) {
            currentNode.operation = CacheEPackageProvider.NO_OPERATION;
        } else {
            currentNode.operation = operation;
        }
    }

    private Node getNodeFromCache(String name, List<ParameterType> parameterTypes) {
        Node result;
        Node currentNode = this.cache.get(name);
        if (currentNode != null) {
            for (ParameterType type : parameterTypes) {
                if ((currentNode = (Node)currentNode.children.get(type)) == null) break;
            }
            result = currentNode;
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public EPackage registerPackage(EPackage ePackage) {
        this.cache.clear();
        return super.registerPackage(ePackage);
    }

    @Override
    public EPackage removePackage(String name) {
        this.cache.clear();
        return super.removePackage(name);
    }

    private static final class Node {
        private final Map<ParameterType, Node> children = new HashMap<ParameterType, Node>();
        private EOperation operation;

        private Node() {
        }
    }

    private static final class ParameterType {
        private final int many;
        private final EClassifier eClassifier;

        public ParameterType(EClassifier eClassifier, boolean many) {
            this.eClassifier = eClassifier;
            this.many = many ? 1 : 0;
        }

        public int hashCode() {
            return this.many ^ this.eClassifier.hashCode();
        }

        public boolean equals(Object obj) {
            boolean result = obj instanceof ParameterType ? ((ParameterType)obj).many == this.many && ((ParameterType)obj).eClassifier == this.eClassifier : false;
            return result;
        }
    }
}

