/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;

public class XPathServices
extends AbstractServiceProvider {
    private static final String ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S = "Only EClass can be contained into other EClasses not %s";
    private static final String S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S = "%s can't contain directly or indirectly %s";
    private final IReadOnlyQueryEnvironment queryEnvironment;

    public XPathServices(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    @Override
    protected IService getService(Method publicMethod) {
        JavaMethodService result = "ancestors".equals(publicMethod.getName()) ? new AncestorsService(publicMethod, (Object)this) : ("followingSiblings".equals(publicMethod.getName()) ? new FollowingSiblingsService(publicMethod, (Object)this) : ("precedingSiblings".equals(publicMethod.getName()) ? new PrecedingSiblingsService(publicMethod, (Object)this) : ("siblings".equals(publicMethod.getName()) ? new SiblingsService(publicMethod, (Object)this) : new JavaMethodService(publicMethod, this))));
        return result;
    }

    @Documentation(value="Returns a Sequence containing the full set of object's ancestors.", params={@Param(name="self", value="The EObject we seek the ancestors of")}, result="Sequence containing the full set of the receiver's ancestors", examples={@Example(expression="eClass.ancestors()", result="Sequence{parentEPackage, grandParentEPackage}")})
    public List<EObject> ancestors(EObject self) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(null);
        return this.ancestors(self, filters);
    }

    @Documentation(value="Returns a Sequence containing the set of object's ancestors of the given type.", params={@Param(name="self", value="The EObject we seek the ancestors of"), @Param(name="filter", value="The filtering EClass")}, result="Sequence containing the set of the receiver's ancestors of the given type", examples={@Example(expression="eClass.ancestors(ecore::EPackage)", result="Sequence{parentEPackage, grandParentEPackage}")})
    public List<EObject> ancestors(EObject self, EClassifier filter) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(filter);
        return this.ancestors(self, filters);
    }

    @Documentation(value="Returns a Sequence containing the set of object's ancestors of any given types.", params={@Param(name="self", value="The EObject we seek the ancestors of"), @Param(name="filters", value="The set of filtering EClasses")}, result="Sequence containing the set of the receiver's ancestors of any given types", examples={@Example(expression="eClass.ancestors({ecore::EPackage | ecore::EClass})", result="Sequence{parentEPackage, grandParentEPackage}")})
    public List<EObject> ancestors(EObject self, Set<EClassifier> filters) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject container = self.eContainer();
        while (container != null) {
            for (EClassifier filter : filters) {
                if (filter != null && !filter.isInstance((Object)container)) continue;
                result.add(container);
                break;
            }
            container = container.eContainer();
        }
        return result;
    }

    @Documentation(value="Returns a Sequence containing the full set of object's following siblings.", params={@Param(name="self", value="The EObject we seek the following siblings of")}, result="Sequence containing the full set of the receiver's following siblings", examples={@Example(expression="eClass3.followingSiblings()", result="Sequence{eClass4, eClass5}")})
    public List<EObject> followingSiblings(EObject self) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(null);
        return this.siblings(self, filters, false);
    }

    @Documentation(value="Returns a Sequence containing the set of object's following siblings of the given type.", params={@Param(name="self", value="The EObject we seek the following siblings of"), @Param(name="filter", value="The filtering EClass")}, result="Sequence containing the set of the receiver's following siblings of the given type", examples={@Example(expression="eClass3.followingSiblings(ecore::EClass)", result="Sequence{eClass4, eClass5}")})
    public List<EObject> followingSiblings(EObject self, EClassifier filter) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(filter);
        return this.siblings(self, filters, false);
    }

    @Documentation(value="Returns a Sequence containing the set of object's following siblings of any given types.", params={@Param(name="self", value="The EObject we seek the following siblings of"), @Param(name="filters", value="The set of filtering EClasses")}, result="Sequence containing the set of the receiver's following siblings of any given types", examples={@Example(expression="eClass3.followingSiblings({ecore::EPackage | ecore::EClass})", result="Sequence{eClass4, eClass5}")})
    public List<EObject> followingSiblings(EObject self, Set<EClassifier> filters) {
        return this.siblings(self, filters, false);
    }

    @Documentation(value="Returns a Sequence containing the full set of object's preceding siblings.", params={@Param(name="self", value="The EObject we seek the preceding siblings of")}, result="Sequence containing the full set of the receiver's preceding siblings", examples={@Example(expression="eClass3.precedingSiblings()", result="Sequence{eClass1, eClass2}")})
    public List<EObject> precedingSiblings(EObject self) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(null);
        return this.siblings(self, filters, true);
    }

    @Documentation(value="Returns a Sequence containing the set of object's preceding siblings of the given type.", params={@Param(name="self", value="The EObject we seek the preceding siblings of"), @Param(name="filter", value="The filtering EClass")}, result="Sequence containing the set of the receiver's preceding siblings of the given type", examples={@Example(expression="eClass3.precedingSiblings(ecore::EClass)", result="Sequence{eClass1, eClass2}")})
    public List<EObject> precedingSiblings(EObject self, EClassifier filter) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(filter);
        return this.siblings(self, filters, true);
    }

    @Documentation(value="Returns a Sequence containing the set of object's preceding siblings of any given types.", params={@Param(name="self", value="The EObject we seek the preceding siblings of"), @Param(name="filters", value="The set of filtering EClasses")}, result="Sequence containing the set of the receiver's preceding siblings of any given types", examples={@Example(expression="eClass3.precedingSiblings({ecore::EPackage | ecore::EClass})", result="Sequence{eClass1, eClass2}")})
    public List<EObject> precedingSiblings(EObject self, Set<EClassifier> filters) {
        return this.siblings(self, filters, true);
    }

    @Documentation(value="Returns a Sequence containing the full set of object's siblings.", params={@Param(name="self", value="The EObject we seek the siblings of")}, result="Sequence containing the full set of the receiver's siblings", examples={@Example(expression="eClass3.siblings()", result="Sequence{eClass1, eClass2, eClass4, eClass5}")})
    public List<EObject> siblings(EObject self) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(null);
        return this.siblings(self, filters);
    }

    @Documentation(value="Returns a Sequence containing the set of object's siblings of the given type.", params={@Param(name="self", value="The EObject we seek the siblings of"), @Param(name="filter", value="The filtering EClass")}, result="Sequence containing the set of the receiver's siblings of the given type", examples={@Example(expression="eClass3.siblings(ecore::EClass)", result="Sequence{eClass1, eClass2, eClass4, eClass5}")})
    public List<EObject> siblings(EObject self, EClassifier filter) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(filter);
        return this.siblings(self, filters);
    }

    @Documentation(value="Returns a Sequence containing the set of object's siblings of any given types.", params={@Param(name="self", value="The EObject we seek the siblings of"), @Param(name="filters", value="The set of filtering EClasses")}, result="Sequence containing the set of the receiver's siblings of any given types", examples={@Example(expression="eClass3.siblings({ecore::EPackage | ecore::EClass})", result="Sequence{eClass1, eClass2, eClass1, eClass2}")})
    public List<EObject> siblings(EObject eObject, Set<EClassifier> filters) {
        List<Object> result;
        Object container = this.getContainer(eObject);
        if (container != null) {
            result = Lists.newArrayList();
            block0: for (EObject input : this.getContents(container)) {
                for (EClassifier filter : filters) {
                    if (input == eObject || filter != null && !filter.isInstance((Object)input.eClass()) && !filter.equals(input.eClass())) continue;
                    result.add(input);
                    continue block0;
                }
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<EObject> siblings(EObject eObject, Set<EClassifier> filters, Boolean preceding) {
        ArrayList result;
        Object container = this.getContainer(eObject);
        if (container != null) {
            List<EObject> siblings = this.getContents(container);
            int startIndex = 0;
            int endIndex = siblings.size();
            if (preceding.booleanValue()) {
                endIndex = siblings.indexOf(eObject);
            } else {
                startIndex = siblings.indexOf(eObject) + 1;
            }
            result = Lists.newArrayList();
            block0: for (EObject input : siblings.subList(startIndex, endIndex)) {
                for (EClassifier filter : filters) {
                    if (filter != null && !filter.isInstance((Object)input.eClass()) && !filter.equals(input.eClass())) continue;
                    result.add(input);
                    continue block0;
                }
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private Object getContainer(EObject object) {
        EObject result = object.eContainer();
        if (result == null && object instanceof InternalEObject) {
            result = ((InternalEObject)object).eDirectResource();
        }
        return result;
    }

    private List<EObject> getContents(Object container) {
        List<Object> contents = container instanceof EObject ? this.getContents((EObject)container) : (container instanceof Resource ? this.getRoots((Resource)container) : Collections.emptyList());
        return contents;
    }

    private List<EObject> getContents(EObject eObject) {
        ArrayList<EObject> result = new ArrayList<EObject>((Collection<EObject>)eObject.eContents());
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            if (!reference.isContainment() || !reference.isDerived()) continue;
            Object value = eObject.eGet((EStructuralFeature)reference);
            if (value instanceof Collection) {
                for (Object newValue : (Collection)value) {
                    if (result.contains(newValue) || !(newValue instanceof EObject)) continue;
                    result.add((EObject)newValue);
                }
                continue;
            }
            if (result.contains(value) || !(value instanceof EObject)) continue;
            result.add((EObject)value);
        }
        return result;
    }

    private List<EObject> getRoots(Resource resource) {
        Object result = resource.getContents();
        ListIterator iter = result.listIterator();
        while (iter.hasNext()) {
            if (((EObject)iter.next()).eContainer() == null) continue;
            int where = iter.previousIndex();
            ArrayList newResult = new ArrayList(result.size() - 1);
            newResult.addAll(result.subList(0, where));
            result = newResult;
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                if (next.eContainer() != null) continue;
                result.add(next);
            }
        }
        return result;
    }

    private static void addEObjectEClass(Set<IType> types, IReadOnlyQueryEnvironment queryEnvironment) {
        for (EClassifier classifier : queryEnvironment.getEPackageProvider().getTypes("ecore", "EObject")) {
            types.add(new EClassifierType(queryEnvironment, classifier));
        }
    }

    private static final class AncestorsService
    extends FilterService {
        private AncestorsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                        for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClassifier)));
                        }
                    } else if (argTypes.size() == 2) {
                        result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing(XPathServices.ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S, argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass containingEClass : queryEnvironment.getEPackageProvider().getAllContainingEClasses(receiverEClass)) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)containingEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't be contained", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                LinkedHashSet filterTypes = Sets.newLinkedHashSet();
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    filterTypes.add(argTypes.get(1));
                } else {
                    XPathServices.addEObjectEClass(filterTypes, queryEnvironment);
                }
                for (IType filterType : filterTypes) {
                    for (EClass containingEClass : queryEnvironment.getEPackageProvider().getAllContainingEClasses(receiverEClass)) {
                        IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containingEClass), filterType);
                        if (lowerType == null) continue;
                        result.add(new SequenceType(queryEnvironment, lowerType));
                    }
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing(XPathServices.S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S, argTypes.get(1), argTypes.get(0))));
                }
            }
            return result;
        }
    }

    private static final class FollowingSiblingsService
    extends FilterService {
        private FollowingSiblingsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                        for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClassifier)));
                        }
                    } else if (argTypes.size() == 2) {
                        result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can have following siblings not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass followingEClass : queryEnvironment.getEPackageProvider().getFollowingSiblingsEClasses(receiverEClass)) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)followingEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't have following siblings", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                LinkedHashSet filterTypes = Sets.newLinkedHashSet();
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    filterTypes.add(argTypes.get(1));
                } else {
                    XPathServices.addEObjectEClass(filterTypes, queryEnvironment);
                }
                for (IType filterType : filterTypes) {
                    for (EClass followingEClass : queryEnvironment.getEPackageProvider().getFollowingSiblingsEClasses(receiverEClass)) {
                        IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)followingEClass), filterType);
                        if (lowerType == null) continue;
                        result.add(new SequenceType(queryEnvironment, lowerType));
                    }
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't be a following sibling of %s", argTypes.get(1), argTypes.get(0))));
                }
            }
            return result;
        }
    }

    private static final class PrecedingSiblingsService
    extends FilterService {
        private PrecedingSiblingsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                        for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClassifier)));
                        }
                    } else if (argTypes.size() == 2) {
                        result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can have preceding siblings not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass precedingEClass : queryEnvironment.getEPackageProvider().getPrecedingSiblingsEClasses(receiverEClass)) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)precedingEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't have preceding siblings", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                LinkedHashSet filterTypes = Sets.newLinkedHashSet();
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    filterTypes.add(argTypes.get(1));
                } else {
                    XPathServices.addEObjectEClass(filterTypes, queryEnvironment);
                }
                for (IType filterType : filterTypes) {
                    for (EClass precedingEClass : queryEnvironment.getEPackageProvider().getPrecedingSiblingsEClasses(receiverEClass)) {
                        IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)precedingEClass), filterType);
                        if (lowerType == null) continue;
                        result.add(new SequenceType(queryEnvironment, lowerType));
                    }
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't be a preceding sibling of %s", argTypes.get(1), argTypes.get(0))));
                }
            }
            return result;
        }
    }

    private static final class SiblingsService
    extends FilterService {
        private SiblingsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                        for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClassifier)));
                        }
                    } else if (argTypes.size() == 2) {
                        result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can have siblings not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass siblingEClass : queryEnvironment.getEPackageProvider().getSiblingsEClasses(receiverEClass)) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)siblingEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't have siblings", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                LinkedHashSet filterTypes = Sets.newLinkedHashSet();
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    filterTypes.add(argTypes.get(1));
                } else {
                    XPathServices.addEObjectEClass(filterTypes, queryEnvironment);
                }
                for (IType filterType : filterTypes) {
                    for (EClass siblingEClass : queryEnvironment.getEPackageProvider().getSiblingsEClasses(receiverEClass)) {
                        IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)siblingEClass), filterType);
                        if (lowerType == null) continue;
                        result.add(new SequenceType(queryEnvironment, lowerType));
                    }
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't be a sibling of %s", argTypes.get(1), argTypes.get(0))));
                }
            }
            return result;
        }
    }
}

