/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.ui.internal.notification;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorCache {
    public static final RGB BLACK = new RGB(0, 0, 0);
    public static final RGB WHITE = new RGB(255, 255, 255);
    private static Map<RGB, Color> colorTable = new HashMap<RGB, Color>();
    private static ColorCache instance;

    static {
        new ColorCache();
    }

    private ColorCache() {
        instance = this;
    }

    public static ColorCache getInstance() {
        return instance;
    }

    public static void disposeColors() {
        Iterator<Color> e = colorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
        colorTable.clear();
    }

    public static Color getWhite() {
        int max = 255;
        return ColorCache.getColorFromRGB(new RGB(255, 255, 255));
    }

    public static Color getBlack() {
        return ColorCache.getColorFromRGB(new RGB(0, 0, 0));
    }

    public static Color getColorFromRGB(RGB rgb) {
        Color color = colorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public static Color getColor(int r, int g, int b) {
        RGB rgb = new RGB(r, g, b);
        Color color = colorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }
}

