/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.runtime.impl.namespace.workspace;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.ide.runtime.namespace.workspace.IWorkspaceResolverProvider;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryProject;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspace;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public abstract class Synchronizer<P extends IQueryProject>
implements IResourceVisitor,
IResourceChangeListener,
IResourceDeltaVisitor,
IWorkspaceResolverProvider {
    private final IWorkspace eclipseWorkspace;
    private final IQueryWorkspace<P> queryWorkspace;
    private final Map<IProject, P> eclipseToProject = new HashMap<IProject, P>();
    private final Map<P, IProject> projectToEclipse = new HashMap<P, IProject>();
    private IProgressMonitor monitor;

    public Synchronizer(IWorkspace eclipseWorkspace, IQueryWorkspace<P> queryWorkspace) {
        this.eclipseWorkspace = eclipseWorkspace;
        this.queryWorkspace = queryWorkspace;
    }

    public void synchronize() {
        Job synchronizeJob = Job.create((String)("Synchronizing " + this.queryWorkspace.getName()), (ICoreRunnable)new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    IProject[] iProjectArray = Synchronizer.this.eclipseWorkspace.getRoot().getProjects();
                    int n = iProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (project.isAccessible()) {
                            Synchronizer.this.getOrCreateProject(Synchronizer.this.getQueryWorkspace(), project);
                        }
                        ++n2;
                    }
                    Synchronizer.this.eclipseWorkspace.addResourceChangeListener((IResourceChangeListener)Synchronizer.this);
                    ResourceCounter resourceCounter = new ResourceCounter();
                    Synchronizer.this.eclipseWorkspace.getRoot().accept((IResourceVisitor)resourceCounter);
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Validating", (int)resourceCounter.getCount());
                    Synchronizer.this.monitor = subMonitor;
                    try {
                        Synchronizer.this.eclipseWorkspace.getRoot().accept((IResourceVisitor)Synchronizer.this);
                    }
                    finally {
                        Synchronizer.this.monitor = null;
                    }
                }
                catch (Exception e) {
                    Synchronizer.this.dispose();
                    QueryPlugin.INSTANCE.log(new Status(4, this.getClass(), "can't visit the workspace current state: " + Synchronizer.this.eclipseWorkspace.getRoot().getLocationURI().toString(), (Throwable)e));
                }
            }
        });
        synchronizeJob.schedule();
    }

    public void dispose() {
        this.eclipseWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException coreException) {
            URI workspaceURI = this.eclipseWorkspace.getRoot().getLocationURI();
            QueryPlugin.INSTANCE.log(new Status(4, this.getClass(), "There was an issue while updating workspace" + String.valueOf(workspaceURI), (Throwable)coreException));
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getFlags() != 131072) {
            IResource resource = delta.getResource();
            if (resource.getType() == 4) {
                IProject workspaceProject = (IProject)resource;
                this.visitProjectDelta(delta, workspaceProject);
            } else if (resource.getType() == 1) {
                IFile file = (IFile)resource;
                this.visitFileDelta(delta, file);
            }
        }
        return true;
    }

    private void visitFileDelta(IResourceDelta delta, IFile file) {
        if (delta.getKind() == 4) {
            if ((delta.getFlags() & 0x100) != 0) {
                this.queryWorkspace.changeResource(this.getProject(file.getProject()), file.getLocationURI());
            }
            if ((delta.getFlags() & 0x100000) != 0) {
                this.queryWorkspace.changeResource(this.getProject(file.getProject()), file.getLocationURI());
            }
            if ((delta.getFlags() & 0x1000) != 0) {
                this.queryWorkspace.changeResource(this.getProject(file.getProject()), file.getLocationURI());
            }
            delta.getFlags();
            if ((delta.getFlags() & 0x40000) != 0) {
                this.queryWorkspace.changeResource(this.getProject(file.getProject()), file.getLocationURI());
            }
        } else if (delta.getKind() == 1) {
            this.queryWorkspace.addResource(this.getProject(file.getProject()), file.getLocationURI());
        } else if (delta.getKind() == 2) {
            this.queryWorkspace.removeResource(this.getProject(file.getProject()), file.getLocationURI());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitProjectDelta(IResourceDelta delta, IProject eclipseProject) {
        if (delta.getKind() == 4) {
            if ((delta.getFlags() & 0x100000) != 0) {
                this.queryWorkspace.removeProject(this.getProject(eclipseProject));
                this.queryWorkspace.addProject(this.getProject(eclipseProject));
            }
            if ((delta.getFlags() & 0x1000) != 0) {
                this.queryWorkspace.removeProject(this.getProject(eclipseProject));
                this.queryWorkspace.addProject(this.getProject(eclipseProject));
            }
            delta.getFlags();
            if ((delta.getFlags() & 0x40000) != 0) {
                this.queryWorkspace.removeProject(this.getProject(eclipseProject));
                this.queryWorkspace.addProject(this.getProject(eclipseProject));
            }
        } else if (delta.getKind() == 1) {
            Synchronizer synchronizer = this;
            synchronized (synchronizer) {
                this.getOrCreateProject(this.queryWorkspace, eclipseProject);
            }
        } else if (delta.getKind() == 2) {
            IQueryProject removedProject = (IQueryProject)this.eclipseToProject.remove(eclipseProject);
            this.projectToEclipse.remove(removedProject);
            this.queryWorkspace.removeProject((Object)removedProject);
        }
    }

    public boolean visit(IResource resource) throws CoreException {
        boolean res;
        IProject project = resource.getProject();
        if (project == null || project.isOpen()) {
            boolean hasMonitor;
            boolean bl = hasMonitor = this.monitor != null;
            if (hasMonitor) {
                this.monitor.subTask(resource.getFullPath().toString());
            }
            try {
                this.add(resource);
            }
            finally {
                if (hasMonitor) {
                    this.monitor.worked(1);
                }
            }
            res = true;
        } else {
            res = resource instanceof IWorkspaceRoot;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IResource resource) {
        Objects.requireNonNull(resource);
        if (resource.getType() == 4) {
            IProject eclipseProject = (IProject)resource;
            Synchronizer synchronizer = this;
            synchronized (synchronizer) {
                this.getOrCreateProject(this.queryWorkspace, eclipseProject);
            }
        } else if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            URI uri = file.getLocationURI();
            this.queryWorkspace.addResource(this.getProject(file.getProject()), uri);
        }
    }

    @Override
    public IQueryWorkspaceQualifiedNameResolver getResolver(IProject project) {
        return this.queryWorkspace.getResolver((Object)((IQueryProject)this.eclipseToProject.getOrDefault(project, this.getOrCreateProject(this.queryWorkspace, project))));
    }

    public P getProject(IProject project) {
        return (P)((IQueryProject)this.eclipseToProject.get(project));
    }

    public IProject getProject(P project) {
        return this.projectToEclipse.get(project);
    }

    public IQueryWorkspace<P> getQueryWorkspace() {
        return this.queryWorkspace;
    }

    public IWorkspace getEclipseWorkspace() {
        return this.eclipseWorkspace;
    }

    public P getOrCreateProject(IQueryWorkspace<P> queryWorkspace, IProject eclipseProject) {
        Object res;
        if (this.eclipseToProject.containsKey(eclipseProject)) {
            res = (IQueryProject)this.eclipseToProject.get(eclipseProject);
        } else {
            res = this.createProject(queryWorkspace, eclipseProject);
            IQueryProject oldProject = (IQueryProject)this.eclipseToProject.put(eclipseProject, res);
            this.projectToEclipse.remove(oldProject);
            this.projectToEclipse.put(res, eclipseProject);
            queryWorkspace.addProject(res);
        }
        return res;
    }

    public IProject getOrCreateProject(P project) {
        IProject res;
        if (this.projectToEclipse.containsKey(project)) {
            res = this.projectToEclipse.get(project);
        } else {
            res = this.eclipseWorkspace.getRoot().getProject(project.getName());
            IQueryProject oldProject = (IQueryProject)this.eclipseToProject.put(res, project);
            this.projectToEclipse.remove(oldProject);
            this.projectToEclipse.put(project, res);
        }
        return res;
    }

    protected abstract P createProject(IQueryWorkspace<P> var1, IProject var2);

    private final class ResourceCounter
    implements IResourceVisitor {
        private int count;

        private ResourceCounter() {
        }

        public boolean visit(IResource resource) throws CoreException {
            boolean res;
            IProject project = resource.getProject();
            if (project == null || project.isOpen()) {
                ++this.count;
                res = true;
            } else {
                res = resource instanceof IWorkspaceRoot;
            }
            return res;
        }

        public int getCount() {
            return this.count;
        }
    }
}

