/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ast.test.delegates;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.acceleo.query.delegates.AQLInvocationDelegateFactory;
import org.eclipse.acceleo.query.delegates.AQLSettingDelegateFactory;
import org.eclipse.acceleo.query.delegates.AQLValidationDelegate;
import org.eclipse.acceleo.query.delegates.DelegateUtils;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DelegateTests {
    private static EPackage ePackage;
    private static EClass eClass;
    private static EAttribute eAttribute1;
    private static EAttribute eAttribute2;
    private static EReference eReference;
    private static EOperation eOperation;
    private static EClass eClassParsingError;
    private static EAttribute eAttribute1ParsingError;
    private static EAttribute eAttribute2ParsingError;
    private static EReference eReferenceParsingError;
    private static EOperation eOperationParsingError;
    private static EClass eClassEvaluationError;
    private static EAttribute eAttribute1EvaluationError;
    private static EAttribute eAttribute2EvaluationError;
    private static EReference eReferenceEvaluationError;
    private static EOperation eOperationEvaluationError;

    @BeforeClass
    public static void beforeClass() {
        EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.put((Object)"http://www.eclipse.org/acceleo/query/1.0", (Object)new AQLInvocationDelegateFactory());
        EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.put((Object)"http://www.eclipse.org/acceleo/query/1.0", (Object)new AQLSettingDelegateFactory());
        EValidator.ValidationDelegate.Registry.INSTANCE.put((Object)"http://www.eclipse.org/acceleo/query/1.0", (Object)new AQLValidationDelegate());
        ePackage = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePackage.setName("testEPackage");
        ePackage.setNsPrefix("test");
        ePackage.setNsURI("test");
        eClass = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eClass.setName("TestEClass");
        ePackage.getEClassifiers().add((Object)eClass);
        eAttribute1 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eAttribute1.setName("testAttribute1");
        eAttribute1.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eClass.getEStructuralFeatures().add((Object)eAttribute1);
        eAttribute2 = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eAttribute2.setName("testAttribute2");
        eAttribute2.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eClass.getEStructuralFeatures().add((Object)eAttribute2);
        eReference = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        eReference.setName("testReference");
        eReference.setEType((EClassifier)eClass);
        eClass.getEStructuralFeatures().add((Object)eReference);
        eOperation = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        eOperation.setName("testOperation");
        eOperation.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eClass.getEOperations().add((Object)eOperation);
        EParameter eParameter1 = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        eParameter1.setName("testParameter1");
        eParameter1.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eOperation.getEParameters().add((Object)eParameter1);
        EParameter eParameter2 = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        eParameter2.setName("testParameter2");
        eParameter2.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eOperation.getEParameters().add((Object)eParameter2);
        eClassParsingError = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eClassParsingError.setName("TestEClassParsingError");
        ePackage.getEClassifiers().add((Object)eClassParsingError);
        eAttribute1ParsingError = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eAttribute1ParsingError.setName("testAttribute1ParsingError");
        eAttribute1ParsingError.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eClassParsingError.getEStructuralFeatures().add((Object)eAttribute1ParsingError);
        eAttribute2ParsingError = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eAttribute2ParsingError.setName("testAttribute2ParsingError");
        eAttribute2ParsingError.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eClassParsingError.getEStructuralFeatures().add((Object)eAttribute2ParsingError);
        eReferenceParsingError = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        eReferenceParsingError.setName("testReferenceParsingError");
        eReferenceParsingError.setEType((EClassifier)eClass);
        eClassParsingError.getEStructuralFeatures().add((Object)eReferenceParsingError);
        eOperationParsingError = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        eOperationParsingError.setName("testOperationParsingError");
        eOperationParsingError.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eClassParsingError.getEOperations().add((Object)eOperationParsingError);
        EParameter eParameter1ParsingError = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        eParameter1ParsingError.setName("testParameter1ParsingError");
        eParameter1ParsingError.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eOperationParsingError.getEParameters().add((Object)eParameter1ParsingError);
        EParameter eParameter2ParsingError = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        eParameter2ParsingError.setName("testParameter2ParsingError");
        eParameter2ParsingError.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eOperationParsingError.getEParameters().add((Object)eParameter2ParsingError);
        eClassEvaluationError = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eClassEvaluationError.setName("TestEClassEvaluationError");
        ePackage.getEClassifiers().add((Object)eClassEvaluationError);
        eAttribute1EvaluationError = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eAttribute1EvaluationError.setName("testAttribute1EvaluationError");
        eAttribute1EvaluationError.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eClassEvaluationError.getEStructuralFeatures().add((Object)eAttribute1EvaluationError);
        eAttribute2EvaluationError = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eAttribute2EvaluationError.setName("testAttribute2EvaluationError");
        eAttribute2EvaluationError.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eClassEvaluationError.getEStructuralFeatures().add((Object)eAttribute2EvaluationError);
        eReferenceEvaluationError = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        eReferenceEvaluationError.setName("testReferenceEvaluationError");
        eReferenceEvaluationError.setEType((EClassifier)eClass);
        eClassEvaluationError.getEStructuralFeatures().add((Object)eReferenceEvaluationError);
        eOperationEvaluationError = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        eOperationEvaluationError.setName("testOperationEvaluationError");
        eOperationEvaluationError.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eClassEvaluationError.getEOperations().add((Object)eOperationEvaluationError);
        EParameter eParameter1EvaluationError = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        eParameter1EvaluationError.setName("testParameter1EvaluationError");
        eParameter1EvaluationError.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eOperationEvaluationError.getEParameters().add((Object)eParameter1EvaluationError);
        EParameter eParameter2EvaluationError = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        eParameter2EvaluationError.setName("testParameter2EvaluationError");
        eParameter2EvaluationError.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eOperationEvaluationError.getEParameters().add((Object)eParameter2EvaluationError);
        DelegateUtils.setInvocationDelegates((EPackage)ePackage);
        DelegateUtils.setSettingDelegates((EPackage)ePackage);
        DelegateUtils.setValidationDelegates((EPackage)ePackage);
        DelegateUtils.setDerivation((EStructuralFeature)eReference, (String)"self.eClass.name");
        DelegateUtils.setDerivation((EStructuralFeature)eReferenceParsingError, (String)"self.");
        DelegateUtils.setDerivation((EStructuralFeature)eReferenceEvaluationError, (String)"notAVariable");
        DelegateUtils.setConstraint((EModelElement)eClass, (String)"AttributeIsShort", (String)"self.testAttribute1.size() < 5");
        DelegateUtils.setConstraint((EModelElement)eClassParsingError, (String)"AttributeParsingError", (String)"5 < ");
        DelegateUtils.setConstraint((EModelElement)eClassEvaluationError, (String)"AttributeParsingError", (String)"notAVariable");
        DelegateUtils.setDerivation((EStructuralFeature)eReference, (String)"self");
        DelegateUtils.setDerivation((EStructuralFeature)eReferenceParsingError, (String)"5 < ");
        DelegateUtils.setDerivation((EStructuralFeature)eReferenceEvaluationError, (String)"notAVariable");
        DelegateUtils.setBody((EOperation)eOperation, (String)"testParameter1 + testParameter2");
        DelegateUtils.setBody((EOperation)eOperationParsingError, (String)"testParameter1 +");
        DelegateUtils.setBody((EOperation)eOperationEvaluationError, (String)"notAVariable");
    }

    @Test
    public void derivation() {
        EObject eObj = EcoreUtil.create((EClass)eClass);
        Object value = eObj.eGet((EStructuralFeature)eReference);
        Assert.assertEquals((Object)eObj, (Object)value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void derivationParsingError() {
        EObject eObj = EcoreUtil.create((EClass)eClassParsingError);
        Object value = eObj.eGet((EStructuralFeature)eReferenceParsingError);
        Assert.assertEquals((Object)eObj, (Object)value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void derivationEvaluationError() {
        EObject eObj = EcoreUtil.create((EClass)eClassEvaluationError);
        eObj.eGet((EStructuralFeature)eReferenceEvaluationError);
    }

    @Test
    public void constraintOK() {
        EObject eObj = EcoreUtil.create((EClass)eClass);
        eObj.eSet((EStructuralFeature)eAttribute1, (Object)"abc");
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObj);
        Assert.assertEquals((long)0L, (long)diagnostic.getSeverity());
    }

    @Test
    public void constraintKO() {
        EObject eObj = EcoreUtil.create((EClass)eClass);
        eObj.eSet((EStructuralFeature)eAttribute1, (Object)"abcdefgh");
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObj);
        Assert.assertEquals((long)4L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)1L, (long)diagnostic.getChildren().size());
        Assert.assertTrue((boolean)((Diagnostic)diagnostic.getChildren().get(0)).getMessage().startsWith("The 'AttributeIsShort' constraint is violated on"));
    }

    @Test
    public void constraintParsingError() {
        EObject eObj = EcoreUtil.create((EClass)eClassParsingError);
        eObj.eSet((EStructuralFeature)eAttribute1ParsingError, (Object)"abc");
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObj);
        Assert.assertEquals((long)4L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)2L, (long)diagnostic.getChildren().size());
        Assert.assertTrue((boolean)((Diagnostic)diagnostic.getChildren().get(0)).getMessage().endsWith("missing expression"));
        Assert.assertTrue((boolean)((Diagnostic)diagnostic.getChildren().get(1)).getMessage().startsWith("Validation failed with an exception for '"));
    }

    @Test
    public void constraintEvaluationError() {
        EObject eObj = EcoreUtil.create((EClass)eClassEvaluationError);
        eObj.eSet((EStructuralFeature)eAttribute1EvaluationError, (Object)"abc");
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObj);
        Assert.assertEquals((long)4L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)1L, (long)diagnostic.getChildren().size());
        Assert.assertTrue((boolean)((Diagnostic)diagnostic.getChildren().get(0)).getMessage().endsWith("Couldn't find the 'notAVariable' variable"));
    }

    @Test
    public void body() throws InvocationTargetException {
        EObject eObj = EcoreUtil.create((EClass)eClass);
        BasicEList arguments = new BasicEList();
        arguments.add((Object)"abc");
        arguments.add((Object)"def");
        Object value = eObj.eInvoke(eOperation, (EList)arguments);
        Assert.assertEquals((Object)"abcdef", (Object)value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void bodyParsingError() throws InvocationTargetException {
        EObject eObj = EcoreUtil.create((EClass)eClassParsingError);
        BasicEList arguments = new BasicEList();
        arguments.add((Object)"abc");
        arguments.add((Object)"def");
        eObj.eInvoke(eOperationParsingError, (EList)arguments);
    }

    @Test(expected=InvocationTargetException.class)
    public void bodyEvaluationError() throws InvocationTargetException {
        EObject eObj = EcoreUtil.create((EClass)eClassEvaluationError);
        BasicEList arguments = new BasicEList();
        arguments.add((Object)"abc");
        arguments.add((Object)"def");
        eObj.eInvoke(eOperationEvaluationError, (EList)arguments);
    }

    @Test(expected=IllegalArgumentException.class)
    public void bodyEvaluationWrongNumberOfArguments() throws InvocationTargetException {
        EObject eObj = EcoreUtil.create((EClass)eClassEvaluationError);
        BasicEList arguments = new BasicEList();
        arguments.add((Object)"abc");
        arguments.add((Object)"def");
        arguments.add((Object)"def");
        eObj.eInvoke(eOperationEvaluationError, (EList)arguments);
    }
}

