/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.QueryCompletionEngine;
import org.eclipse.acceleo.query.tests.Setup;
import org.eclipse.acceleo.query.tests.UnitTestModels;
import org.eclipse.acceleo.query.tests.qmodel.EObjectVariable;
import org.eclipse.acceleo.query.tests.qmodel.QmodelPackage;
import org.eclipse.acceleo.query.tests.qmodel.Query;
import org.eclipse.acceleo.query.tests.qmodel.Variable;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompletionCheck {
    private UnitTestModels qmodels;

    @Before
    public void setUp() {
        this.qmodels = new UnitTestModels(Setup.createSetupForCurrentEnvironment());
    }

    @Test
    public void testReverseCompletion() throws Exception {
        Stream<Query> queries = this.toStream((Iterator)this.qmodels.reverse().getAllContents()).filter(Query.class::isInstance).map(Query.class::cast);
        this.checkCompletionOnQueries(queries.iterator());
    }

    @Test
    public void testAnyDSLCompletion() throws Exception {
        Stream<Query> queries = this.toStream((Iterator)this.qmodels.anydsl().getAllContents()).filter(Query.class::isInstance).map(Query.class::cast);
        this.checkCompletionOnQueries(queries.iterator());
    }

    @Test
    public void testUMLCompletion() throws Exception {
        Stream<Query> queries = this.toStream((Iterator)this.qmodels.uml().getAllContents()).filter(Query.class::isInstance).map(Query.class::cast);
        this.checkCompletionOnQueries(queries.iterator());
    }

    @Test
    public void testUMLWithFragmentCompletion() throws Exception {
        Stream<Query> queries = this.toStream((Iterator)this.qmodels.umlWithFragment().getAllContents()).filter(Query.class::isInstance).map(Query.class::cast);
        this.checkCompletionOnQueries(queries.iterator());
    }

    private void checkCompletionOnQueries(Iterator<Query> queries) throws Exception {
        while (queries.hasNext()) {
            Query next = queries.next();
            IQueryEnvironment queryEnvironment = org.eclipse.acceleo.query.runtime.Query.newEnvironmentWithDefaultServices(null);
            queryEnvironment.registerEPackage((EPackage)QmodelPackage.eINSTANCE);
            QueryCompletionEngine completionEngine = new QueryCompletionEngine((IReadOnlyQueryEnvironment)queryEnvironment);
            for (String classToImport : next.getClassesToImport()) {
                Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, Class.forName(classToImport));
                ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
            }
            HashMap variableTypes = new HashMap();
            HashSet<EClassifierType> selfType = new HashSet<EClassifierType>();
            selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)queryEnvironment, (EClassifier)next.getStartingPoint().eClass()));
            variableTypes.put("self", selfType);
            for (Variable var : next.getVariables()) {
                Assert.assertTrue((boolean)(var instanceof EObjectVariable));
                LinkedHashSet<EClassifierType> types = new LinkedHashSet<EClassifierType>();
                types.add(new EClassifierType((IReadOnlyQueryEnvironment)queryEnvironment, (EClassifier)((EObjectVariable)var).getValue().getTarget().eClass()));
                variableTypes.put(var.getName(), types);
            }
            int offset = 0;
            while (offset < next.getExpression().length()) {
                try {
                    completionEngine.getCompletion(next.getExpression(), offset, variableTypes);
                }
                catch (Exception e) {
                    throw new RuntimeException("error getting completion on " + next.getExpression() + " at offset " + offset, e);
                }
                ++offset;
            }
        }
    }

    private <T> Stream<T> toStream(Iterator<T> iterator) {
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

