/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import org.eclipse.acceleo.query.tests.InterpreterUnderTest;
import org.eclipse.acceleo.query.tests.QueryResultAssert;
import org.eclipse.acceleo.query.tests.qmodel.Query;
import org.eclipse.acceleo.query.tests.qmodel.QueryEvaluationResult;
import org.eclipse.acceleo.query.tests.qmodel.QueryEvaluationResultExpectation;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class TestEvaluationQModel {
    private QueryEvaluationResultExpectation expectation;
    protected InterpreterUnderTest underTest;

    public TestEvaluationQModel(QueryEvaluationResultExpectation expect, String name) {
        this.expectation = expect;
    }

    @Test
    public void test() {
        if (this.expectation instanceof QueryEvaluationResultExpectation) {
            QueryEvaluationResultExpectation qExpect = this.expectation;
            Query q = (Query)qExpect.eContainer();
            this.underTest = this.getInterpreter(q);
            this.underTest.compileQuery(q);
            QueryEvaluationResult actualResult = this.underTest.computeQuery(q);
            QueryResultAssert.assertEquivalentEvaluation(qExpect.getExpectedResult(), actualResult);
        }
    }

    protected abstract InterpreterUnderTest getInterpreter(Query var1);

    protected static Collection<Object[]> expectationsFrom(Resource reverse) throws URISyntaxException, IOException {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        Iterable allContents = () -> reverse.getAllContents();
        int i = 0;
        Iterator filtered = StreamSupport.stream(allContents.spliterator(), false).filter(QueryEvaluationResultExpectation.class::isInstance).map(QueryEvaluationResultExpectation.class::cast).iterator();
        while (filtered.hasNext()) {
            QueryEvaluationResultExpectation cur = (QueryEvaluationResultExpectation)filtered.next();
            if (cur.getExpectedResult() == null) continue;
            parameters.add(new Object[]{cur, ++i + " " + ((Query)cur.eContainer()).getExpression()});
        }
        return parameters;
    }
}

