/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.LinkedHashMap;
import org.eclipse.acceleo.aql.evaluation.writer.AcceleoFileWriter;
import org.eclipse.acceleo.aql.ide.Activator;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.URIConverter;

public class AcceleoWorkspaceFileWriter
extends AcceleoFileWriter {
    private static final int BUFFER_SIZE = 8192;

    public AcceleoWorkspaceFileWriter(URI fileURI, URIConverter uriConverter, Charset charset) throws IOException {
        super(fileURI, uriConverter, charset);
    }

    public void close() throws IOException {
        if (!(EMFPlugin.IS_ECLIPSE_RUNNING && "java".equals(this.getTargetURI().fileExtension()) && this.uriConverter.exists(this.getTargetURI(), new LinkedHashMap()))) {
            super.close();
        } else {
            try {
                Class.forName("org.eclipse.emf.codegen.merge.java.JMerger");
                this.buffer.close();
                String mergedContent = this.mergeFileContent(this.getTargetURI(), this.temporaryFilePath, this.charset);
                OutputStream output = this.uriConverter.createOutputStream(this.getTargetURI());
                if (mergedContent != null) {
                    OutputStreamWriter writer = new OutputStreamWriter(output, this.charset);
                    writer.append(mergedContent);
                    writer.close();
                } else {
                    Files.copy(this.temporaryFilePath, output);
                }
            }
            catch (ClassNotFoundException e) {
                super.close();
            }
        }
    }

    private String mergeFileContent(URI targetURI, Path tempFile, Charset contentCharset) throws IOException {
        String jmergeFile = URI.createPlatformPluginURI((String)"org.eclipse.emf.codegen.ecore/templates/emf-merge.xml", (boolean)false).toString();
        JControlModel model = new JControlModel();
        model.initialize((FacadeHelper)new ASTFacadeHelper(), jmergeFile);
        InputStream existingContent = this.uriConverter.createInputStream(targetURI);
        if (model.canMerge()) {
            InputStream source = Files.newInputStream(tempFile, new OpenOption[0]);
            try {
                JMerger jMerger = new JMerger(model);
                jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForInputStream(source, contentCharset.toString()));
                jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(existingContent, contentCharset.toString()));
                jMerger.merge();
                return jMerger.getTargetCompilationUnit().getContents();
            }
            catch (WrappedException e) {
                try {
                    this.createLostFile(targetURI);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Activator.log("Cannot use JMerge on " + this.getTargetURI().toString(), false);
            }
        }
        return null;
    }

    private void createLostFile(URI fileURI) throws IOException {
        InputStream source = this.uriConverter.createInputStream(fileURI);
        OutputStream destination = this.uriConverter.createOutputStream(fileURI.appendFileExtension("lost"));
        StringBuilder timestamp = new StringBuilder();
        timestamp.append('\n').append(Calendar.getInstance().getTime().toString()).append('\n');
        timestamp.append("================================================================================");
        timestamp.append('\n');
        destination.write(timestamp.toString().getBytes());
        AcceleoWorkspaceFileWriter.copy(source, destination);
    }

    private static void copy(InputStream source, OutputStream sink) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
        }
    }
}

