/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public class AcceleoFileWriter
implements IAcceleoWriter {
    protected final Path temporaryFilePath;
    protected final Writer buffer;
    protected final Charset charset;
    protected final URIConverter uriConverter;
    private final URI fileURI;

    public AcceleoFileWriter(URI fileURI, URIConverter uriConverter, Charset charset) throws IOException {
        this.fileURI = fileURI;
        this.uriConverter = uriConverter;
        this.charset = charset;
        this.temporaryFilePath = Files.createTempFile("acceleo_", "_generated", new FileAttribute[0]);
        this.buffer = Files.newBufferedWriter(this.temporaryFilePath, charset, new OpenOption[0]);
    }

    @Override
    public URI getTargetURI() {
        return this.fileURI;
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
        OutputStream output = this.uriConverter.createOutputStream(this.fileURI);
        Files.copy(this.temporaryFilePath, output);
        output.close();
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.buffer.append(csq);
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        return this.buffer.append(csq, start, end);
    }

    @Override
    public Appendable append(char c) throws IOException {
        return this.buffer.append(c);
    }
}

