/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.validation;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.ErrorBinding;
import org.eclipse.acceleo.ErrorBlockComment;
import org.eclipse.acceleo.ErrorComment;
import org.eclipse.acceleo.ErrorExpressionStatement;
import org.eclipse.acceleo.ErrorFileStatement;
import org.eclipse.acceleo.ErrorForStatement;
import org.eclipse.acceleo.ErrorIfStatement;
import org.eclipse.acceleo.ErrorImport;
import org.eclipse.acceleo.ErrorLetStatement;
import org.eclipse.acceleo.ErrorMetamodel;
import org.eclipse.acceleo.ErrorModule;
import org.eclipse.acceleo.ErrorProtectedArea;
import org.eclipse.acceleo.ErrorQuery;
import org.eclipse.acceleo.ErrorTemplate;
import org.eclipse.acceleo.ErrorVariable;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleElementDocumentation;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.ProtectedArea;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.validation.AcceleoValidationResult;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.ValidationMessage;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.ecore.EPackage;

public class AcceleoValidator
extends AcceleoSwitch<Object> {
    private static final String IS_INCOMPATIBLE_WITH = " is incompatible with ";
    private static final String MISSING_NAME = "Missing name";
    private static final Object RETURN_VALUE = new Object();
    private final IAcceleoEnvironment environment;
    private final AstValidator validator;
    private Deque<Map<String, Set<IType>>> variableTypesStack = new ArrayDeque<Map<String, Set<IType>>>();
    private boolean forceCollectionBinding;
    private AcceleoValidationResult result;
    private final IType stringType;
    private final IType booleanType;
    private final IType booleanObjectType;
    private final IQualifiedNameLookupEngine lookupEngine;

    public AcceleoValidator(IAcceleoEnvironment environment, IQualifiedNameLookupEngine lookupEngine) {
        this.environment = environment;
        this.lookupEngine = lookupEngine;
        this.stringType = new ClassType((IReadOnlyQueryEnvironment)environment.getQueryEnvironment(), String.class);
        this.booleanType = new ClassType((IReadOnlyQueryEnvironment)environment.getQueryEnvironment(), Boolean.TYPE);
        this.booleanObjectType = new ClassType((IReadOnlyQueryEnvironment)environment.getQueryEnvironment(), Boolean.class);
        this.validator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)environment.getQueryEnvironment()));
    }

    protected void pushVariableTypes(Map<String, Set<IType>> variableTypes) {
        this.variableTypesStack.addLast(variableTypes);
    }

    protected Map<String, Set<IType>> peekVariableTypes() {
        return this.variableTypesStack.peekLast();
    }

    protected Map<String, Set<IType>> popVariableTypes() {
        return this.variableTypesStack.removeLast();
    }

    public IAcceleoValidationResult validate(AcceleoAstResult astResult, String moduleQualifiedName) {
        this.variableTypesStack = new ArrayDeque<Map<String, Set<IType>>>();
        this.pushVariableTypes(new HashMap<String, Set<IType>>());
        this.forceCollectionBinding = false;
        this.result = new AcceleoValidationResult(astResult);
        this.lookupEngine.pushImportsContext(moduleQualifiedName, moduleQualifiedName);
        try {
            this.doSwitch(astResult.getModule());
        }
        finally {
            this.lookupEngine.popContext(moduleQualifiedName);
        }
        return this.result;
    }

    protected void addMessage(ASTNode node, ValidationMessageLevel level, String messageString, int startPosition, int endPosition) {
        ValidationMessage message = new ValidationMessage(level, messageString, startPosition, endPosition);
        this.result.addMessage(node, (IValidationMessage)message);
    }

    @Override
    public Object caseModule(Module module) {
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        for (Metamodel metamodel : module.getMetamodels()) {
            this.doSwitch(metamodel);
            if (metamodel.getReferencedPackage() == null || ePackages.add(metamodel.getReferencedPackage())) continue;
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(module, ValidationMessageLevel.WARNING, String.valueOf(metamodel.getReferencedPackage().getNsURI()) + " already referenced", acceleoAstResult.getStartPosition(metamodel), acceleoAstResult.getEndPosition(metamodel));
        }
        if (module.getExtends() != null) {
            this.doSwitch(module.getExtends());
        }
        HashSet<String> imports = new HashSet<String>();
        for (Import imp : module.getImports()) {
            this.doSwitch(imp);
            if (imp.getModule().getQualifiedName() == null) continue;
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            if (imports.add(imp.getModule().getQualifiedName())) continue;
            this.addMessage(module, ValidationMessageLevel.WARNING, String.valueOf(imp.getModule().getQualifiedName()) + " already imported", acceleoAstResult.getStartPosition(imp), acceleoAstResult.getEndPosition(imp));
        }
        for (ModuleElement element : module.getModuleElements()) {
            this.doSwitch(element);
        }
        return RETURN_VALUE;
    }

    @Override
    public Object caseModuleElementDocumentation(ModuleElementDocumentation moduleElementDocumentation) {
        return RETURN_VALUE;
    }

    @Override
    public Object caseComment(Comment comment) {
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorComment(ErrorComment errorComment) {
        if (errorComment.getMissingEndHeader() != -1) {
            String message = errorComment instanceof ErrorBlockComment ? this.getMissingTokenMessage("[/comment]") : this.getMissingTokenMessage("/]");
            this.addMessage(errorComment, ValidationMessageLevel.ERROR, message, errorComment.getMissingEndHeader(), errorComment.getMissingEndHeader());
        }
        return null;
    }

    @Override
    public Object caseErrorModule(ErrorModule errorModule) {
        if (errorModule.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorModule, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorModule.getMissingOpenParenthesis(), errorModule.getMissingOpenParenthesis());
        } else if (errorModule.getMissingEPackage() != -1) {
            this.addMessage(errorModule, ValidationMessageLevel.ERROR, "Missing metamodel", errorModule.getMissingEPackage(), errorModule.getMissingEPackage());
        } else if (errorModule.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorModule, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorModule.getMissingCloseParenthesis(), errorModule.getMissingCloseParenthesis());
        } else if (errorModule.getMissingEndHeader() != -1) {
            this.addMessage(errorModule, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("/]"), errorModule.getMissingEndHeader(), errorModule.getMissingEndHeader());
        }
        return null;
    }

    @Override
    public Object caseMetamodel(Metamodel metamodel) {
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorMetamodel(ErrorMetamodel errorMetamodel) {
        if (errorMetamodel.getFragment() != null) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(errorMetamodel, ValidationMessageLevel.ERROR, "Invalid metamodel " + errorMetamodel.getFragment(), acceleoAstResult.getStartPosition(errorMetamodel), acceleoAstResult.getEndPosition(errorMetamodel));
        } else if (errorMetamodel.getMissingEndQuote() != -1) {
            this.addMessage(errorMetamodel, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("'"), errorMetamodel.getMissingEndQuote(), errorMetamodel.getMissingEndQuote());
        }
        return null;
    }

    @Override
    public Object caseImport(Import imp) {
        this.doSwitch(imp.getModule());
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorImport(ErrorImport errorImport) {
        this.doSwitch(errorImport.getModule());
        if (errorImport.getMissingEnd() != -1) {
            this.addMessage(errorImport, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("/]"), errorImport.getMissingEnd(), errorImport.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseModuleReference(ModuleReference moduleReference) {
        if (moduleReference.getQualifiedName() != null && this.lookupEngine.getResolver().getURL(moduleReference.getQualifiedName()) == null) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(moduleReference, ValidationMessageLevel.ERROR, "Could not resolve " + moduleReference.getQualifiedName(), acceleoAstResult.getStartPosition(moduleReference), acceleoAstResult.getEndPosition(moduleReference));
        }
        return RETURN_VALUE;
    }

    @Override
    public Object caseBlock(Block block) {
        for (Statement statement : block.getStatements()) {
            this.doSwitch(statement);
        }
        return RETURN_VALUE;
    }

    @Override
    public Object caseTextStatement(TextStatement object) {
        return RETURN_VALUE;
    }

    @Override
    public Object caseTemplate(Template template) {
        this.pushVariableTypes(new HashMap<String, Set<IType>>(this.peekVariableTypes()));
        try {
            HashSet<String> parameterNames = new HashSet<String>();
            for (Variable parameter : template.getParameters()) {
                this.doSwitch(parameter);
                if (parameter.getName() == null || parameterNames.add(parameter.getName())) continue;
                AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
                this.addMessage(template, ValidationMessageLevel.ERROR, String.valueOf(parameter.getName()) + " duplicated parameter", acceleoAstResult.getStartPosition(parameter), acceleoAstResult.getEndPosition(parameter));
            }
            if (template.getGuard() != null) {
                this.doSwitch(template.getGuard());
            }
            if (template.getPost() != null) {
                this.pushVariableTypes(new HashMap<String, Set<IType>>(this.peekVariableTypes()));
                LinkedHashSet<ClassType> possibleTypes = new LinkedHashSet<ClassType>();
                possibleTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.environment.getQueryEnvironment(), String.class));
                this.peekVariableTypes().put(AcceleoUtil.getTemplateImplicitVariableName(), possibleTypes);
                try {
                    this.doSwitch(template.getPost());
                }
                finally {
                    this.popVariableTypes();
                }
            }
            this.doSwitch(template.getBody());
        }
        finally {
            this.popVariableTypes();
        }
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorTemplate(ErrorTemplate errorTemplate) {
        if (errorTemplate.getMissingVisibility() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, "Missing visibility", errorTemplate.getMissingVisibility(), errorTemplate.getMissingVisibility());
        } else if (errorTemplate.getMissingName() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, MISSING_NAME, errorTemplate.getMissingName(), errorTemplate.getMissingName());
        } else if (errorTemplate.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorTemplate.getMissingOpenParenthesis(), errorTemplate.getMissingOpenParenthesis());
        } else if (errorTemplate.getMissingParameters() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, "Missing parameter", errorTemplate.getMissingParameters(), errorTemplate.getMissingParameters());
        } else if (errorTemplate.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorTemplate.getMissingCloseParenthesis(), errorTemplate.getMissingCloseParenthesis());
        } else if (errorTemplate.getMissingGuardOpenParenthesis() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorTemplate.getMissingGuardOpenParenthesis(), errorTemplate.getMissingGuardOpenParenthesis());
        } else if (errorTemplate.getMissingGuardCloseParenthesis() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorTemplate.getMissingGuardCloseParenthesis(), errorTemplate.getMissingGuardCloseParenthesis());
        } else if (errorTemplate.getMissingPostCloseParenthesis() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorTemplate.getMissingPostCloseParenthesis(), errorTemplate.getMissingPostCloseParenthesis());
        } else if (errorTemplate.getMissingEndHeader() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorTemplate.getMissingEndHeader(), errorTemplate.getMissingEndHeader());
        } else if (errorTemplate.getMissingEnd() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/template]"), errorTemplate.getMissingEnd(), errorTemplate.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseQuery(Query query) {
        this.pushVariableTypes(new HashMap<String, Set<IType>>(this.peekVariableTypes()));
        try {
            HashSet<String> parameterNames = new HashSet<String>();
            for (Variable parameter : query.getParameters()) {
                this.doSwitch(parameter);
                if (parameter.getName() == null || parameterNames.add(parameter.getName())) continue;
                AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
                this.addMessage(query, ValidationMessageLevel.ERROR, String.valueOf(parameter.getName()) + " duplicated parameter", acceleoAstResult.getStartPosition(parameter), acceleoAstResult.getEndPosition(parameter));
            }
            IValidationResult validationResult = (IValidationResult)this.doSwitch(query.getBody());
            Set possibleTypes = validationResult.getPossibleTypes(validationResult.getAstResult().getAst());
            if (query.getType() != null) {
                IValidationResult typeValidationResult = this.validator.validate(Collections.emptyMap(), query.getType());
                this.result.getAqlValidationResults().put(query.getType(), typeValidationResult);
                Set iTypes = this.validator.getDeclarationTypes((IReadOnlyQueryEnvironment)this.environment.getQueryEnvironment(), typeValidationResult.getPossibleTypes(query.getType().getAst()));
                this.checkTypesCompatibility(query, possibleTypes, iTypes);
            }
        }
        finally {
            this.popVariableTypes();
        }
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorQuery(ErrorQuery errorQuery) {
        if (errorQuery.getMissingVisibility() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, "Missing visibility", errorQuery.getMissingVisibility(), errorQuery.getMissingVisibility());
        } else if (errorQuery.getMissingName() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, MISSING_NAME, errorQuery.getMissingName(), errorQuery.getMissingName());
        } else if (errorQuery.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorQuery.getMissingOpenParenthesis(), errorQuery.getMissingOpenParenthesis());
        } else if (errorQuery.getMissingParameters() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, "Missing parameter", errorQuery.getMissingParameters(), errorQuery.getMissingParameters());
        } else if (errorQuery.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorQuery.getMissingCloseParenthesis(), errorQuery.getMissingCloseParenthesis());
        } else if (errorQuery.getMissingColon() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(":"), errorQuery.getMissingColon(), errorQuery.getMissingColon());
        } else if (errorQuery.getMissingType() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, "Missing or invalid type", errorQuery.getMissingType(), errorQuery.getMissingType());
        } else if (errorQuery.getMissingEqual() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("="), errorQuery.getMissingEqual(), errorQuery.getMissingEqual());
        } else if (errorQuery.getMissingEnd() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("/]"), errorQuery.getMissingEnd(), errorQuery.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseVariable(Variable variable) {
        if (this.peekVariableTypes().containsKey(variable.getName())) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(variable, ValidationMessageLevel.WARNING, "Variable " + variable.getName() + " already exists.", acceleoAstResult.getStartPosition(variable), acceleoAstResult.getEndPosition(variable));
        }
        IValidationResult typeValidationResult = this.validator.validate(Collections.emptyMap(), variable.getType());
        this.result.getAqlValidationResults().put(variable.getType(), typeValidationResult);
        Set types = this.validator.getDeclarationTypes((IReadOnlyQueryEnvironment)this.environment.getQueryEnvironment(), typeValidationResult.getPossibleTypes(variable.getType().getAst()));
        this.peekVariableTypes().put(variable.getName(), types);
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorVariable(ErrorVariable errorVariable) {
        if (errorVariable.getMissingName() != -1) {
            this.addMessage(errorVariable, ValidationMessageLevel.ERROR, MISSING_NAME, errorVariable.getMissingName(), errorVariable.getMissingName());
        } else if (errorVariable.getMissingColon() != -1) {
            this.addMessage(errorVariable, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(":"), errorVariable.getMissingColon(), errorVariable.getMissingColon());
        } else if (errorVariable.getMissingType() != -1) {
            this.addMessage(errorVariable, ValidationMessageLevel.ERROR, "Missing or invalid type", errorVariable.getMissingType(), errorVariable.getMissingType());
        }
        return null;
    }

    @Override
    public Object caseBinding(Binding binding) {
        if (this.peekVariableTypes().containsKey(binding.getName())) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(binding, ValidationMessageLevel.WARNING, "Variable " + binding.getName() + " already exists.", acceleoAstResult.getStartPosition(binding), acceleoAstResult.getEndPosition(binding));
        }
        IValidationResult validationResult = (IValidationResult)this.doSwitch(binding.getInitExpression());
        Set possibleTypes = validationResult.getPossibleTypes(validationResult.getAstResult().getAst());
        if (binding.getType() != null) {
            IValidationResult typeValidationResult = this.validator.validate(Collections.emptyMap(), binding.getType());
            this.result.getAqlValidationResults().put(binding.getType(), typeValidationResult);
            Set iTypes = this.validator.getDeclarationTypes((IReadOnlyQueryEnvironment)this.environment.getQueryEnvironment(), typeValidationResult.getPossibleTypes(binding.getType().getAst()));
            this.checkTypesCompatibility(binding, possibleTypes, iTypes);
        }
        LinkedHashSet<IType> variableTypes = new LinkedHashSet<IType>();
        if (this.forceCollectionBinding) {
            for (IType possibleType : possibleTypes) {
                if (possibleType instanceof ICollectionType) {
                    variableTypes.add(((ICollectionType)possibleType).getCollectionType());
                    continue;
                }
                variableTypes.add(possibleType);
            }
        } else {
            variableTypes.addAll(possibleTypes);
        }
        this.peekVariableTypes().put(binding.getName(), variableTypes);
        return RETURN_VALUE;
    }

    protected void checkTypesCompatibility(ASTNode binding, Set<IType> possibleTypes, Set<IType> declaredTypes) {
        for (IType possibleType : possibleTypes) {
            ArrayList<IValidationMessage> messages = new ArrayList<IValidationMessage>();
            boolean hasCompatibleType = false;
            for (IType iType : declaredTypes) {
                if (!iType.isAssignableFrom(possibleType)) {
                    if (this.forceCollectionBinding) {
                        messages.addAll(this.validateBindingTypeForceCollection(binding, iType, possibleType));
                        continue;
                    }
                    AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
                    messages.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.WARNING, iType + IS_INCOMPATIBLE_WITH + possibleType, acceleoAstResult.getStartPosition(binding), acceleoAstResult.getEndPosition(binding)));
                    continue;
                }
                hasCompatibleType = true;
            }
            if (hasCompatibleType) continue;
            this.result.addMessages(binding, messages);
        }
    }

    protected List<IValidationMessage> validateBindingTypeForceCollection(ASTNode node, IType iType, IType possibleType) {
        ArrayList<IValidationMessage> res = new ArrayList<IValidationMessage>();
        if (possibleType instanceof ICollectionType) {
            if (!iType.isAssignableFrom(((ICollectionType)possibleType).getCollectionType())) {
                AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
                res.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.WARNING, iType + IS_INCOMPATIBLE_WITH + possibleType, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node)));
            }
        } else if (!iType.isAssignableFrom(possibleType)) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            res.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.WARNING, iType + IS_INCOMPATIBLE_WITH + possibleType, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node)));
        }
        return res;
    }

    @Override
    public Object caseErrorBinding(ErrorBinding errorBinding) {
        if (errorBinding.getMissingName() != -1) {
            this.addMessage(errorBinding, ValidationMessageLevel.ERROR, MISSING_NAME, errorBinding.getMissingName(), errorBinding.getMissingName());
        } else if (errorBinding.getMissingColon() != -1) {
            this.addMessage(errorBinding, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(":"), errorBinding.getMissingColon(), errorBinding.getMissingColon());
        } else if (errorBinding.getMissingType() != -1) {
            this.addMessage(errorBinding, ValidationMessageLevel.ERROR, "Missing type literal", errorBinding.getMissingType(), errorBinding.getMissingType());
        } else if (errorBinding.getMissingAffectationSymbolePosition() != -1) {
            this.addMessage(errorBinding, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(errorBinding.getMissingAffectationSymbole()), errorBinding.getMissingAffectationSymbolePosition(), errorBinding.getMissingAffectationSymbolePosition());
        }
        return null;
    }

    @Override
    public Object caseExpressionStatement(ExpressionStatement expressionStatement) {
        this.doSwitch(expressionStatement.getExpression());
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorExpressionStatement(ErrorExpressionStatement errorExpressionStatement) {
        this.doSwitch(errorExpressionStatement.getExpression());
        if (errorExpressionStatement.getMissingEndHeader() != -1) {
            this.addMessage(errorExpressionStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("/]"), errorExpressionStatement.getMissingEndHeader(), errorExpressionStatement.getMissingEndHeader());
        }
        return null;
    }

    @Override
    public Object caseProtectedArea(ProtectedArea protectedArea) {
        this.doSwitch(protectedArea.getId());
        this.doSwitch(protectedArea.getBody());
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorProtectedArea(ErrorProtectedArea errorProtectedArea) {
        if (errorProtectedArea.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorProtectedArea, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorProtectedArea.getMissingOpenParenthesis(), errorProtectedArea.getMissingOpenParenthesis());
        } else if (errorProtectedArea.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorProtectedArea, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorProtectedArea.getMissingCloseParenthesis(), errorProtectedArea.getMissingCloseParenthesis());
        } else if (errorProtectedArea.getMissingEndHeader() != -1) {
            this.addMessage(errorProtectedArea, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorProtectedArea.getMissingEndHeader(), errorProtectedArea.getMissingEndHeader());
        } else if (errorProtectedArea.getMissingEnd() != -1) {
            this.addMessage(errorProtectedArea, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/protected]"), errorProtectedArea.getMissingEnd(), errorProtectedArea.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseExpression(Expression expression) {
        IValidationResult res = this.validator.validate(this.peekVariableTypes(), expression.getAst());
        this.result.getAqlValidationResults().put(expression.getAst(), res);
        AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
        this.result.addMessages(expression, this.shiftMessages(res.getMessages(), acceleoAstResult.getStartPosition(expression)));
        return res;
    }

    @Override
    public Object caseForStatement(ForStatement forStatement) {
        this.pushVariableTypes(new HashMap<String, Set<IType>>(this.peekVariableTypes()));
        try {
            if (forStatement.getBinding() != null) {
                this.forceCollectionBinding = true;
                try {
                    this.doSwitch(forStatement.getBinding());
                }
                finally {
                    this.forceCollectionBinding = false;
                }
            }
            if (forStatement.getSeparator() != null) {
                this.doSwitch(forStatement.getSeparator());
            }
            this.doSwitch(forStatement.getBody());
        }
        finally {
            this.popVariableTypes();
        }
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorForStatement(ErrorForStatement errorForStatement) {
        if (errorForStatement.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorForStatement.getMissingOpenParenthesis(), errorForStatement.getMissingOpenParenthesis());
        } else if (errorForStatement.getMissingBinding() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, "Missing binding", errorForStatement.getMissingBinding(), errorForStatement.getMissingBinding());
        } else if (errorForStatement.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorForStatement.getMissingCloseParenthesis(), errorForStatement.getMissingCloseParenthesis());
        } else if (errorForStatement.getMissingSeparatorCloseParenthesis() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorForStatement.getMissingSeparatorCloseParenthesis(), errorForStatement.getMissingSeparatorCloseParenthesis());
        } else if (errorForStatement.getMissingEndHeader() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorForStatement.getMissingEndHeader(), errorForStatement.getMissingEndHeader());
        } else if (errorForStatement.getMissingEnd() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/for]"), errorForStatement.getMissingEnd(), errorForStatement.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseIfStatement(IfStatement ifStatement) {
        IValidationResult conditionValidationResult = (IValidationResult)this.doSwitch(ifStatement.getCondition());
        Set conditionPossibleTypes = conditionValidationResult.getPossibleTypes(ifStatement.getCondition().getAst().getAst());
        this.checkBooleanType(ifStatement.getCondition(), conditionPossibleTypes);
        HashMap<String, Set<IType>> thenTypes = new HashMap<String, Set<IType>>(this.peekVariableTypes());
        thenTypes.putAll(conditionValidationResult.getInferredVariableTypes(ifStatement.getCondition().getAst().getAst(), Boolean.TRUE));
        this.pushVariableTypes(thenTypes);
        try {
            this.doSwitch(ifStatement.getThen());
        }
        finally {
            this.popVariableTypes();
        }
        if (ifStatement.getElse() != null) {
            HashMap<String, Set<IType>> elseTypes = new HashMap<String, Set<IType>>(this.peekVariableTypes());
            elseTypes.putAll(conditionValidationResult.getInferredVariableTypes(ifStatement.getCondition().getAst().getAst(), Boolean.FALSE));
            this.pushVariableTypes(elseTypes);
            try {
                this.doSwitch(ifStatement.getElse());
            }
            finally {
                this.popVariableTypes();
            }
        }
        return RETURN_VALUE;
    }

    private void checkBooleanType(ASTNode node, Set<IType> possibleTypes) {
        if (!possibleTypes.isEmpty()) {
            boolean onlyBoolean = true;
            boolean onlyNotBoolean = true;
            for (IType type : possibleTypes) {
                boolean assignableFrom = this.booleanObjectType.isAssignableFrom(type) || this.booleanType.isAssignableFrom(type);
                onlyBoolean = onlyBoolean && assignableFrom;
                boolean bl = onlyNotBoolean = onlyNotBoolean && !assignableFrom;
                if (!onlyBoolean && !onlyNotBoolean) break;
            }
            if (!onlyBoolean) {
                AcceleoAstResult acceleoAstResult;
                String message;
                if (onlyNotBoolean) {
                    message = String.format("The predicate never evaluates to a boolean type (%s).", possibleTypes);
                    acceleoAstResult = this.result.getAcceleoAstResult();
                    this.addMessage(node, ValidationMessageLevel.ERROR, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
                } else {
                    message = String.format("The predicate may evaluate to a value that is not a boolean type (%s).", possibleTypes);
                    acceleoAstResult = this.result.getAcceleoAstResult();
                    this.addMessage(node, ValidationMessageLevel.WARNING, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
                }
            }
        } else {
            String message = String.format("The predicate never evaluates to a boolean type (%s).", possibleTypes);
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(node, ValidationMessageLevel.ERROR, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
        }
    }

    @Override
    public Object caseErrorIfStatement(ErrorIfStatement errorIfStatement) {
        if (errorIfStatement.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorIfStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorIfStatement.getMissingOpenParenthesis(), errorIfStatement.getMissingOpenParenthesis());
        } else if (errorIfStatement.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorIfStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorIfStatement.getMissingCloseParenthesis(), errorIfStatement.getMissingCloseParenthesis());
        } else if (errorIfStatement.getMissingEndHeader() != -1) {
            this.addMessage(errorIfStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorIfStatement.getMissingEndHeader(), errorIfStatement.getMissingEndHeader());
        } else if (errorIfStatement.getMissingEnd() != -1) {
            this.addMessage(errorIfStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/if]"), errorIfStatement.getMissingEnd(), errorIfStatement.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseLetStatement(LetStatement letStatement) {
        this.pushVariableTypes(new HashMap<String, Set<IType>>(this.peekVariableTypes()));
        try {
            for (Binding binding : letStatement.getVariables()) {
                this.doSwitch(binding);
            }
            this.doSwitch(letStatement.getBody());
        }
        finally {
            this.popVariableTypes();
        }
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorLetStatement(ErrorLetStatement errorLetStatement) {
        if (errorLetStatement.getMissingBindings() != -1) {
            this.addMessage(errorLetStatement, ValidationMessageLevel.WARNING, "Missing binding", errorLetStatement.getMissingBindings(), errorLetStatement.getMissingBindings());
        } else if (errorLetStatement.getMissingEndHeader() != -1) {
            this.addMessage(errorLetStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorLetStatement.getMissingEndHeader(), errorLetStatement.getMissingEndHeader());
        } else if (errorLetStatement.getMissingEnd() != -1) {
            this.addMessage(errorLetStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/let]"), errorLetStatement.getMissingEnd(), errorLetStatement.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseFileStatement(FileStatement fileStatement) {
        IValidationResult urlValidationResult = (IValidationResult)this.doSwitch(fileStatement.getUrl());
        Set urlpossibleTypes = urlValidationResult.getPossibleTypes(urlValidationResult.getAstResult().getAst());
        this.checkStringType(fileStatement.getUrl(), urlpossibleTypes);
        if (fileStatement.getCharset() != null) {
            IValidationResult charsetValidationResult = (IValidationResult)this.doSwitch(fileStatement.getCharset());
            Set charsetpossibleTypes = charsetValidationResult.getPossibleTypes(charsetValidationResult.getAstResult().getAst());
            this.checkStringType(fileStatement.getCharset(), charsetpossibleTypes);
        }
        this.doSwitch(fileStatement.getBody());
        return RETURN_VALUE;
    }

    private void checkStringType(ASTNode node, Set<IType> possibleTypes) {
        if (!possibleTypes.isEmpty()) {
            boolean onlyString = true;
            boolean onlyNotString = true;
            for (IType type : possibleTypes) {
                boolean assignableFrom = this.stringType.isAssignableFrom(type);
                onlyString = onlyString && assignableFrom;
                boolean bl = onlyNotString = onlyNotString && !assignableFrom;
                if (!onlyString && !onlyNotString) break;
            }
            if (!onlyString) {
                AcceleoAstResult acceleoAstResult;
                String message;
                if (onlyNotString) {
                    message = String.format("The expression never evaluates to a String type (%s).", possibleTypes);
                    acceleoAstResult = this.result.getAcceleoAstResult();
                    this.addMessage(node, ValidationMessageLevel.WARNING, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
                } else {
                    message = String.format("The expression may evaluate to a value that is not a String type (%s).\"", possibleTypes);
                    acceleoAstResult = this.result.getAcceleoAstResult();
                    this.addMessage(node, ValidationMessageLevel.WARNING, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
                }
            }
        } else {
            String message = String.format("The expression never evaluates to a String type (%s).", possibleTypes);
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(node, ValidationMessageLevel.ERROR, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
        }
    }

    @Override
    public Object caseErrorFileStatement(ErrorFileStatement errorFileStatement) {
        if (errorFileStatement.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorFileStatement.getMissingOpenParenthesis(), errorFileStatement.getMissingOpenParenthesis());
        } else if (errorFileStatement.getMissingComma() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(","), errorFileStatement.getMissingComma(), errorFileStatement.getMissingComma());
        } else if (errorFileStatement.getMissingOpenMode() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, "Missing or invalid file open mode: overwrite, append, create", errorFileStatement.getMissingOpenMode(), errorFileStatement.getMissingOpenMode());
        } else if (errorFileStatement.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorFileStatement.getMissingCloseParenthesis(), errorFileStatement.getMissingCloseParenthesis());
        } else if (errorFileStatement.getMissingEndHeader() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorFileStatement.getMissingEndHeader(), errorFileStatement.getMissingEndHeader());
        } else if (errorFileStatement.getMissingEnd() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/file]"), errorFileStatement.getMissingEnd(), errorFileStatement.getMissingEnd());
        }
        return null;
    }

    private List<IValidationMessage> shiftMessages(List<IValidationMessage> messages, int offset) {
        ArrayList<IValidationMessage> res = new ArrayList<IValidationMessage>(messages.size());
        for (IValidationMessage message : messages) {
            int newStartPosition = message.getStartPosition() + offset;
            int newEndPosition = message.getEndPosition() + offset;
            res.add((IValidationMessage)new ValidationMessage(message.getLevel(), message.getMessage(), newStartPosition, newEndPosition));
        }
        return res;
    }

    protected String getMissingTokenMessage(String token) {
        return "Missing \"" + token + "\"";
    }
}

