/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.acceleo.aql.AcceleoEnvironment;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.writer.DefaultGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoProject;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoWorkspace;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.impl.namespace.QualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;

public class EclipseWorkspace2AcceleoWorkspace {
    private final Map<AcceleoWorkspace, IWorkspace> workspaceTrace = new LinkedHashMap<AcceleoWorkspace, IWorkspace>();
    private final Map<AcceleoWorkspace, SynchronizerEclipseWorkspace2AcceleoWorkspace> synchronizerTrace = new LinkedHashMap<AcceleoWorkspace, SynchronizerEclipseWorkspace2AcceleoWorkspace>();

    public AcceleoWorkspace createAcceleoWorkspace(IWorkspace clientWorkspace) {
        AcceleoWorkspace createdAcceleoWorkspace = new AcceleoWorkspace(EclipseWorkspace2AcceleoWorkspace.getAcceleoWorkspaceName(clientWorkspace));
        this.workspaceTrace.put(createdAcceleoWorkspace, clientWorkspace);
        SynchronizerEclipseWorkspace2AcceleoWorkspace synchronizer = new SynchronizerEclipseWorkspace2AcceleoWorkspace(createdAcceleoWorkspace);
        this.synchronizerTrace.put(createdAcceleoWorkspace, synchronizer);
        try {
            clientWorkspace.getRoot().accept((IResourceVisitor)synchronizer);
            clientWorkspace.addResourceChangeListener((IResourceChangeListener)synchronizer);
            return createdAcceleoWorkspace;
        }
        catch (CoreException coreException) {
            this.workspaceTrace.remove(createdAcceleoWorkspace);
            this.synchronizerTrace.remove(createdAcceleoWorkspace);
            throw new RuntimeException("There was an issue while trying to visit the workspace.", coreException);
        }
    }

    private static String getAcceleoWorkspaceName(IWorkspace clientWorkspace) {
        return "AcceleoWorkspace[" + clientWorkspace.getRoot().getLocationURI().toString() + "]";
    }

    public void deleteAcceleoWorkspace(AcceleoWorkspace acceleoWorkspaceToDelete) {
        if (this.workspaceTrace.containsKey(acceleoWorkspaceToDelete)) {
            IWorkspace clientWorkspace = this.workspaceTrace.get(acceleoWorkspaceToDelete);
            SynchronizerEclipseWorkspace2AcceleoWorkspace synchronizer = this.synchronizerTrace.get(acceleoWorkspaceToDelete);
            clientWorkspace.removeResourceChangeListener((IResourceChangeListener)synchronizer);
        }
    }

    private static class SynchronizerEclipseWorkspace2AcceleoWorkspace
    implements IResourceVisitor,
    IResourceChangeListener,
    IResourceDeltaVisitor {
        private static final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
        private static final int BUFFER_SIZE = 1024;
        private final AcceleoWorkspace acceleoWorkspace;
        private final Map<IProject, AcceleoProject> projectsTrace = new LinkedHashMap<IProject, AcceleoProject>();
        private final Map<IFile, AcceleoTextDocument> filesTrace = new LinkedHashMap<IFile, AcceleoTextDocument>();

        SynchronizerEclipseWorkspace2AcceleoWorkspace(AcceleoWorkspace acceleoWorkspaceToFill) {
            this.acceleoWorkspace = acceleoWorkspaceToFill;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IWorkspaceRoot || resource.getProject().isOpen() && resource.getProject().hasNature(JAVA_NATURE)) {
                this.synchronize(resource);
                return true;
            }
            return false;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() != 1) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException coreException) {
                throw new RuntimeException("There was an issue while updating " + this.acceleoWorkspace.toString() + " to react to changes in the client workspace.", coreException);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getFlags() != 131072) {
                IResource resource = delta.getResource();
                if (resource.getType() == 4) {
                    IProject workspaceProject = (IProject)resource;
                    this.visitProjectDelta(delta, workspaceProject);
                } else if (resource.getType() == 1) {
                    IFile workspaceFile = (IFile)resource;
                    this.visitFileDelta(delta, workspaceFile);
                }
            }
            return true;
        }

        private void visitFileDelta(IResourceDelta delta, IFile workspaceFile) {
            if (delta.getKind() == 4) {
                if ((delta.getFlags() & 0x100) != 0) {
                    this.updateFileContents(workspaceFile);
                }
                if ((delta.getFlags() & 0x100000) != 0) {
                    this.updateFileContents(workspaceFile);
                }
                if ((delta.getFlags() & 0x1000) != 0) {
                    this.refresh((IResource)workspaceFile);
                }
                delta.getFlags();
                if ((delta.getFlags() & 0x40000) != 0) {
                    this.refresh((IResource)workspaceFile);
                }
            } else if (delta.getKind() == 1) {
                this.synchronize(workspaceFile);
            } else if (delta.getKind() == 2) {
                this.remove(workspaceFile);
            }
        }

        private void visitProjectDelta(IResourceDelta delta, IProject workspaceProject) {
            if (delta.getKind() == 4) {
                if ((delta.getFlags() & 0x100000) != 0) {
                    this.refresh((IResource)workspaceProject);
                }
                if ((delta.getFlags() & 0x1000) != 0) {
                    this.refresh((IResource)workspaceProject);
                }
                delta.getFlags();
                if ((delta.getFlags() & 0x40000) != 0) {
                    this.refresh((IResource)workspaceProject);
                }
            } else if (delta.getKind() == 1) {
                this.synchronize(workspaceProject);
            } else if (delta.getKind() == 2) {
                this.remove(workspaceProject);
            }
        }

        private void refresh(IResource workspaceResource) {
            this.remove(workspaceResource);
            this.synchronize(workspaceResource);
        }

        private void remove(IResource workspaceResource) {
            Objects.requireNonNull(workspaceResource);
            if (workspaceResource.getType() == 4) {
                IProject workspaceProject = (IProject)workspaceResource;
                this.remove(workspaceProject);
            } else if (workspaceResource.getType() == 1) {
                IFile workspaceFile = (IFile)workspaceResource;
                this.remove(workspaceFile);
            }
        }

        private void remove(IProject removedProject) {
            if (this.projectsTrace.containsKey(removedProject)) {
                AcceleoProject projectToRemove = this.projectsTrace.get(removedProject);
                this.acceleoWorkspace.removeProject(projectToRemove);
                this.projectsTrace.remove(removedProject);
            }
        }

        private void remove(IFile removedFile) {
            if (this.filesTrace.containsKey(removedFile)) {
                AcceleoTextDocument fileToRemove = this.filesTrace.get(removedFile);
                fileToRemove.getProject().removeTextDocument(fileToRemove);
                this.filesTrace.remove(removedFile);
            }
        }

        private void synchronize(IResource workspaceResource) {
            Objects.requireNonNull(workspaceResource);
            if (workspaceResource.getType() == 4) {
                IProject workspaceProject = (IProject)workspaceResource;
                this.synchronize(workspaceProject);
            } else if (workspaceResource.getType() == 1) {
                IFile workspaceFile = (IFile)workspaceResource;
                this.synchronize(workspaceFile);
            }
        }

        private void synchronize(IProject workspaceProject) {
            if (!this.projectsTrace.containsKey(workspaceProject)) {
                this.createAcceleoProject(workspaceProject);
            } else {
                this.updateAcceleoProject(workspaceProject);
            }
        }

        private void createAcceleoProject(IProject workspaceProject) {
            AcceleoProject acceleoProject = this.transform(workspaceProject);
            this.projectsTrace.put(workspaceProject, acceleoProject);
            this.acceleoWorkspace.addProject(acceleoProject);
        }

        private void updateAcceleoProject(IProject workspaceProject) {
            AcceleoProject acceleoProject = this.projectsTrace.get(workspaceProject);
            acceleoProject.setLabel(this.getAcceleoProjectLabelFor(workspaceProject));
            acceleoProject.setAcceleoEnvironment(this.createAcceleoEnvironmentFor((IResource)workspaceProject));
        }

        private void synchronize(IFile workspaceFile) {
            if (!this.filesTrace.containsKey(workspaceFile)) {
                if (!this.projectsTrace.containsKey(workspaceFile.getProject())) {
                    throw new IllegalStateException("Did not expect to synchronize a file from the workspace before its containing project.");
                }
                if (SynchronizerEclipseWorkspace2AcceleoWorkspace.workspaceFileIsAcceleoTextDocument(workspaceFile)) {
                    this.createAcceleoTextDocument(workspaceFile);
                }
            } else {
                this.updateFileContents(workspaceFile);
            }
        }

        private static boolean workspaceFileIsAcceleoTextDocument(IFile workspaceFile) {
            String fileExtension = workspaceFile.getFileExtension();
            return !workspaceFile.isDerived() && fileExtension != null && fileExtension.equals("mtl");
        }

        private void createAcceleoTextDocument(IFile workspaceFile) {
            AcceleoTextDocument acceleoTextDocument = this.transform(workspaceFile);
            this.filesTrace.put(workspaceFile, acceleoTextDocument);
            AcceleoProject containerAcceleoProject = this.projectsTrace.get(workspaceFile.getProject());
            containerAcceleoProject.addTextDocument(acceleoTextDocument);
        }

        private void updateFileContents(IFile workspaceFile) {
            AcceleoTextDocument acceleoTextDocument = this.filesTrace.get(workspaceFile);
            if (acceleoTextDocument != null) {
                if (!SynchronizerEclipseWorkspace2AcceleoWorkspace.workspaceFileIsAcceleoTextDocument(workspaceFile)) {
                    acceleoTextDocument.getProject().removeTextDocument(acceleoTextDocument);
                    this.filesTrace.remove(workspaceFile);
                } else {
                    String workspaceFileContents = SynchronizerEclipseWorkspace2AcceleoWorkspace.readWorkspaceFile(workspaceFile);
                    acceleoTextDocument.setContents(workspaceFileContents);
                }
            }
        }

        private String getAcceleoProjectLabelFor(IProject workspaceProject) {
            return "AcceleoProject\"" + workspaceProject.getName() + "\"[" + workspaceProject.getLocationURI() + "]";
        }

        private AcceleoProject transform(IProject workspaceProject) {
            return new AcceleoProject(this.getAcceleoProjectLabelFor(workspaceProject), this.createAcceleoEnvironmentFor((IResource)workspaceProject));
        }

        public IAcceleoEnvironment createAcceleoEnvironmentFor(IResource workspaceResource) {
            IProject project = workspaceResource.getProject();
            IQualifiedNameResolver resolver = QueryPlugin.getPlugin().createQualifiedNameResolver(AcceleoPlugin.getPlugin().getClass().getClassLoader(), project, "::");
            QualifiedNameQueryEnvironment queryEnvironment = new QualifiedNameQueryEnvironment(resolver);
            URI target = URI.createURI((String)workspaceResource.getWorkspace().getRoot().getLocationURI().toString());
            AcceleoEnvironment acceleoEnvironment = new AcceleoEnvironment(resolver, (IQualifiedNameQueryEnvironment)queryEnvironment, (IAcceleoGenerationStrategy)new DefaultGenerationStrategy(), target);
            AcceleoEvaluator evaluator = new AcceleoEvaluator((IAcceleoEnvironment)acceleoEnvironment, queryEnvironment.getLookupEngine());
            resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser((IReadOnlyQueryEnvironment)queryEnvironment), evaluator));
            resolver.addLoader((ILoader)new JavaLoader("::"));
            return acceleoEnvironment;
        }

        private AcceleoTextDocument transform(IFile workspaceFile) {
            java.net.URI textDocumentUri = workspaceFile.getLocationURI();
            String textDocumentContents = SynchronizerEclipseWorkspace2AcceleoWorkspace.readWorkspaceFile(workspaceFile);
            AcceleoProject containerAcceleoProject = this.projectsTrace.get(workspaceFile.getProject());
            return new AcceleoTextDocument(textDocumentUri, textDocumentContents, containerAcceleoProject);
        }

        private static String readWorkspaceFile(IFile workspaceFileToRead) {
            try {
                int length;
                InputStream inputStream = workspaceFileToRead.getContents();
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                inputStream.close();
                return result.toString(workspaceFileToRead.getCharset());
            }
            catch (IOException | CoreException exception) {
                throw new RuntimeException("There was an issue while reading the contents of file " + workspaceFileToRead.getLocation().toString(), exception);
            }
        }
    }
}

