/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.debug.ide.ui.launch;

import java.util.ArrayList;
import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.acceleo.aql.ls.debug.ide.AcceleoDebugPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

public class AcceleoLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        this.launch(this.getLaunchableResource(selection), mode);
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(this.getLaunchableResource(editor), mode);
    }

    private void launch(IResource resource, String mode) {
        ILaunchConfiguration[] configurations = this.getLaunchConfigurations(resource);
        if (configurations != null) {
            ILaunchConfiguration[] iLaunchConfigurationArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                try {
                    config.launch(mode, (IProgressMonitor)new NullProgressMonitor());
                    return;
                }
                catch (CoreException e) {
                    AcceleoDebugPlugin.getPlugin().log((Object)new Status(4, "org.eclipse.acceleo.aql.ls.debug.ide", "couldn't launch module " + resource.getFullPath(), (Throwable)e));
                    ++n2;
                }
            }
            this.createConfiguration(resource, mode);
        }
    }

    protected void createConfiguration(IResource resource, String mode) {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.acceleo.aql.ls.debug.ide.launchConfigurationType");
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, launchManager.generateLaunchConfigurationName(resource.getName()));
            wc.setAttribute("module", resource.getFullPath().toString());
            wc.setMappedResources(new IResource[]{resource});
            ILaunchConfiguration config = wc.doSave();
            StructuredSelection selection = config == null ? new StructuredSelection() : new StructuredSelection((Object)config);
            ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)selection, (String)launchGroup.getIdentifier());
        }
        catch (CoreException e) {
            AcceleoDebugPlugin.getPlugin().log((Object)new Status(4, "org.eclipse.acceleo.aql.ls.debug.ide", "couldn't create launch configuration for module " + resource.getFullPath(), (Throwable)e));
        }
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return this.getLaunchConfigurations(this.getLaunchableResource(selection));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return this.getLaunchConfigurations(this.getLaunchableResource(editorpart));
    }

    private ILaunchConfiguration[] getLaunchConfigurations(IResource resource) {
        ILaunchConfiguration[] res;
        if (AcceleoPlugin.isAcceleoMain((IResource)resource)) {
            ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.acceleo.aql.ls.debug.ide.launchConfigurationType");
            try {
                ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(configType);
                String module = resource.getFullPath().toString();
                ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
                int n = launchConfigurations.length;
                int n2 = 0;
                while (n2 < n) {
                    String launchConfigModule;
                    ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
                    if (launchConfig.hasAttribute("module") && module.equals(launchConfigModule = launchConfig.getAttribute("module", null))) {
                        configurations.add(launchConfig);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                AcceleoDebugPlugin.getPlugin().log((Object)new Status(4, "org.eclipse.acceleo.aql.ls.debug.ide", "couldn't get launch configuration for module " + resource.getFullPath(), (Throwable)e));
            }
            res = configurations.toArray(new ILaunchConfiguration[configurations.size()]);
        } else {
            res = null;
        }
        return res;
    }

    public IResource getLaunchableResource(ISelection selection) {
        IResource res = null;
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IFile) {
                    res = (IResource)element;
                    break;
                }
                ++n2;
            }
        }
        return res;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return ResourceUtil.getFile((IEditorInput)editorpart.getEditorInput());
    }
}

