/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.doc.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.query.doc.internal.AQLHelpContentUtils;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.services.BooleanServices;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.acceleo.query.services.ComparableServices;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.acceleo.query.services.NumberServices;
import org.eclipse.acceleo.query.services.ResourceServices;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.services.XPathServices;

public final class DocumentationGenerator {
    private static final String TRIGGER_TO_APPEND_STD_DOC = "<p>These sections are listing all the services of the standard library of AQL.</p>";
    private static final String UTF8 = "UTF-8";
    private static final Class<?>[] STANDARD_SERVICE_PROVIDERS = new Class[]{AnyServices.class, BooleanServices.class, CollectionServices.class, ComparableServices.class, EObjectServices.class, NumberServices.class, ResourceServices.class, StringServices.class, XPathServices.class};

    private DocumentationGenerator() {
    }

    public static void main(String[] args) {
        File pluginFolder = new File(args[0]);
        System.out.println("Prepare the generation of the documentation for " + pluginFolder.getAbsolutePath());
        File inputFolder = new File(pluginFolder, "input");
        File documentationFolder = new File(pluginFolder, "pages");
        File indexHtmlFile = new File(documentationFolder, "index.html");
        StringBuffer buffer = AQLHelpContentUtils.computeToc(STANDARD_SERVICE_PROVIDERS);
        try {
            File tocFile = new File(pluginFolder, "toc.xml");
            System.out.println("Writing the content of toc.xml in " + tocFile.getAbsolutePath());
            DocumentationGenerator.write(buffer.toString(), tocFile, Charset.forName(UTF8));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        StringBuffer aggregated = new StringBuffer();
        Class<?>[] classArray = STANDARD_SERVICE_PROVIDERS;
        int n = STANDARD_SERVICE_PROVIDERS.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> serviceProviderClass = classArray[n2];
            if (serviceProviderClass.isAnnotationPresent(ServiceProvider.class)) {
                try {
                    List<StringBuffer> sections = AQLHelpContentUtils.computeServiceSections(serviceProviderClass);
                    StringBuffer stringBuffer = AQLHelpContentUtils.html(AQLHelpContentUtils.head(), AQLHelpContentUtils.body(AQLHelpContentUtils.header(false), sections));
                    File file = new File(documentationFolder, "aql_service_" + serviceProviderClass.getSimpleName().toLowerCase() + ".html");
                    System.out.println("Writing content of " + file.getAbsolutePath());
                    DocumentationGenerator.write(stringBuffer.toString(), file, Charset.forName(UTF8));
                    List<StringBuffer> sectionsForAggregatedServices = AQLHelpContentUtils.computeServiceSections(serviceProviderClass, 3, AQLHelpContentUtils.METHOD_SIGNATURE_GENERATOR_2016);
                    for (StringBuffer b : sectionsForAggregatedServices) {
                        aggregated.append(b);
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        try {
            int indexOfBodyEnd;
            List<StringBuffer> sections = AQLHelpContentUtils.computeAQLOverviewSections();
            String inputHtmlContent = DocumentationGenerator.read(new File(inputFolder, "index.html"), Charset.forName(UTF8));
            int indexOfBodyStart = inputHtmlContent.indexOf("<body>");
            if (indexOfBodyStart != -1 && indexOfBodyStart + 6 < inputHtmlContent.length()) {
                inputHtmlContent = inputHtmlContent.substring(indexOfBodyStart + 6);
            }
            if ((indexOfBodyEnd = inputHtmlContent.indexOf("</body>")) != -1) {
                inputHtmlContent = inputHtmlContent.substring(0, indexOfBodyEnd);
            }
            sections.add(new StringBuffer(inputHtmlContent));
            StringBuffer stringBuffer = AQLHelpContentUtils.html(AQLHelpContentUtils.head(), AQLHelpContentUtils.body(AQLHelpContentUtils.header(true), sections));
            String out = stringBuffer.toString().replace(TRIGGER_TO_APPEND_STD_DOC, "<p>These sections are listing all the services of the standard library of AQL.</p>\n" + aggregated);
            System.out.println("Writing content of " + indexHtmlFile.getAbsolutePath());
            DocumentationGenerator.write(out, indexHtmlFile, Charset.forName(UTF8));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private static void write(String content, File file, Charset charset) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String read(File file, Charset charset) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), charset);
    }
}

