/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.textdocument;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.location.AcceleoLocator;
import org.eclipse.acceleo.aql.location.common.AbstractLocationLink;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerPositionUtils;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocumentService;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoProject;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.validation.AcceleoValidator;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;

public class AcceleoTextDocument {
    private static final String VALIDATION_NAMESPACE = "_reserved_::to::validate";
    private final URI uri;
    private AcceleoProject ownerProject;
    private String contents;
    private AcceleoAstResult acceleoAstResult;
    private IAcceleoValidationResult acceleoValidationResult;

    public AcceleoTextDocument(URI textDocumentUri, String textDocumentContents, AcceleoProject project) {
        Objects.requireNonNull(textDocumentUri);
        Objects.requireNonNull(textDocumentContents);
        this.ownerProject = project;
        this.uri = textDocumentUri;
        this.setContents(textDocumentContents);
    }

    private void documentChanged() {
        this.parseContents();
        this.validateAndPublishResults();
    }

    public void documentSaved() {
        if (this.getProject() != null) {
            this.getProject().documentSaved(this);
        }
    }

    public void setProject(AcceleoProject acceleoProject) {
        AcceleoProject oldProject = this.ownerProject;
        this.ownerProject = acceleoProject;
        if (acceleoProject == null && oldProject != null || !acceleoProject.equals(oldProject)) {
            this.environmentChanged();
        }
    }

    public void environmentChanged() {
        this.documentChanged();
    }

    public AcceleoProject getProject() {
        return this.ownerProject;
    }

    public String getFileNameWithoutExtension() {
        return this.uri.toString().substring(this.uri.toString().lastIndexOf(47), this.uri.toString().lastIndexOf(46));
    }

    private void parseContents() {
        AcceleoAstResult parsingResult = null;
        if (this.getAcceleoEnvironment() != null) {
            parsingResult = AcceleoTextDocument.doParsing(this.getModuleQualifiedName(), this.contents, this.getAcceleoEnvironment());
        }
        this.acceleoAstResult = parsingResult;
    }

    private static AcceleoAstResult doParsing(String moduleQualifiedName, String documentContents, IAcceleoEnvironment acceleoEnvironment) {
        Objects.requireNonNull(moduleQualifiedName);
        Objects.requireNonNull(documentContents);
        Objects.requireNonNull(acceleoEnvironment);
        AcceleoParser acceleoParser = new AcceleoParser((IReadOnlyQueryEnvironment)acceleoEnvironment.getQueryEnvironment());
        return acceleoParser.parse(documentContents, moduleQualifiedName);
    }

    public void validateContents() {
        IAcceleoValidationResult validationResults = null;
        if (this.acceleoAstResult != null && this.getAcceleoEnvironment() != null) {
            validationResults = AcceleoTextDocument.doValidation(this.acceleoAstResult, this.getAcceleoEnvironment());
        }
        this.acceleoValidationResult = validationResults;
    }

    private static IAcceleoValidationResult doValidation(AcceleoAstResult acceleoAstResult, IAcceleoEnvironment acceleoEnvironment) {
        Objects.requireNonNull(acceleoAstResult);
        Objects.requireNonNull(acceleoEnvironment);
        return AcceleoTextDocument.validate(acceleoEnvironment, new AcceleoValidator(acceleoEnvironment, acceleoEnvironment.getQueryEnvironment().getLookupEngine()), acceleoAstResult);
    }

    public AcceleoLanguageServer getLanguageServer() {
        if (this.getProject() != null) {
            return this.getProject().getLanguageServer();
        }
        return null;
    }

    public AcceleoTextDocumentService getTextDocumentService() {
        AcceleoLanguageServer languageServer = this.getLanguageServer();
        if (languageServer != null) {
            return languageServer.getTextDocumentService();
        }
        return null;
    }

    public void publishValidationResults() {
        AcceleoTextDocumentService service = this.getTextDocumentService();
        if (service != null) {
            service.publishValidationResults(this);
        }
    }

    public void validateAndPublishResults() {
        this.validateContents();
        this.publishValidationResults();
    }

    public String getModuleQualifiedName() {
        if (this.getAcceleoEnvironment() == null || this.getAcceleoEnvironment().getQueryEnvironment() == null || this.getAcceleoEnvironment().getQueryEnvironment().getLookupEngine() == null || this.getAcceleoEnvironment().getQueryEnvironment().getLookupEngine().getResolver() == null) {
            return null;
        }
        IQualifiedNameResolver resolver = this.getAcceleoEnvironment().getQueryEnvironment().getLookupEngine().getResolver();
        return resolver.getQualifiedName(this.getUrl());
    }

    public URL getUrl() {
        try {
            return this.getUri().toURL();
        }
        catch (MalformedURLException urlException) {
            throw new RuntimeException("Could not convert into a URL the URI of document " + this.getUri().toString(), urlException);
        }
    }

    public List<AbstractLocationLink<?, ?>> getDefinitionLocations(int position) {
        IAcceleoEnvironment env = this.getAcceleoEnvironment();
        ModuleElement moduleElement = (ModuleElement)this.acceleoAstResult.getModule().getModuleElements().get(0);
        IQualifiedNameLookupEngine lookupEngine = env.getQueryEnvironment().getLookupEngine();
        lookupEngine.pushImportsContext(this.getModuleQualifiedName(), this.getModuleQualifiedName());
        List definitionLocations = new AcceleoLocator(env, env.getQueryEnvironment().getLookupEngine()).getDefinitionLocations(this.acceleoAstResult, position);
        lookupEngine.popContext(this.getModuleQualifiedName());
        return definitionLocations;
    }

    public List<AbstractLocationLink<?, ?>> getDeclarationLocations(int position) {
        return new AcceleoLocator(this.getAcceleoEnvironment(), this.getAcceleoEnvironment().getQueryEnvironment().getLookupEngine()).getDeclarationLocations(this.acceleoAstResult, position);
    }

    public URI getUri() {
        return this.uri;
    }

    public AcceleoTextDocument applyChanges(Iterable<TextDocumentContentChangeEvent> textDocumentContentchangeEvents) {
        String newTextDocumentContents = this.contents;
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : textDocumentContentchangeEvents) {
            newTextDocumentContents = AcceleoTextDocument.apply(textDocumentContentChangeEvent, newTextDocumentContents);
        }
        this.setContents(newTextDocumentContents);
        return this;
    }

    public void setContents(String newTextDocumentContents) {
        this.contents = newTextDocumentContents;
        this.documentChanged();
    }

    public AcceleoAstResult getAcceleoAstResult() {
        return this.acceleoAstResult;
    }

    public IAcceleoValidationResult getAcceleoValidationResults() {
        return this.acceleoValidationResult;
    }

    public IAcceleoEnvironment getAcceleoEnvironment() {
        if (this.ownerProject != null) {
            return this.ownerProject.getAcceleoEnvironment();
        }
        return null;
    }

    public String getContents() {
        return this.contents;
    }

    private static synchronized IAcceleoValidationResult validate(IAcceleoEnvironment acceleoEnvironment, AcceleoValidator acceleoValidator, AcceleoAstResult acceleoAstResult) {
        String moduleQualifiedNameForValidation = "_reserved_::to::validate::" + acceleoAstResult.getModule().getName();
        IQualifiedNameResolver resolver = acceleoEnvironment.getQueryEnvironment().getLookupEngine().getResolver();
        resolver.register(moduleQualifiedNameForValidation, (Object)acceleoAstResult.getModule());
        IAcceleoValidationResult validationResults = acceleoValidator.validate(acceleoAstResult, moduleQualifiedNameForValidation);
        return validationResults;
    }

    private static String apply(TextDocumentContentChangeEvent textDocumentContentChangeEvent, String inText) {
        String newTextExcerpt = textDocumentContentChangeEvent.getText();
        Range changeRange = textDocumentContentChangeEvent.getRange();
        if (changeRange == null) {
            return newTextExcerpt;
        }
        return AcceleoLanguageServerPositionUtils.replace(inText, changeRange.getStart(), changeRange.getEnd(), newTextExcerpt);
    }
}

