/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.completion.proposals.syntax;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.VisibilityKind;
import org.eclipse.acceleo.aql.completion.proposals.AcceleoCompletionProposal;
import org.eclipse.emf.ecore.EClass;

public final class AcceleoSyntacticCompletionProposals {
    public static final String NEWLINE = "<br/>";
    public static final String CODE_OPEN = "<pre>";
    public static final String CODE_CLOSE = "</pre>";
    public static final String BOLD_OPEN = "<b>";
    public static final String BOLD_CLOSE = "</b>";
    public static final String LIST_OPEN = "<ul>";
    public static final String LIST_CLOSE = "</ul>";
    public static final String LIST_ITEM_OPEN = "<li>";
    public static final String LIST_ITEM_CLOSE = "</li>";
    public static final String SPACE = " ";
    public static final AcceleoCompletionProposal QUOTE_DOUBLE = new AcceleoCompletionProposal("'", "'", null);
    public static final AcceleoCompletionProposal OPEN_PARENTHESIS = new AcceleoCompletionProposal("(", "(", null);
    public static final AcceleoCompletionProposal CLOSE_PARENTHESIS = new AcceleoCompletionProposal(")", ")", null);
    public static final AcceleoCompletionProposal COMMA_SPACE = new AcceleoCompletionProposal(",", ", ", null);
    public static final AcceleoCompletionProposal COLON_SPACE = new AcceleoCompletionProposal(":", ": ", null);
    public static final AcceleoCompletionProposal EQUAL_SPACE = new AcceleoCompletionProposal("=", "= ", null);
    public static final AcceleoCompletionProposal COMMENT_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[comment ", "Inserts the start of a Comment:", AcceleoPackage.Literals.COMMENT);
    public static final AcceleoCompletionProposal COMMENT_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("/]", "Inserts the end of a Comment:", AcceleoPackage.Literals.COMMENT);
    public static final AcceleoCompletionProposal BLOCK_COMMENT_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[comment]", "Inserts the start of a Block Comment:", AcceleoPackage.Literals.BLOCK_COMMENT);
    public static final AcceleoCompletionProposal BLOCK_COMMENT_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[/comment]", "Inserts the end of a Block Comment:", AcceleoPackage.Literals.BLOCK_COMMENT);
    public static final AcceleoCompletionProposal DOCUMENTATION_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[**", "Inserts the start of a Module Documentation or Module Element Documentation:", AcceleoPackage.Literals.DOCUMENTATION);
    public static final AcceleoCompletionProposal DOCUMENTATION_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("/]", "Inserts the end of a Module Documentation or Module Element Documentation:", AcceleoPackage.Literals.DOCUMENTATION);
    public static final AcceleoCompletionProposal IMPORT_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[import ", "Inserts the start of an Import:", AcceleoPackage.Literals.IMPORT);
    public static final AcceleoCompletionProposal IMPORT_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("/]", "Inserts the end of an Import:", AcceleoPackage.Literals.IMPORT);
    public static final AcceleoCompletionProposal MODULE_HEADER_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[module ", "Inserts the start of an Acceleo Module header:", AcceleoPackage.Literals.MODULE);
    public static final AcceleoCompletionProposal MODULE_EXTENSION = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("extends ", "Inserts the extension clause of an Acceleo Module header:", AcceleoPackage.Literals.MODULE);
    public static final AcceleoCompletionProposal MODULE_HEADER_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("/]", "Inserts the end of an Acceleo Module header:", AcceleoPackage.Literals.MODULE);
    public static final AcceleoCompletionProposal TEMPLATE_HEADER_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[template ", "Inserts the start of an Acceleo Template header:", AcceleoPackage.Literals.TEMPLATE);
    public static final AcceleoCompletionProposal TEMPLATE_GUARD_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("? (", "Inserts the start of a template guard:", AcceleoPackage.Literals.TEMPLATE);
    public static final AcceleoCompletionProposal TEMPLATE_POST_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("post(", "Inserts the start of a template post-treatment:", AcceleoPackage.Literals.TEMPLATE);
    public static final AcceleoCompletionProposal TEMPLATE_HEADER_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("]", "Inserts the end of an Acceleo Template header:", AcceleoPackage.Literals.TEMPLATE);
    public static final AcceleoCompletionProposal TEMPLATE_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[/template]", "Inserts the end of an Acceleo Template:", AcceleoPackage.Literals.TEMPLATE);
    public static final AcceleoCompletionProposal QUERY_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[query ", "Inserts the start of a query:", AcceleoPackage.Literals.QUERY);
    public static final AcceleoCompletionProposal QUERY_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("/]", "Inserts the end of a query:", AcceleoPackage.Literals.QUERY);
    public static final AcceleoCompletionProposal STATEMENT_FILE_HEADER_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[file (", "Inserts the start of a File Statement header:", AcceleoPackage.Literals.FILE_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_FILE_HEADER_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("]", "Inserts the end of a File Statement header:", AcceleoPackage.Literals.FILE_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_FILE_HEADER_CLOSE_PARENTHESIS_AND_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal(")]", "Inserts the closing parenthesis and the end of a File Statement header:", AcceleoPackage.Literals.FILE_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_FILE_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[/file]", "Inserts the end of a File Statement:", AcceleoPackage.Literals.FILE_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_IF_HEADER_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[if (", "Inserts the start of an If Statement header:", AcceleoPackage.Literals.IF_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_IF_ELSE = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[else]", "Inserts the 'else' clause of an If Statement:", AcceleoPackage.Literals.IF_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_IF_ELSEIF = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[elseif (", "Inserts an 'elseif' clause to an If Statement:", AcceleoPackage.Literals.IF_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_IF_HEADER_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("]", "Inserts the end of an If Statement header:", AcceleoPackage.Literals.IF_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_IF_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[/if]", "Inserts the end of an If Statement:", AcceleoPackage.Literals.IF_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_IF_HEADER_CLOSE_PARENTHESIS_AND_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal(")]", "Inserts the closing parenthesis and end of an If Statement header:", AcceleoPackage.Literals.IF_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_FOR_HEADER_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[for (", "Inserts the start of a For Statement header:", AcceleoPackage.Literals.FOR_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_FOR_HEADER_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("]", "Inserts the end of a For Statement header:", AcceleoPackage.Literals.FOR_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_FOR_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[/for]", "Inserts the end of a For Statement:", AcceleoPackage.Literals.FOR_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_FOR_HEADER_CLOSE_PARENTHESIS_AND_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal(")]", "Inserts a closing parenthesis and the end of a For Statement header:", AcceleoPackage.Literals.FOR_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_FOR_HEADER_SEPARATOR = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("separator(", "Inserts the For Statement separator expression:", AcceleoPackage.Literals.FOR_STATEMENT);
    public static final AcceleoCompletionProposal FOR_STATEMENT_PIPE = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("|", "Inserts the For Statement pipe that separates the variable declaration and its value binding:", AcceleoPackage.Literals.FOR_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_LET_HEADER_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[let ", "Inserts the start of a Let Statement header:", AcceleoPackage.Literals.LET_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_LET_HEADER_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("]", "Inserts the end of a Let Statement header:", AcceleoPackage.Literals.LET_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_LET_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[/let]", "Inserts the end of a Let Statement:", AcceleoPackage.Literals.LET_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_PROTECTED_AREA_HEADER_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[protected (", "Inserts the start of a Protected Area Statement header:", AcceleoPackage.Literals.PROTECTED_AREA);
    public static final AcceleoCompletionProposal STATEMENT_PROTECTED_AREA_START_TAG_PREFIX = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("startTagPrefix(", "Inserts the Protected Area Statement start tag prefix expression:", AcceleoPackage.Literals.PROTECTED_AREA);
    public static final AcceleoCompletionProposal STATEMENT_PROTECTED_AREA_END_TAG_PREFIX = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("endTagPrefix(", "Inserts the Protected Area Statement end tag prefix expression:", AcceleoPackage.Literals.PROTECTED_AREA);
    public static final AcceleoCompletionProposal STATEMENT_PROTECTED_AREA_HEADER_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("]", "Inserts the end of a Protected Area Statement header:", AcceleoPackage.Literals.PROTECTED_AREA);
    public static final AcceleoCompletionProposal STATEMENT_PROTECTED_AREA_HEADER_CLOSE_PARENTHESIS_AND_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal(")]", "Inserts a closing parenthesis and the end of a Protected Area Statement header:", AcceleoPackage.Literals.PROTECTED_AREA);
    public static final AcceleoCompletionProposal STATEMENT_PROTECTED_AREA_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[/protected]", "Inserts the end of a Protected Area Statement:", AcceleoPackage.Literals.PROTECTED_AREA);
    public static final AcceleoCompletionProposal STATEMENT_EXPRESSION_START = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("[", "Inserts the start of an Expression Statement:", AcceleoPackage.Literals.EXPRESSION_STATEMENT);
    public static final AcceleoCompletionProposal STATEMENT_EXPRESSION_END = AcceleoSyntacticCompletionProposals.createSyntacticCompletionProposal("/]", "Inserts the end of an Expression Statement:", AcceleoPackage.Literals.EXPRESSION_STATEMENT);
    public static final List<AcceleoCompletionProposal> STATEMENT_FILE_OPEN_MODES = OpenModeKind.VALUES.stream().map(openModeKind -> {
        String overwriteLabel = OpenModeKind.OVERWRITE.getName();
        String appendLabel = OpenModeKind.APPEND.getName();
        String createLabel = OpenModeKind.CREATE.getName();
        switch (openModeKind) {
            case OVERWRITE: {
                overwriteLabel = BOLD_OPEN + overwriteLabel + BOLD_CLOSE;
                break;
            }
            case APPEND: {
                appendLabel = BOLD_OPEN + appendLabel + BOLD_CLOSE;
                break;
            }
            case CREATE: {
                createLabel = BOLD_OPEN + createLabel + BOLD_CLOSE;
                break;
            }
        }
        return new AcceleoCompletionProposal(openModeKind.getName(), "The open mode for a File Statement determines the strategy to use <i>if there already exists a file with the desired name</i> at the generation destination.<br/><ul><li>" + overwriteLabel + ": overwrites the contents of the existing file." + LIST_ITEM_CLOSE + LIST_ITEM_OPEN + appendLabel + ": appends the generated contents to the end of the existing file." + LIST_ITEM_CLOSE + LIST_ITEM_OPEN + createLabel + ": no content is generated." + LIST_ITEM_CLOSE + LIST_CLOSE, openModeKind.getName(), AcceleoPackage.Literals.FILE_STATEMENT);
    }).collect(Collectors.toList());
    public static final List<AcceleoCompletionProposal> MODULE_ELEMENT_VISIBILITY_KINDS = VisibilityKind.VALUES.stream().map(visibilityKind -> {
        String publicLabel = VisibilityKind.PUBLIC.getName();
        String protectedLabel = VisibilityKind.PROTECTED.getName();
        String privateLabel = VisibilityKind.PRIVATE.getName();
        switch (visibilityKind) {
            case PUBLIC: {
                publicLabel = BOLD_OPEN + publicLabel + BOLD_CLOSE;
                break;
            }
            case PROTECTED: {
                protectedLabel = BOLD_OPEN + protectedLabel + BOLD_CLOSE;
                break;
            }
            case PRIVATE: {
                privateLabel = BOLD_OPEN + privateLabel + BOLD_CLOSE;
                break;
            }
        }
        return new AcceleoCompletionProposal(visibilityKind.getName(), "The visibility of a Query or Template determines whether it is accessible to other Acceleo Modules.<br/><ul><li>" + publicLabel + ": always accessible to all Acceleo Modules." + LIST_ITEM_CLOSE + LIST_ITEM_OPEN + protectedLabel + ": accessible only to this Module, and other Modules extending this Module." + LIST_ITEM_CLOSE + LIST_ITEM_OPEN + privateLabel + ": accessible only to this Module." + LIST_ITEM_CLOSE + LIST_CLOSE, String.valueOf(visibilityKind.getName()) + SPACE, AcceleoPackage.Literals.MODULE_ELEMENT);
    }).collect(Collectors.toList());

    private AcceleoSyntacticCompletionProposals() {
    }

    private static AcceleoCompletionProposal createSyntacticCompletionProposal(String insertedText, String descriptionSentenceBeforeCode, EClass acceleoType) {
        return new AcceleoCompletionProposal(insertedText, String.valueOf(descriptionSentenceBeforeCode) + NEWLINE + CODE_OPEN + insertedText + CODE_CLOSE, insertedText, acceleoType);
    }
}

