/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.jdt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.ide.jdt.Activator;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.EclipseQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

public class EclipseJDTQualifiedNameResolver
extends ClassLoaderQualifiedNameResolver {
    private final IJavaProject project;

    public EclipseJDTQualifiedNameResolver(ClassLoader classLoader, IProject project, String qualifierSeparator) {
        super(EclipseJDTQualifiedNameResolver.createProjectClassLoader(classLoader, project), qualifierSeparator);
        this.project = JavaCore.create((IProject)project);
    }

    protected static ClassLoader createProjectClassLoader(ClassLoader classLoader, IProject project) {
        ClassLoader res;
        if (project.exists() && project.isOpen()) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                try {
                    String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
                    ArrayList<URL> urlList = new ArrayList<URL>();
                    String[] stringArray = classPathEntries;
                    int n = classPathEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String entry = stringArray[n2];
                        Path path = new Path(entry);
                        URL url = path.toFile().toURI().toURL();
                        urlList.add(url);
                        ++n2;
                    }
                    URL[] urls = urlList.toArray(new URL[urlList.size()]);
                    res = new URLClassLoader(urls, classLoader);
                }
                catch (CoreException e) {
                    Activator.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.jdt", "can't load from workspace.", (Throwable)e));
                    res = EclipseQualifiedNameResolver.createProjectClassLoader((ClassLoader)classLoader, (IProject)project);
                }
                catch (MalformedURLException e) {
                    Activator.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.jdt", "can't load from workspace.", (Throwable)e));
                    res = EclipseQualifiedNameResolver.createProjectClassLoader((ClassLoader)classLoader, (IProject)project);
                }
            } else {
                res = EclipseQualifiedNameResolver.createProjectClassLoader((ClassLoader)classLoader, (IProject)project);
            }
        } else {
            res = classLoader;
        }
        return res;
    }

    public URI getSourceURI(String qualifiedName) {
        URI res;
        block5: {
            if (this.project != null) {
                try {
                    URI foundURI = this.getSourceURI(this.project, qualifiedName);
                    if (foundURI != null) {
                        res = foundURI;
                        break block5;
                    }
                    res = super.getSourceURI(qualifiedName);
                }
                catch (JavaModelException e) {
                    res = super.getSourceURI(qualifiedName);
                }
            } else {
                res = super.getSourceURI(qualifiedName);
            }
        }
        return res;
    }

    private URI getSourceURI(IJavaProject javaProject, String qualifiedName) throws JavaModelException {
        URI res = null;
        IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        block0: while (n2 < n) {
            IProject childProject;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                String srcFolder = entry.getPath().toString();
                List relativePathes = this.getPossibleResourceNames(qualifiedName);
                for (String relativePath : relativePathes) {
                    URI uri = workspaceRoot.getFile((IPath)new Path(String.valueOf(srcFolder) + "/" + relativePath)).getLocationURI();
                    File file = new File(uri);
                    if (!file.isFile() || !file.exists()) continue;
                    res = file.toURI();
                    break block0;
                }
            } else if (entry.getEntryKind() == 2 && (childProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment())) != null) {
                IJavaProject childJavaProject = JavaCore.create((IProject)childProject);
                res = this.getSourceURI(childJavaProject, qualifiedName);
            }
            ++n2;
        }
        return res;
    }

    protected IJavaProject getProject() {
        return this.project;
    }
}

