/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nooperationreflection.NooperationreflectionPackage;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.ECrossReferenceAdapterCrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.impl.QueryValidationEngine;
import org.eclipse.acceleo.query.runtime.impl.ResourceSetRootEObjectProvider;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.acceleo.query.tests.services.EObjectServices;
import org.eclipse.acceleo.query.tests.services.ReceiverServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidationTest {
    QueryValidationEngine engine;
    IQueryEnvironment queryEnvironment;
    Map<String, Set<IType>> variableTypes = new LinkedHashMap<String, Set<IType>>();

    @Before
    public void setup() {
        ResourceSetImpl dummyResourceSet = new ResourceSetImpl();
        ECrossReferenceAdapterCrossReferenceProvider crossReferenceProvider = new ECrossReferenceAdapterCrossReferenceProvider(ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)dummyResourceSet));
        ResourceSetRootEObjectProvider rootProvider = new ResourceSetRootEObjectProvider((ResourceSet)dummyResourceSet);
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices((CrossReferenceProvider)crossReferenceProvider, (IRootEObjectProvider)rootProvider);
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)NooperationreflectionPackage.eINSTANCE);
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, EObjectServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        this.engine = new QueryValidationEngine((IReadOnlyQueryEnvironment)this.queryEnvironment);
        this.variableTypes.clear();
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        this.variableTypes.put("self", selfTypes);
        LinkedHashSet<EClassifierType> stuffTypes = new LinkedHashSet<EClassifierType>();
        stuffTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("stuff", stuffTypes);
        LinkedHashSet<EClassifierType> noReflexionTypes = new LinkedHashSet<EClassifierType>();
        noReflexionTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)NooperationreflectionPackage.eINSTANCE.getNoOperationReflection()));
        this.variableTypes.put("noReflexion", noReflexionTypes);
    }

    @Test
    public void nullTest() {
        IValidationResult validationResult = this.engine.validate(null, this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "null or empty string.", -1, -1);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "null or empty string.", -1, -1);
    }

    @Test
    public void emptyTest() {
        IValidationResult validationResult = this.engine.validate("", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "null or empty string.", 0, 0);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "null or empty string.", 0, 0);
    }

    @Test
    public void variableTest() {
        IValidationResult validationResult = this.engine.validate("self", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void variableNotRegisteredEClassifierTest() {
        this.queryEnvironment.removeEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.engine.validate("self", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "EClassifier=EClass is not registered in the current environment", 0, 4);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "EClassifier=EClass is not registered in the current environment", 0, 4);
    }

    @Test
    public void variableNotExistingTest() {
        IValidationResult validationResult = this.engine.validate("notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'notExisting' variable", 0, 11);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'notExisting' variable", 0, 11);
    }

    @Test
    public void featureAccessTest() {
        IValidationResult validationResult = this.engine.validate("self.name", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void featureNotExistingAccessTest() {
        IValidationResult validationResult = this.engine.validate("self.notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Feature notExisting not found in EClass EClass", 4, 16);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Feature notExisting not found in EClass EClass", 4, 16);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void flattenSequenceNothingFeatureNotExistingAccessTest() {
        IValidationResult validationResult = this.engine.validate("self->asSequence().notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        ValidationTest.assertNothingType("Feature notExisting not found in EClass EClass", ((SequenceType)type).getCollectionType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass", 18, 30);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass", 18, 30);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
    }

    @Test
    public void flattenSetNothingFeatureNotExistingAccessTest() {
        IValidationResult validationResult = this.engine.validate("self->asSet().notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        ValidationTest.assertNothingType("Feature notExisting not found in EClass EClass", ((SetType)type).getCollectionType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass", 13, 25);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass", 13, 25);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
    }

    @Test
    public void flattenSequenceNothingOclAsTypeTest() {
        IValidationResult validationResult = this.engine.validate("self->asSequence().oclAsType(ecore::EPackage)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        ValidationTest.assertNothingType("Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", ((SequenceType)type).getCollectionType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", 18, 45);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", 18, 45);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void flattenSetNothingOclAsTypeTest() {
        IValidationResult validationResult = this.engine.validate("self->asSequence().oclAsType(ecore::EPackage)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        ValidationTest.assertNothingType("Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", ((SequenceType)type).getCollectionType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", 18, 45);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", 18, 45);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void flattenSequenceNothingMultipleTypesNotExistingOnAnyAccessTest() {
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("multiType", selfTypes);
        IValidationResult validationResult = this.engine.validate("multiType->asSequence().notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        ValidationTest.assertNothingType("Feature notExisting not found in EClass EClass\nFeature notExisting not found in EClass EPackage", ((SequenceType)type).getCollectionType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass\nFeature notExisting not found in EClass EPackage", 23, 35);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass\nFeature notExisting not found in EClass EPackage", 23, 35);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
    }

    @Test
    public void flattenSetNothingMultipleTypesNotExistingOnAnyAccessTest() {
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("multiType", selfTypes);
        IValidationResult validationResult = this.engine.validate("multiType->asSet().notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        ValidationTest.assertNothingType("Feature notExisting not found in EClass EClass\nFeature notExisting not found in EClass EPackage", ((SetType)type).getCollectionType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass\nFeature notExisting not found in EClass EPackage", 18, 30);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass\nFeature notExisting not found in EClass EPackage", 18, 30);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
    }

    @Test
    public void flattenSequenceNothingMultipleTypesNotExistingOnOneAccessTest() {
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("multiType", selfTypes);
        IValidationResult validationResult = this.engine.validate("multiType->asSequence().eClassifiers", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), (Object)((EClassifierType)((SequenceType)type).getCollectionType()).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        ValidationTest.assertNothingType("Feature eClassifiers not found in EClass EClass", ((SequenceType)type).getCollectionType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature eClassifiers not found in EClass EClass", 23, 36);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Empty collection: Feature eClassifiers not found in EClass EClass", 23, 36);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
    }

    @Test
    public void flattenSetNothingMultipleTypesNotExistingOnOneAccessTest() {
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("multiType", selfTypes);
        IValidationResult validationResult = this.engine.validate("multiType->asSet().eClassifiers", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), (Object)((EClassifierType)((SetType)type).getCollectionType()).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        ValidationTest.assertNothingType("Feature eClassifiers not found in EClass EClass", ((SetType)type).getCollectionType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature eClassifiers not found in EClass EClass", 18, 31);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Empty collection: Feature eClassifiers not found in EClass EClass", 18, 31);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
    }

    @Test
    public void intliteralTest() {
        IValidationResult validationResult = this.engine.validate("2", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Integer.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void realliteralTest() {
        IValidationResult validationResult = this.engine.validate("1.0", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Double.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void trueliteralTest() {
        IValidationResult validationResult = this.engine.validate("true", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void falseliteralTest() {
        IValidationResult validationResult = this.engine.validate("false", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void stringliteralTest() {
        IValidationResult validationResult = this.engine.validate("'acceleo query is great'", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(String.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void operatorTest() {
        IValidationResult validationResult = this.engine.validate("1<=2", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void operatorWrongArgumentTypeTest() {
        IValidationResult validationResult = this.engine.validate("1 and '3'", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'and(java.lang.Integer,java.lang.String)' service", 0, 9);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'and(java.lang.Integer,java.lang.String)' service", 0, 9);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void operatorNullParameterTypeTest() {
        IValidationResult validationResult = this.engine.validate("true and null", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void serviceTest() {
        IValidationResult validationResult = this.engine.validate("self.someService('a')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Integer.TYPE, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void serviceWrongArgumentTypeTest() {
        IValidationResult validationResult = this.engine.validate("self.someService(true)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'someService(EClassifier=EClass,java.lang.Boolean)' service", 4, 22);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'someService(EClassifier=EClass,java.lang.Boolean)' service", 4, 22);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void serviceNullParameterTypeTest() {
        IValidationResult validationResult = this.engine.validate("self.someService(null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Integer.TYPE, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void eOperationTest() {
        IValidationResult validationResult = this.engine.validate("stuff.getEClassifier('EClass')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void eOperationWrongArgumentTypeTest() {
        IValidationResult validationResult = this.engine.validate("stuff.getEClassifier(1)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'getEClassifier(EClassifier=EPackage,java.lang.Integer)' service", 5, 23);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'getEClassifier(EClassifier=EPackage,java.lang.Integer)' service", 5, 23);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void eOperationNullParameterTypeTest() {
        IValidationResult validationResult = this.engine.validate("stuff.getEClassifier(null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void classifierType() {
        IValidationResult validationResult = this.engine.validate("ecore::EClass", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierLiteralType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void classifierTypeError() {
        IValidationResult validationResult = this.engine.validate("anydsl::EClass", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid type literal anydsl::EClass", 0, 14);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "invalid type literal anydsl::EClass", 0, 14);
    }

    @Test
    public void classifierTypeErrorMissingOneColon() {
        IValidationResult validationResult = this.engine.validate("anydsl:", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid type literal anydsl:", 0, 7);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "invalid type literal anydsl:", 0, 7);
    }

    @Test
    public void enumLiteral() {
        IValidationResult validationResult = this.engine.validate("anydsl::Part::Other", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)AnydslPackage.eINSTANCE.getPart(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void enumLiteralInSelectWithMissingClosingParenthesis() {
        IValidationResult validationResult = this.engine.validate("self->select(s | s = anydsl::Color::black", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof NothingType));
        Assert.assertEquals((Object)"missing ')'", (Object)((NothingType)possibleType).getMessage());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "missing ')'", 4, 41);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "missing ')'", 4, 41);
    }

    @Test
    public void enumLiteralError() {
        IValidationResult validationResult = this.engine.validate("anydsl::Part::NotExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid enum literal: no literal registered with this name", 0, 25);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "invalid enum literal: no literal registered with this name", 0, 25);
    }

    @Test
    public void enumLiteralErrorMissingOneColon() {
        IValidationResult validationResult = this.engine.validate("anydsl::Part:", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid enum literal: ':' instead of '::'", 0, 13);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "invalid enum literal: ':' instead of '::'", 0, 13);
    }

    @Test
    public void testNullLiteral() {
        IValidationResult validationResult = this.engine.validate("null", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(null, (Object)((ClassType)possibleType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void testSetInExtensionLiteral() {
        IValidationResult validationResult = this.engine.validate("OrderedSet{self, self, true, false}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)((ClassType)((SetType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((SetInExtensionLiteral)ast).getValues().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((SetInExtensionLiteral)ast).getValues().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((SetInExtensionLiteral)ast).getValues().get(2)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((SetInExtensionLiteral)ast).getValues().get(3)).size());
    }

    @Test
    public void setInExtensionLiteralEmpty() {
        IValidationResult validationResult = this.engine.validate("OrderedSet{}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof ClassType));
        Assert.assertEquals(null, (Object)((ClassType)((SetType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void testSequenceInExtensionLiteral() {
        IValidationResult validationResult = this.engine.validate("Sequence{self, self, true, false}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SequenceType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)((ClassType)((SequenceType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((SequenceInExtensionLiteral)ast).getValues().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((SequenceInExtensionLiteral)ast).getValues().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((SequenceInExtensionLiteral)ast).getValues().get(2)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((SequenceInExtensionLiteral)ast).getValues().get(3)).size());
    }

    @Test
    public void sequenceInExtensionLiteralEmpty() {
        IValidationResult validationResult = this.engine.validate("Sequence{}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof ClassType));
        Assert.assertEquals(null, (Object)((ClassType)((SequenceType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void testConditionNothingCondition() {
        LinkedHashSet<NothingType> selectorTypes = new LinkedHashSet<NothingType>();
        selectorTypes.add(new NothingType("nothing"));
        this.variableTypes.put("selector", selectorTypes);
        IValidationResult validationResult = this.engine.validate("if selector then self else stuff endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "nothing", 3, 11);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, "The predicate never evaluates to a boolean type ([]).", 0, 38);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "The predicate never evaluates to a boolean type ([]).", 0, 38);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getPredicate()).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Conditional)ast).getPredicate()).get(0), ValidationMessageLevel.ERROR, "nothing", 3, 11);
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getTrueBranch()));
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getTrueBranch()).size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getFalseBranch()));
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getFalseBranch()).size());
    }

    @Test
    public void testConditionNotBooleanCondition() {
        LinkedHashSet<EClassifierType> selectorTypes = new LinkedHashSet<EClassifierType>();
        selectorTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        this.variableTypes.put("selector", selectorTypes);
        IValidationResult validationResult = this.engine.validate("if selector then self else stuff endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "The predicate never evaluates to a boolean type ([EClassifier=EClass]).", 0, 38);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "The predicate never evaluates to a boolean type ([EClassifier=EClass]).", 0, 38);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getPredicate()).size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getTrueBranch()));
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getTrueBranch()).size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getFalseBranch()));
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getFalseBranch()).size());
    }

    @Test
    public void testConditionOneBooleanTypeCondition() {
        LinkedHashSet<ClassType> selectorTypes = new LinkedHashSet<ClassType>();
        selectorTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Boolean.class));
        this.variableTypes.put("selector", selectorTypes);
        IValidationResult validationResult = this.engine.validate("if selector then self else stuff endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getPredicate()).size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getTrueBranch()));
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getTrueBranch()).size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getFalseBranch()));
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getFalseBranch()).size());
    }

    @Test
    public void testConditionManyBooleanTypesCondition() {
        LinkedHashSet<ClassType> selectorTypes = new LinkedHashSet<ClassType>();
        selectorTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Boolean.class));
        selectorTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Boolean.TYPE));
        this.variableTypes.put("selector", selectorTypes);
        IValidationResult validationResult = this.engine.validate("if selector then self else stuff endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getPredicate()).size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getTrueBranch()));
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getTrueBranch()).size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getFalseBranch()));
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getFalseBranch()).size());
    }

    @Test
    public void testConditionNotOnlyBooleanTypesCondition() {
        LinkedHashSet<ClassType> selectorTypes = new LinkedHashSet<ClassType>();
        selectorTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Boolean.class));
        selectorTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Object.class));
        this.variableTypes.put("selector", selectorTypes);
        IValidationResult validationResult = this.engine.validate("if selector then self else stuff endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)possibleType.getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.WARNING, "The predicate may evaluate to a value that is not a boolean type ([java.lang.Boolean, java.lang.Object]).", 0, 38);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getPredicate()).size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getTrueBranch()));
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getTrueBranch()).size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getFalseBranch()));
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getFalseBranch()).size());
    }

    @Test
    public void testLetMaskingVariable() {
        IValidationResult validationResult = this.engine.validate("let stuff = self in stuff", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).get(0), ValidationMessageLevel.WARNING, "Variable stuff overrides an existing value.", 4, 16);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBody()).size());
    }

    @Test
    public void testLetMaskingBinding() {
        IValidationResult validationResult = this.engine.validate("let a = 1, a = 2 in self", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertEquals((Object)true, (Object)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(1)).get(0), ValidationMessageLevel.WARNING, "Variable a overrides an existing value.", 11, 16);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(1)).getValue()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBody()).size());
    }

    @Test
    public void testLet() {
        IValidationResult validationResult = this.engine.validate("let newVar = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBody()).size());
    }

    @Test
    public void typeSetLiteral() {
        IValidationResult validationResult = this.engine.validate("{ecore::EClass | ecore::EPackage | ecore::EAttribute}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierSetLiteralType));
        EClassifierSetLiteralType eClassifierSetLiteralType = (EClassifierSetLiteralType)possibleType;
        Assert.assertEquals((long)3L, (long)eClassifierSetLiteralType.getEClassifiers().size());
        Iterator itECls = eClassifierSetLiteralType.getEClassifiers().iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), itECls.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), itECls.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAttribute(), itECls.next());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void typeSetLiteralDuplicates() {
        IValidationResult validationResult = this.engine.validate("{ecore::EClass | ecore::EPackage | ecore::EAttribute | ecore::EPackage}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierSetLiteralType));
        EClassifierSetLiteralType eClassifierSetLiteralType = (EClassifierSetLiteralType)possibleType;
        Assert.assertEquals((long)3L, (long)eClassifierSetLiteralType.getEClassifiers().size());
        Iterator itECls = eClassifierSetLiteralType.getEClassifiers().iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), itECls.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), itECls.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAttribute(), itECls.next());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "EClassifierLiteral=EPackage is duplicated in the type set literal.", 0, 71);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.WARNING, "EClassifierLiteral=EPackage is duplicated in the type set literal.", 0, 71);
    }

    @Test
    public void testLetBindingCompatibleType() {
        IValidationResult validationResult = this.engine.validate("let newVar : ecore::EClass = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBody()).size());
    }

    @Test
    public void testLetBindingCompatibleTypeTypeSetLiteral() {
        IValidationResult validationResult = this.engine.validate("let newVar : {ecore::EPackage | ecore::EClass} = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getType()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBody()).size());
    }

    @Test
    public void testLetBindingIncompatibleType() {
        IValidationResult validationResult = this.engine.validate("let newVar : ecore::EPackage = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage].", 39, 45);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getType()).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBody()).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Let)ast).getBody()).get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage].", 39, 45);
    }

    @Test
    public void testLetBindingInvalidType() {
        IValidationResult validationResult = this.engine.validate("let newVar : invalid::Type = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid type literal invalid::Type", 13, 26);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [].", 37, 43);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getType()).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getType()).get(0), ValidationMessageLevel.ERROR, "invalid type literal invalid::Type", 13, 26);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBody()).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Let)ast).getBody()).get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [].", 37, 43);
    }

    @Test
    public void testLetBindingIncompatibleTypeTypeSetLiteral() {
        IValidationResult validationResult = this.engine.validate("let newVar : {ecore::EPackage | ecore::EReference} = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage, EClassifier=EReference].", 61, 67);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getType()).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBody()).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Let)ast).getBody()).get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage, EClassifier=EReference].", 61, 67);
    }

    @Test
    public void testLetExpressionError() {
        IValidationResult validationResult = this.engine.validate("let newVar = 'text' in newVar + notAVariable", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'notAVariable' variable", 32, 44);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBody()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Let)ast).getBody()).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)((Let)ast).getBody()).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)((Let)ast).getBody()).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'notAVariable' variable", 32, 44);
    }

    @Test
    public void testLetBindingExpressionError() {
        IValidationResult validationResult = this.engine.validate("let newVar = notAVariable in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'notAVariable' variable", 13, 25);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, "The newVar variable has no types", 29, 35);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBindings().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getValue()).get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'notAVariable' variable", 13, 25);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Binding)((Let)ast).getBindings().get(0)).getType()).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Let)ast).getBody()).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Let)ast).getBody()).get(0), ValidationMessageLevel.ERROR, "The newVar variable has no types", 29, 35);
    }

    @Test
    public void eInverseFeatureNameStringLiteral() {
        IValidationResult validationResult = this.engine.validate("self.eInverse('ePackage')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void eInverseFeatureNameExpression() {
        IValidationResult validationResult = this.engine.validate("self.eInverse('ePac'+'kage')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)8L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEReference(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypedElement(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEGenericType(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void eInverse() {
        IValidationResult validationResult = this.engine.validate("self.eInverse()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)8L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEReference(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypedElement(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEGenericType(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void eInverseFiltered() {
        IValidationResult validationResult = this.engine.validate("self.eInverse(ecore::EStructuralFeature)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEReference(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void booleanLambdaCheck_484375() {
        IValidationResult validationResult = this.engine.validate("Sequence{'hello'}->any(i | i = 'hello')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(String.class, (Object)((ClassType)possibleType).getType());
        possibleTypes = validationResult.getPossibleTypes(((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        it = possibleTypes.iterator();
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)((ClassType)possibleType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
    }

    @Test
    public void variableDefinitionCompatibleType() {
        IValidationResult validationResult = this.engine.validate("self->select(newVar : ecore::EClass | newVar <> null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(1)).size());
    }

    @Test
    public void variableDefinitionCompatibleTypeTypeSetLiteral() {
        IValidationResult validationResult = this.engine.validate("self->select(newVar : {ecore::EPackage | ecore::EClass} | newVar <> null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(1)).size());
    }

    @Test
    public void variableDefinitionIncompatibleType() {
        IValidationResult validationResult = this.engine.validate("self->select(newVar : ecore::EPackage | newVar <> null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage].", 40, 46);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage].", 40, 46);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(1)).size());
    }

    @Test
    public void variableDefinitionInvalidType() {
        IValidationResult validationResult = this.engine.validate("self->select(newVar : invalid::Type | newVar <> null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid type literal invalid::Type", 22, 35);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [].", 38, 44);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getExpression()).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).get(0), ValidationMessageLevel.ERROR, "invalid type literal invalid::Type", 22, 35);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [].", 38, 44);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(1)).size());
    }

    @Test
    public void variableDefinitionIncompatibleTypeTypeSetLiteral() {
        IValidationResult validationResult = this.engine.validate("self->select(newVar : {ecore::EPackage | ecore::EReference} | newVar <> null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage, EClassifier=EReference].", 62, 68);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage, EClassifier=EReference].", 62, 68);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(1)).size());
    }

    @Test
    public void testCollectionCallOnNull_toString() {
        IValidationResult validationResult = this.engine.validate("null->toString()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(String.class, (Object)possibleType.getType());
    }

    @Test
    public void testCollectionCallOnNull_size() {
        IValidationResult validationResult = this.engine.validate("null->size()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Integer.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void testCollectionCallOnNull_first() {
        IValidationResult validationResult = this.engine.validate("null->first()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "The Collection was empty due to a null value being wrapped as a Collection.", 4, 13);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "The Collection was empty due to a null value being wrapped as a Collection.", 4, 13);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void testCollectionCallOnNullFromUnsetReference() {
        LinkedHashSet<EClassifierType> operationTypes = new LinkedHashSet<EClassifierType>();
        operationTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEOperation()));
        this.variableTypes.put("operation", operationTypes);
        IValidationResult validationResult = this.engine.validate("operation.eType->first()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
    }

    @Test
    public void eOperationLookupNoEClassifierForClassType() {
        LinkedHashSet<ClassType> nonEMFTypes = new LinkedHashSet<ClassType>();
        nonEMFTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Query.class));
        this.variableTypes.put("nonEMF", nonEMFTypes);
        IValidationResult validationResult = this.engine.validate("self.triggerEOperationLookUp(nonEMF)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'triggerEOperationLookUp(EClassifier=EClass,org.eclipse.acceleo.query.runtime.Query)' service", 4, 36);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'triggerEOperationLookUp(EClassifier=EClass,org.eclipse.acceleo.query.runtime.Query)' service", 4, 36);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void collectionTypeLiteralSequence() {
        IValidationResult validationResult = this.engine.validate("Sequence(String)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof ClassType));
        Assert.assertEquals(String.class, (Object)((SequenceType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((CollectionTypeLiteral)ast).getElementType()).size());
    }

    @Test
    public void collectionTypeLiteralOrderedSet() {
        IValidationResult validationResult = this.engine.validate("OrderedSet(String)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof ClassType));
        Assert.assertEquals(String.class, (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((CollectionTypeLiteral)ast).getElementType()).size());
    }

    @Test
    public void oclAsTypeManyTypesNoneMatching() {
        IValidationResult validationResult = this.engine.validate("self.eContainer().oclAsType(ecore::EInt)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        ValidationTest.assertNothingType("Nothing will be left after calling oclAsType:\nEClassifier=EPackage is not compatible with type EClassifierLiteral=EInt\nEClassifier=EAnnotation is not compatible with type EClassifierLiteral=EInt", possibleType);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nEClassifier=EPackage is not compatible with type EClassifierLiteral=EInt\nEClassifier=EAnnotation is not compatible with type EClassifierLiteral=EInt", 17, 40);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nEClassifier=EPackage is not compatible with type EClassifierLiteral=EInt\nEClassifier=EAnnotation is not compatible with type EClassifierLiteral=EInt", 17, 40);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
    }

    @Test
    public void eGetWithStringLiteral() {
        IValidationResult validationResult = this.engine.validate("self.eGet('name')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void eGetWithExpression() {
        IValidationResult validationResult = this.engine.validate("self.eGet('na'+'me')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Object.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void eOperationNoReflectionTest() {
        IValidationResult validationResult = this.engine.validate("noReflexion.eOperationNoReflection('text')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void eOperationNoReflectionSubParameterTypeTest() {
        IValidationResult validationResult = this.engine.validate("noReflexion.eOperationNoReflectionSubParameterType(ecore::EClass)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void eOperationNoReflectionListParameterTest() {
        IValidationResult validationResult = this.engine.validate("noReflexion.eOperationNoReflectionListParameter(Sequence{ecore::EClass, ecore::EOperation})", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void javaMethodReceiverServiceNoArg() {
        LinkedHashSet<ClassType> selfTypes = new LinkedHashSet<ClassType>();
        selfTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, ReceiverServices.class));
        this.variableTypes.put("self", selfTypes);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)ServiceUtils.getReceiverServices((IReadOnlyQueryEnvironment)this.queryEnvironment, ReceiverServices.class));
        IValidationResult validationResult = this.engine.validate("self.noArg()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(String.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void javaMethodReceiverServiceArg() {
        LinkedHashSet<ClassType> selfTypes = new LinkedHashSet<ClassType>();
        selfTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, ReceiverServices.class));
        this.variableTypes.put("self", selfTypes);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)ServiceUtils.getReceiverServices((IReadOnlyQueryEnvironment)this.queryEnvironment, ReceiverServices.class));
        IValidationResult validationResult = this.engine.validate("self.arg('arg')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(String.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void dynamicEClass() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("dynamic");
        ePkg.setNsURI("dynamic");
        ePkg.setNsPrefix("dynamic");
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls.setName("DynamicEClass");
        ePkg.getEClassifiers().add((Object)eCls);
        EAttribute eAttribute = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eAttribute.setName("dynamicEAttribute");
        eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eCls.getEStructuralFeatures().add((Object)eAttribute);
        this.queryEnvironment.registerEPackage(ePkg);
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)eCls));
        types.put("self", selfType);
        Set oldSelfType = this.variableTypes.put("self", selfType);
        IValidationResult validationResult = this.engine.validate("self", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        this.queryEnvironment.removeEPackage(ePkg);
        this.variableTypes.put("self", oldSelfType);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)eCls, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
    }

    @Test
    public void dynamicEAttribute() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("dynamic");
        ePkg.setNsURI("dynamic");
        ePkg.setNsPrefix("dynamic");
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls.setName("DynamicEClass");
        ePkg.getEClassifiers().add((Object)eCls);
        EAttribute eAttribute = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        eAttribute.setName("dynamicEAttribute");
        eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eCls.getEStructuralFeatures().add((Object)eAttribute);
        this.queryEnvironment.registerEPackage(ePkg);
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)eCls));
        types.put("self", selfType);
        Set oldSelfType = this.variableTypes.put("self", selfType);
        IValidationResult validationResult = this.engine.validate("self.dynamicEAttribute", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        this.queryEnvironment.removeEPackage(ePkg);
        this.variableTypes.put("self", oldSelfType);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void dynamicEOperation() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("dynamic");
        ePkg.setNsURI("dynamic");
        ePkg.setNsPrefix("dynamic");
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls.setName("DynamicEClass");
        ePkg.getEClassifiers().add((Object)eCls);
        EOperation eOperation = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        eOperation.setName("dynamicEOperation");
        eOperation.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eCls.getEOperations().add((Object)eOperation);
        this.queryEnvironment.registerEPackage(ePkg);
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)eCls));
        types.put("self", selfType);
        Set oldSelfType = this.variableTypes.put("self", selfType);
        IValidationResult validationResult = this.engine.validate("self.dynamicEOperation()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        this.queryEnvironment.removeEPackage(ePkg);
        this.variableTypes.put("self", oldSelfType);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void allInstancesTestNoRootProvider() {
        IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        queryEnvironment.registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        queryEnvironment.registerEPackage((EPackage)NooperationreflectionPackage.eINSTANCE);
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, EObjectServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        QueryValidationEngine engine = new QueryValidationEngine((IReadOnlyQueryEnvironment)queryEnvironment);
        IValidationResult validationResult = engine.validate("ecore::EPackage.allInstances()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        ValidationTest.assertNothingType("Nothing will be left after calling allInstances:\nNo IRootEObjectProvider registered", ((SequenceType)possibleType).getCollectionType());
        ValidationTest.assertNothingType("Nothing will be left after calling allInstances:\nNo IRootEObjectProvider registered", ((SequenceType)possibleType).getCollectionType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling allInstances:\nNo IRootEObjectProvider registered", 15, 30);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling allInstances:\nNo IRootEObjectProvider registered", 15, 30);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void allInstancesTest() {
        IValidationResult validationResult = this.engine.validate("ecore::EPackage.allInstances()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)((EClassifierType)((SequenceType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void allInstancesSetTest() {
        IValidationResult validationResult = this.engine.validate("{ecore::EPackage | ecore::EClass}->allInstances()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)((EClassifierType)((SequenceType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SequenceType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    @Test
    public void bug152() {
        IValidationResult validationResult = this.engine.validate("Sequence{'1','2'}.toInteger()->first() > '1'.toInteger()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
    }

    public static void assertValidationMessage(IValidationMessage message, ValidationMessageLevel expectedLevel, String expectedMessage, int expectedStartPosition, int expectedEndPosition) {
        Assert.assertEquals((Object)expectedLevel, (Object)message.getLevel());
        Assert.assertEquals((Object)expectedMessage, (Object)ValidationTest.unifiedLines(message.getMessage()));
        Assert.assertEquals((long)expectedStartPosition, (long)message.getStartPosition());
        Assert.assertEquals((long)expectedEndPosition, (long)message.getEndPosition());
    }

    public List<IType> stripNothingTypes(Collection<IType> types) {
        ArrayList<IType> nothings = new ArrayList<IType>();
        Iterator<IType> typeItr = types.iterator();
        while (typeItr.hasNext()) {
            IType type = typeItr.next();
            if (!(type instanceof NothingType)) continue;
            nothings.add(type);
            typeItr.remove();
        }
        return nothings;
    }

    public static void assertNothingType(String expectedMessage, IType evaluated) {
        Assert.assertTrue((boolean)(evaluated instanceof NothingType));
        Assert.assertEquals((String)"Unexpected NothingType message", (Object)expectedMessage, (Object)ValidationTest.unifiedLines(((NothingType)evaluated).getMessage()));
    }

    public static String unifiedLines(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return text.replace(System.lineSeparator(), "\n");
    }
}

