/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.services.tests.AbstractServicesTest;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.acceleo.query.tests.anydsl.Caliber;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;

public class AnyServicesTest
extends AbstractServicesTest {
    private static final String LINE_SEP = System.getProperty("line.separator");
    public AnyServices any;

    @Override
    public void before() throws Exception {
        super.before();
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (Object)new AnyServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment()));
        ServiceUtils.registerServices((IQueryEnvironment)this.getQueryEnvironment(), (Set)services);
        this.any = new AnyServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment());
    }

    @Test
    public void equalsNullObject() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Assert.assertFalse((boolean)this.any.equals(null, new Object()));
    }

    @Test
    public void equalsObjectNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Assert.assertFalse((boolean)this.any.equals(new Object(), null));
    }

    @Test
    public void equalsNullNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Assert.assertTrue((boolean)this.any.equals(null, null));
    }

    @Test
    public void equalsObjectObject() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Assert.assertFalse((boolean)this.any.equals(new Object(), new Object()));
        Object obj = new Object();
        Assert.assertTrue((boolean)this.any.equals(obj, obj));
    }

    @Test
    public void differsNullObject() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Assert.assertTrue((boolean)this.any.differs(null, new Object()));
    }

    @Test
    public void differsObjectNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Assert.assertTrue((boolean)this.any.differs(new Object(), null));
    }

    @Test
    public void differsNullNull() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Assert.assertFalse((boolean)this.any.differs(null, null));
    }

    @Test
    public void differs() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Assert.assertTrue((boolean)this.any.differs((Object)"str1", (Object)"str2"));
        Object obj = new Object();
        Assert.assertFalse((boolean)this.any.differs(obj, obj));
    }

    @Test
    public void addStringObject() {
        Assert.assertEquals((Object)"test test", (Object)this.any.add("test ", (Object)new ObjectCustom()));
    }

    @Test
    public void addStringNullToString() {
        Assert.assertEquals((Object)"test ", (Object)this.any.add("test ", (Object)new ObjectCustomNullToString()));
    }

    @Test
    public void addStringNull() {
        Assert.assertEquals((Object)"test ", (Object)this.any.add("test ", null));
    }

    @Test
    public void addStringNothing() {
        Assert.assertEquals((Object)"test ", (Object)this.any.add("test ", (Object)new Nothing("whatever the message")));
    }

    @Test(expected=ClassCastException.class)
    public void oclAsTypeNullNull() {
        this.any.oclAsType(null, null);
    }

    @Test(expected=ClassCastException.class)
    public void oclAsTypeObjectNull() {
        Object self = new Object();
        this.any.oclAsType(self, null);
    }

    @Test
    public void oclAsTypeObjectClass() {
        Object self = new Object();
        Assert.assertEquals((Object)self, (Object)this.any.oclAsType(self, Object.class));
    }

    @Test
    public void oclAsTypeClass() {
        Object self = new Object();
        Assert.assertEquals((Object)self, (Object)this.any.oclAsType(self, Object.class));
    }

    @Test(expected=ClassCastException.class)
    public void oclAsTypeObjectToEClassClass() {
        Object self = new Object();
        this.any.oclAsType(self, EClass.class);
    }

    @Test
    public void oclAsTypeEClassToEClassClass() {
        EClass self = EcoreFactory.eINSTANCE.createEClass();
        Assert.assertEquals((Object)self, (Object)this.any.oclAsType((Object)self, EClass.class));
    }

    @Test(expected=ClassCastException.class)
    public void oclAsTypeObjectToEClassEClassifier() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Object self = new Object();
        this.any.oclAsType(self, (Object)EcorePackage.eINSTANCE.getEClass());
    }

    @Test
    public void oclAsTypeEclassToEClassEClassifier() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EClass self = EcoreFactory.eINSTANCE.createEClass();
        Assert.assertEquals((Object)self, (Object)this.any.oclAsType((Object)self, (Object)EcorePackage.eINSTANCE.getEClass()));
    }

    @Test
    public void oclAsTypeEclassToEClassEClassifierUnregistered() {
        EClass self = EcoreFactory.eINSTANCE.createEClass();
        Assert.assertEquals((Object)self, (Object)this.any.oclAsType((Object)self, (Object)EcorePackage.eINSTANCE.getEClass()));
    }

    @Test(expected=ClassCastException.class)
    public void oclAsTypeObjectToEClassifierUnregistered() {
        Object self = new Object();
        this.any.oclAsType(self, (Object)EcorePackage.eINSTANCE.getEClass());
    }

    @Test(expected=ClassCastException.class)
    public void oclAsTypeObjectToEInt() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Object self = new Object();
        this.any.oclAsType(self, (Object)EcorePackage.eINSTANCE.getEInt());
    }

    @Test(expected=ClassCastException.class)
    public void oclAsTypeObjectToEIntUnregistered() {
        Object self = new Object();
        this.any.oclAsType(self, (Object)EcorePackage.eINSTANCE.getEInt());
    }

    @Test
    public void oclAsTypeIntToObject() {
        Integer i = 1;
        Assert.assertEquals((Object)1, (Object)this.any.oclAsType((Object)i, Object.class));
    }

    @Test
    public void oclAsTypeIntToEInt() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Integer i = 1;
        Assert.assertEquals((Object)1, (Object)this.any.oclAsType((Object)i, (Object)EcorePackage.eINSTANCE.getEInt()));
    }

    @Test
    public void oclAsTypeIntToEIntUnregistered() {
        Integer i = 1;
        Assert.assertEquals((Object)1, (Object)this.any.oclAsType((Object)i, (Object)EcorePackage.eINSTANCE.getEInt()));
    }

    @Test
    public void oclAsTypeCompatibleClassifiers() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        Assert.assertEquals((Object)eClass, (Object)this.any.oclAsType((Object)eClass, (Object)EcorePackage.eINSTANCE.getEClass()));
    }

    @Test
    public void oclAsTypeCompatibleClassifiersUnregistered() {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        Assert.assertEquals((Object)eClass, (Object)this.any.oclAsType((Object)eClass, (Object)EcorePackage.eINSTANCE.getEClass()));
    }

    @Test(expected=ClassCastException.class)
    public void oclAsTypeIncompatibleTypes() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.any.oclAsType((Object)eClass, (Object)EcorePackage.eINSTANCE.getEPackage());
    }

    @Test(expected=ClassCastException.class)
    public void oclAsTypeIncompatibleTypesUnregistered() {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.any.oclAsType((Object)eClass, (Object)EcorePackage.eINSTANCE.getEPackage());
    }

    @Test
    public void addStringCollection() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("test");
        list.add(new ObjectCustom());
        list.add(new ObjectCustomNullToString());
        list.add(null);
        list.add(new Nothing("whatever the message"));
        ArrayList<String> subList = new ArrayList<String>();
        subList.add("test3");
        list.add(subList);
        Assert.assertEquals((Object)"test testtesttest3", (Object)this.any.add("test ", list));
    }

    @Test
    public void addStringStringObject() {
        Assert.assertEquals((Object)"test some string", (Object)this.any.add("test ", (Object)"some string"));
    }

    @Test
    public void addObjectString() {
        Assert.assertEquals((Object)"test test", (Object)this.any.add((Object)new ObjectCustom(), " test"));
    }

    @Test
    public void addNullToStringString() {
        Assert.assertEquals((Object)" test", (Object)this.any.add((Object)new ObjectCustomNullToString(), " test"));
    }

    @Test
    public void addNullString() {
        Assert.assertEquals((Object)" test", (Object)this.any.add(null, " test"));
    }

    @Test
    public void addNothingString() {
        Assert.assertEquals((Object)" test", (Object)this.any.add((Object)new Nothing("whatever the message"), " test"));
    }

    @Test
    public void addCollectionString() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("test");
        list.add(new ObjectCustom());
        list.add(new ObjectCustomNullToString());
        list.add(null);
        list.add(new Nothing("whatever the message"));
        ArrayList<String> subList = new ArrayList<String>();
        subList.add("test3");
        list.add(subList);
        Assert.assertEquals((Object)"testtesttest3 test", (Object)this.any.add(list, " test"));
    }

    @Test
    public void addStringObjectString() {
        Assert.assertEquals((Object)"some string test", (Object)this.any.add((Object)"some string", " test"));
    }

    @Test
    public void oclIsKindOfNullNull() {
        Assert.assertFalse((boolean)this.any.oclIsKindOf(null, null));
    }

    @Test
    public void oclIsKindOfNullEClassNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsKindOf(null, (Object)EcorePackage.eINSTANCE.getEClass()));
    }

    @Test
    public void oclIsKindOfNullEClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsKindOf(null, (Object)EcorePackage.eINSTANCE.getEClass()));
    }

    @Test
    public void oclIsKindOfNullEEnumNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsKindOf(null, (Object)AnydslPackage.eINSTANCE.getCaliber()));
    }

    @Test
    public void oclIsKindOfNullEEnum() {
        this.getQueryEnvironment().registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsKindOf(null, (Object)AnydslPackage.eINSTANCE.getCaliber()));
    }

    @Test
    public void oclIsKindOfNullEDataTypeNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsKindOf(null, (Object)EcorePackage.eINSTANCE.getEString()));
    }

    @Test
    public void oclIsKindOfNullEDataType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsKindOf(null, (Object)EcorePackage.eINSTANCE.getEString()));
    }

    @Test
    public void oclIsKindOfObjectObject() {
        Assert.assertFalse((boolean)this.any.oclIsKindOf(new Object(), null));
    }

    @Test
    public void oclIsKindOfObjectEClassNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsKindOf(new Object(), (Object)EcorePackage.eINSTANCE.getEClass()));
        Assert.assertTrue((boolean)this.any.oclIsKindOf((Object)EcorePackage.eINSTANCE.getEClass(), (Object)EcorePackage.eINSTANCE.getEClass()));
        Assert.assertTrue((boolean)this.any.oclIsKindOf((Object)EcorePackage.eINSTANCE.getEClass(), (Object)EcorePackage.eINSTANCE.getEClassifier()));
    }

    @Test
    public void oclIsKindOfObjectEClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsKindOf(new Object(), (Object)EcorePackage.eINSTANCE.getEClass()));
        Assert.assertTrue((boolean)this.any.oclIsKindOf((Object)EcorePackage.eINSTANCE.getEClass(), (Object)EcorePackage.eINSTANCE.getEClass()));
        Assert.assertTrue((boolean)this.any.oclIsKindOf((Object)EcorePackage.eINSTANCE.getEClass(), (Object)EcorePackage.eINSTANCE.getEClassifier()));
    }

    @Test
    public void oclIsKindOfObjectEEnumNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsKindOf(new Object(), (Object)AnydslPackage.eINSTANCE.getCaliber()));
        Assert.assertTrue((boolean)this.any.oclIsKindOf((Object)Caliber.L, (Object)AnydslPackage.eINSTANCE.getCaliber()));
    }

    @Test
    public void oclIsKindOfObjectEEnum() {
        this.getQueryEnvironment().registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsKindOf(new Object(), (Object)AnydslPackage.eINSTANCE.getCaliber()));
        Assert.assertTrue((boolean)this.any.oclIsKindOf((Object)Caliber.L, (Object)AnydslPackage.eINSTANCE.getCaliber()));
    }

    @Test
    public void oclIsKindOfObjectEDataTypeNotRegistered_Object() {
        Assert.assertFalse((boolean)this.any.oclIsKindOf(new Object(), (Object)EcorePackage.eINSTANCE.getEString()));
        Assert.assertTrue((boolean)this.any.oclIsKindOf((Object)"a string", (Object)EcorePackage.eINSTANCE.getEString()));
    }

    @Test
    public void oclIsKindOfObjectEDataType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsKindOf(new Object(), (Object)EcorePackage.eINSTANCE.getEString()));
        Assert.assertTrue((boolean)this.any.oclIsKindOf((Object)"a string", (Object)EcorePackage.eINSTANCE.getEString()));
    }

    @Test
    public void oclIsKindOfObjectEDataType_Primitive() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsKindOf(new Object(), (Object)EcorePackage.eINSTANCE.getEBoolean()));
        Assert.assertTrue((boolean)this.any.oclIsKindOf((Object)true, (Object)EcorePackage.eINSTANCE.getEBoolean()));
    }

    @Test
    public void oclIsTypeOfNullNull() {
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(null, null));
    }

    @Test
    public void oclIsTypeOfNullEClassNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(null, (Object)EcorePackage.eINSTANCE.getEClass()));
    }

    @Test
    public void oclIsTypeOfNullEClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(null, (Object)EcorePackage.eINSTANCE.getEClass()));
    }

    @Test
    public void oclIsTypeOfNullEEnumNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(null, (Object)AnydslPackage.eINSTANCE.getCaliber()));
    }

    @Test
    public void oclIsTypeOfNullEEnum() {
        this.getQueryEnvironment().registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(null, (Object)AnydslPackage.eINSTANCE.getCaliber()));
    }

    @Test
    public void oclIsTypeOfNullEDataTypeNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(null, (Object)EcorePackage.eINSTANCE.getEString()));
    }

    @Test
    public void oclIsTypeOfNullEDataType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(null, (Object)EcorePackage.eINSTANCE.getEString()));
    }

    @Test
    public void oclIsTypeOfObjectObject() {
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(new Object(), null));
    }

    @Test
    public void oclIsTypeOfObjectEClassNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(new Object(), (Object)EcorePackage.eINSTANCE.getEClass()));
        Assert.assertTrue((boolean)this.any.oclIsTypeOf((Object)EcorePackage.eINSTANCE.getEClass(), (Object)EcorePackage.eINSTANCE.getEClass()));
        Assert.assertFalse((boolean)this.any.oclIsTypeOf((Object)EcorePackage.eINSTANCE.getEClass(), (Object)EcorePackage.eINSTANCE.getEClassifier()));
    }

    @Test
    public void oclIsTypeOfObjectEClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(new Object(), (Object)EcorePackage.eINSTANCE.getEClass()));
        Assert.assertTrue((boolean)this.any.oclIsTypeOf((Object)EcorePackage.eINSTANCE.getEClass(), (Object)EcorePackage.eINSTANCE.getEClass()));
        Assert.assertFalse((boolean)this.any.oclIsTypeOf((Object)EcorePackage.eINSTANCE.getEClass(), (Object)EcorePackage.eINSTANCE.getEClassifier()));
    }

    @Test
    public void oclIsTypeOfObjectEEnumNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(new Object(), (Object)AnydslPackage.eINSTANCE.getCaliber()));
        Assert.assertTrue((boolean)this.any.oclIsTypeOf((Object)Caliber.L, (Object)AnydslPackage.eINSTANCE.getCaliber()));
    }

    @Test
    public void oclIsTypeOfObjectEEnum() {
        this.getQueryEnvironment().registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(new Object(), (Object)AnydslPackage.eINSTANCE.getCaliber()));
        Assert.assertTrue((boolean)this.any.oclIsTypeOf((Object)Caliber.L, (Object)AnydslPackage.eINSTANCE.getCaliber()));
    }

    @Test
    public void oclIsTypeOfObjectEDataTypeNotRegistered() {
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(new Object(), (Object)EcorePackage.eINSTANCE.getEString()));
        Assert.assertTrue((boolean)this.any.oclIsTypeOf((Object)"a string", (Object)EcorePackage.eINSTANCE.getEString()));
    }

    @Test
    public void oclIsTypeOfObjectEDataType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        Assert.assertFalse((boolean)this.any.oclIsTypeOf(new Object(), (Object)EcorePackage.eINSTANCE.getEString()));
        Assert.assertTrue((boolean)this.any.oclIsTypeOf((Object)"a string", (Object)EcorePackage.eINSTANCE.getEString()));
    }

    @Test
    public void toStringObject() {
        Assert.assertEquals((Object)"test", (Object)this.any.toString((Object)new ObjectCustom()));
    }

    @Test
    public void toStringNullToString() {
        Assert.assertEquals((Object)"", (Object)this.any.toString((Object)new ObjectCustomNullToString()));
    }

    @Test
    public void toStringNull() {
        Assert.assertEquals((Object)"", (Object)this.any.toString(null));
    }

    @Test
    public void testToStringNothing() {
        Assert.assertEquals((Object)"", (Object)this.any.toString((Object)new Nothing("whatever the message")));
    }

    @Test
    public void toStringCollection() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("test");
        list.add(new ObjectCustom());
        list.add(new ObjectCustomNullToString());
        list.add(null);
        list.add(new Nothing("whatever the message"));
        ArrayList<String> subList = new ArrayList<String>();
        subList.add("test3");
        list.add(subList);
        Assert.assertEquals((Object)"testtesttest3", (Object)this.any.toString(list));
    }

    @Test
    public void toStringString() {
        Assert.assertEquals((Object)"some string", (Object)this.any.toString((Object)"some string"));
    }

    @Test
    public void trace() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        String result = this.any.trace((Object)42);
        Assert.assertTrue((boolean)result.contains("Metamodels:" + LINE_SEP + "\thttp://www.eclipse.org/emf/2002/Ecore" + LINE_SEP));
        Assert.assertTrue((boolean)result.contains("Services:" + LINE_SEP));
        Assert.assertTrue((boolean)result.contains("\t\tpublic java.lang.Boolean org.eclipse.acceleo.query.services.AnyServices.differs(java.lang.Object,java.lang.Object)" + LINE_SEP));
        Assert.assertTrue((boolean)result.contains("receiver: 42" + LINE_SEP));
    }

    private class ObjectCustom {
        private ObjectCustom() {
        }

        public String toString() {
            return "test";
        }
    }

    private class ObjectCustomNullToString {
        private ObjectCustomNullToString() {
        }

        public String toString() {
            return null;
        }
    }
}

