/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.validation.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TypeTests {
    private IQueryEnvironment queryEnvironment;
    private Map<TypeVariants, Set<TypeVariants>> wideningConversions;
    private Map<TypeVariants, Set<TypeVariants>> narrowingConversions;
    private TypeVariants byteVariants;
    private TypeVariants shortVariants;
    private TypeVariants charVariants;
    private TypeVariants integerVariants;
    private TypeVariants longVariants;
    private TypeVariants floatVariants;
    private TypeVariants doubleVariants;
    private TypeVariants booleanVariants;
    private Set<TypeVariants> allPrimitiveVariants;

    @Before
    public void before() throws Exception {
        this.queryEnvironment = Query.newEnvironment();
        this.byteVariants = new TypeVariants(new IType[]{this.classType(Byte.TYPE), this.classType(Byte.class)});
        this.shortVariants = new TypeVariants(new IType[]{this.classType(Short.TYPE), this.classType(Short.class)});
        this.charVariants = new TypeVariants(new IType[]{this.classType(Character.TYPE), this.classType(Character.class)});
        this.integerVariants = new TypeVariants(new IType[]{this.classType(Integer.TYPE), this.classType(Integer.class)});
        this.longVariants = new TypeVariants(new IType[]{this.classType(Long.TYPE), this.classType(Long.class)});
        this.floatVariants = new TypeVariants(new IType[]{this.classType(Float.TYPE), this.classType(Float.class)});
        this.doubleVariants = new TypeVariants(new IType[]{this.classType(Double.TYPE), this.classType(Double.class)});
        this.booleanVariants = new TypeVariants(new IType[]{this.classType(Boolean.TYPE), this.classType(Boolean.class)});
        this.allPrimitiveVariants = new HashSet<TypeVariants>();
        this.allPrimitiveVariants.add(this.byteVariants);
        this.allPrimitiveVariants.add(this.shortVariants);
        this.allPrimitiveVariants.add(this.charVariants);
        this.allPrimitiveVariants.add(this.integerVariants);
        this.allPrimitiveVariants.add(this.longVariants);
        this.allPrimitiveVariants.add(this.floatVariants);
        this.allPrimitiveVariants.add(this.doubleVariants);
        this.allPrimitiveVariants.add(this.booleanVariants);
        this.wideningConversions = new HashMap<TypeVariants, Set<TypeVariants>>();
        this.wideningConversions.put(this.byteVariants, TypeTests.newSet(this.shortVariants, this.integerVariants, this.longVariants, this.floatVariants, this.doubleVariants));
        this.wideningConversions.put(this.shortVariants, TypeTests.newSet(this.integerVariants, this.longVariants, this.floatVariants, this.doubleVariants));
        this.wideningConversions.put(this.charVariants, TypeTests.newSet(this.integerVariants, this.longVariants, this.floatVariants, this.doubleVariants));
        this.wideningConversions.put(this.integerVariants, TypeTests.newSet(this.longVariants, this.floatVariants, this.doubleVariants));
        this.wideningConversions.put(this.longVariants, TypeTests.newSet(this.floatVariants, this.doubleVariants));
        this.wideningConversions.put(this.floatVariants, TypeTests.newSet(this.doubleVariants));
        this.narrowingConversions = new HashMap<TypeVariants, Set<TypeVariants>>();
        this.narrowingConversions.put(this.shortVariants, TypeTests.newSet(this.byteVariants, this.charVariants));
        this.narrowingConversions.put(this.charVariants, TypeTests.newSet(this.byteVariants, this.shortVariants));
        this.narrowingConversions.put(this.integerVariants, TypeTests.newSet(this.byteVariants, this.shortVariants, this.charVariants));
        this.narrowingConversions.put(this.longVariants, TypeTests.newSet(this.byteVariants, this.shortVariants, this.charVariants, this.integerVariants));
        this.narrowingConversions.put(this.floatVariants, TypeTests.newSet(this.byteVariants, this.shortVariants, this.charVariants, this.integerVariants, this.longVariants));
        this.narrowingConversions.put(this.doubleVariants, TypeTests.newSet(this.byteVariants, this.shortVariants, this.charVariants, this.integerVariants, this.longVariants, this.floatVariants));
    }

    private void addEcoreDataTypesAndClassifiersToVariants() {
        this.byteVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEByte())});
        this.byteVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEByteObject())});
        this.shortVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEShort())});
        this.shortVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEShortObject())});
        this.charVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEChar())});
        this.charVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getECharacterObject())});
        this.integerVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEInt())});
        this.integerVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject())});
        this.longVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getELong())});
        this.longVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getELongObject())});
        this.floatVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEFloat())});
        this.floatVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEFloatObject())});
        this.doubleVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEDouble())});
        this.doubleVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject())});
        this.booleanVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBoolean())});
        this.booleanVariants.addVariations(new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject())});
    }

    @Test
    public void testVariantsAssignableToEachOther() {
        for (TypeVariants variant : this.allPrimitiveVariants) {
            for (IType fromType : variant.getVariants()) {
                HashSet<IType> others = new HashSet<IType>(variant.getVariants());
                others.remove(fromType);
                for (IType toType : others) {
                    Assert.assertTrue((String)(String.valueOf(toType.getType()) + " should have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom(fromType));
                }
            }
        }
    }

    @Test
    public void testVariantsAssignableToEachOtherWithEcore() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testVariantsAssignableToEachOther();
    }

    @Test
    public void testVariantsAssignableToEachOtherWithUnregisteredEcore() {
        this.addEcoreDataTypesAndClassifiersToVariants();
        for (TypeVariants variant : this.allPrimitiveVariants) {
            for (IType fromType : variant.getVariants()) {
                HashSet<IType> others = new HashSet<IType>(variant.getVariants());
                others.remove(fromType);
                for (IType toType : others) {
                    if (toType instanceof EClassifierType || fromType instanceof EClassifierType) {
                        Assert.assertFalse((String)(String.valueOf(toType.getType()) + " should not have been assignable from " + String.valueOf(fromType.getType()) + " as ecore is not registered in the environment."), (boolean)toType.isAssignableFrom(fromType));
                        continue;
                    }
                    Assert.assertTrue((String)(String.valueOf(toType.getType()) + " should have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom(fromType));
                }
            }
        }
    }

    @Test
    public void testNarrowingConversions() {
        for (Map.Entry<TypeVariants, Set<TypeVariants>> entry : this.narrowingConversions.entrySet()) {
            for (IType fromType : entry.getKey().getVariants()) {
                Assert.assertFalse((boolean)entry.getValue().isEmpty());
                for (TypeVariants toVariant : entry.getValue()) {
                    Assert.assertFalse((boolean)toVariant.getVariants().isEmpty());
                    for (IType toType : toVariant.getVariants()) {
                        Assert.assertFalse((String)(String.valueOf(toType.getType()) + " should not have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom(fromType));
                    }
                }
            }
        }
    }

    @Test
    public void testNarrowingConversionsWithEcore() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testNarrowingConversions();
    }

    @Test
    public void testNarrowingConversionsWithUnregisteredEcore() {
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testNarrowingConversions();
    }

    @Test
    public void testAssignableFromBoolean() {
        for (TypeVariants toVariant : this.allPrimitiveVariants) {
            if (this.booleanVariants == toVariant) continue;
            for (IType fromType : this.booleanVariants.getVariants()) {
                for (IType toType : toVariant.getVariants()) {
                    Assert.assertFalse((String)(String.valueOf(toType.getType()) + " should not have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom(fromType));
                }
            }
        }
    }

    @Test
    public void testAssignableFromBooleanWithEcore() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testAssignableFromBoolean();
    }

    @Test
    public void testAssignableFromBooleanWithUnregisteredEcore() {
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testAssignableFromBoolean();
    }

    @Test
    public void testAssignableToBoolean() {
        for (TypeVariants fromVariant : this.allPrimitiveVariants) {
            if (this.booleanVariants == fromVariant) continue;
            for (IType toType : this.booleanVariants.getVariants()) {
                for (IType fromType : fromVariant.getVariants()) {
                    Assert.assertFalse((String)(String.valueOf(toType.getType()) + " should not have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom(fromType));
                }
            }
        }
    }

    @Test
    public void testAssignableToBooleanWithEcore() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testAssignableToBoolean();
    }

    @Test
    public void testAssignableToBooleanWithUnregisteredEcore() {
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testAssignableToBoolean();
    }

    @Test
    public void testAssignableFromPrimitiveToEClass() {
        EClassifierType toType = this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass());
        for (TypeVariants primitive : this.allPrimitiveVariants) {
            for (IType fromType : primitive.getVariants()) {
                Assert.assertFalse((String)(String.valueOf(toType.getType()) + " should not have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom(fromType));
            }
        }
    }

    @Test
    public void testAssignableFromPrimitiveToEClassWithEcore() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testAssignableFromPrimitiveToEClass();
    }

    @Test
    public void testAssignableFromPrimitiveToEClassWithUnregisteredEcore() {
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testAssignableFromPrimitiveToEClass();
    }

    @Test
    public void testAssignableFromEClassToPrimitive() {
        EClassifierType fromType = this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass());
        for (TypeVariants primitive : this.allPrimitiveVariants) {
            for (IType toType : primitive.getVariants()) {
                Assert.assertFalse((String)(String.valueOf(toType.getType()) + " should not have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom((IType)fromType));
            }
        }
    }

    @Test
    public void testAssignableFromEClassToPrimitiveWithEcore() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testAssignableFromEClassToPrimitive();
    }

    @Test
    public void testAssignableFromEClassToPrimitiveWithUnregisteredEcore() {
        this.addEcoreDataTypesAndClassifiersToVariants();
        this.testAssignableFromEClassToPrimitive();
    }

    @Test
    public void testAssignableFromEClassAndEPackage() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EClassifierType eClass = this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass());
        EClassifierType ePackage = this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage());
        Assert.assertFalse((boolean)eClass.isAssignableFrom((IType)ePackage));
        Assert.assertFalse((boolean)ePackage.isAssignableFrom((IType)eClass));
        Assert.assertTrue((boolean)eClass.isAssignableFrom((IType)eClass));
        Assert.assertTrue((boolean)ePackage.isAssignableFrom((IType)ePackage));
    }

    @Test
    public void testAssignableFromEClassAndEPackageUnregistered() {
        EClassifierType eClass = this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass());
        EClassifierType ePackage = this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage());
        Assert.assertFalse((boolean)eClass.isAssignableFrom((IType)ePackage));
        Assert.assertFalse((boolean)ePackage.isAssignableFrom((IType)eClass));
        Assert.assertFalse((boolean)eClass.isAssignableFrom((IType)eClass));
        Assert.assertFalse((boolean)ePackage.isAssignableFrom((IType)ePackage));
    }

    @Test
    public void testAssignableFromUniversalObject() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        ClassType universal = this.classType(Object.class);
        EClassifierType ePackage = this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage());
        EClassifierType eClass = this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass());
        ClassType otherUniversalInstance = this.classType(Object.class);
        Assert.assertFalse((boolean)ePackage.isAssignableFrom((IType)universal));
        Assert.assertTrue((boolean)universal.isAssignableFrom((IType)ePackage));
        Assert.assertFalse((boolean)eClass.isAssignableFrom((IType)universal));
        Assert.assertTrue((boolean)universal.isAssignableFrom((IType)eClass));
        Assert.assertTrue((boolean)otherUniversalInstance.isAssignableFrom((IType)universal));
        for (TypeVariants primitiveVariants : this.allPrimitiveVariants) {
            for (IType variant : primitiveVariants.getVariants()) {
                Assert.assertFalse((boolean)variant.isAssignableFrom((IType)universal));
                Assert.assertTrue((boolean)universal.isAssignableFrom(variant));
            }
        }
    }

    @Test
    public void testAssignableFromNullToEClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EClassifierType toType = this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass());
        ClassType fromType = this.classType(null);
        Assert.assertTrue((String)(String.valueOf(toType.getType()) + " should have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom((IType)fromType));
    }

    @Test
    public void testAssignableFromNullToObject() {
        ClassType toType = this.classType(Object.class);
        ClassType fromType = this.classType(null);
        Assert.assertTrue((String)(String.valueOf(toType.getType()) + " should have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom((IType)fromType));
    }

    @Test
    public void testAssignableFromEClassToNull() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        ClassType toType = this.classType(null);
        EClassifierType fromType = this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass());
        Assert.assertFalse((String)(String.valueOf(toType.getType()) + " should not have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom((IType)fromType));
    }

    @Test
    public void testAssignableFromObjectToNull() {
        ClassType toType = this.classType(null);
        ClassType fromType = this.classType(Object.class);
        Assert.assertFalse((String)(String.valueOf(toType.getType()) + " should not have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom((IType)fromType));
    }

    @Test
    public void testAssignableFromNullToNull() {
        ClassType toType = this.classType(null);
        ClassType fromType = this.classType(null);
        Assert.assertFalse((String)(String.valueOf(toType.getType()) + " should not have been assignable from " + String.valueOf(fromType.getType())), (boolean)toType.isAssignableFrom((IType)fromType));
    }

    @Test
    public void collectionTypeAssignable() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        SequenceType sequenceEClassifier = new SequenceType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (IType)new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEClassifier()));
        SequenceType sequenceEClass = new SequenceType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (IType)new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        SetType setEClassifier = new SetType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (IType)new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEClassifier()));
        SetType setEClass = new SetType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (IType)new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        ClassType javaList = new ClassType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), List.class);
        ClassType javaSet = new ClassType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), Set.class);
        Assert.assertEquals((Object)true, (Object)sequenceEClassifier.isAssignableFrom((IType)sequenceEClassifier));
        Assert.assertEquals((Object)true, (Object)sequenceEClassifier.isAssignableFrom((IType)sequenceEClass));
        Assert.assertEquals((Object)false, (Object)sequenceEClass.isAssignableFrom((IType)sequenceEClassifier));
        Assert.assertEquals((Object)true, (Object)sequenceEClass.isAssignableFrom((IType)javaList));
        Assert.assertEquals((Object)false, (Object)sequenceEClass.isAssignableFrom((IType)javaSet));
        Assert.assertEquals((Object)true, (Object)setEClassifier.isAssignableFrom((IType)setEClassifier));
        Assert.assertEquals((Object)true, (Object)setEClassifier.isAssignableFrom((IType)setEClass));
        Assert.assertEquals((Object)false, (Object)setEClass.isAssignableFrom((IType)setEClassifier));
        Assert.assertEquals((Object)false, (Object)setEClass.isAssignableFrom((IType)javaList));
        Assert.assertEquals((Object)true, (Object)setEClass.isAssignableFrom((IType)javaSet));
        Assert.assertEquals((Object)false, (Object)sequenceEClassifier.isAssignableFrom((IType)setEClassifier));
        Assert.assertEquals((Object)false, (Object)setEClassifier.isAssignableFrom((IType)sequenceEClassifier));
        Assert.assertEquals((Object)true, (Object)javaList.isAssignableFrom((IType)sequenceEClassifier));
        Assert.assertEquals((Object)true, (Object)javaList.isAssignableFrom((IType)sequenceEClass));
        Assert.assertEquals((Object)true, (Object)javaSet.isAssignableFrom((IType)setEClassifier));
        Assert.assertEquals((Object)true, (Object)javaSet.isAssignableFrom((IType)setEClass));
    }

    protected IQueryEnvironment getQueryEnvironment() {
        return this.queryEnvironment;
    }

    protected ClassType classType(Class<?> cls) {
        return new ClassType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), cls);
    }

    protected EClassifierType eClassifierType(EClassifier eClassifier) {
        return new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), eClassifier);
    }

    private static <T> Set<T> newSet(T ... elements) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.addAll(Arrays.asList(elements));
        return set;
    }

    private static class TypeVariants {
        private Set<IType> variants = new HashSet<IType>();

        public TypeVariants(IType ... variants) {
            this.variants.addAll(Arrays.asList(variants));
        }

        public void addVariations(IType ... newVariants) {
            this.variants.addAll(Arrays.asList(newVariants));
        }

        public Set<IType> getVariants() {
            return this.variants;
        }
    }
}

