/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.anydsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Part implements Enumerator
{
    OTHER(0, "Other", "Other"),
    MUSCLE(1, "Muscle", "Muscle"),
    ORGAN(2, "Organ", "Organ");

    public static final int OTHER_VALUE = 0;
    public static final int MUSCLE_VALUE = 1;
    public static final int ORGAN_VALUE = 2;
    private static final Part[] VALUES_ARRAY;
    public static final List<Part> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Part[]{OTHER, MUSCLE, ORGAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Part get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Part result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Part getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Part result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Part get(int value) {
        switch (value) {
            case 0: {
                return OTHER;
            }
            case 1: {
                return MUSCLE;
            }
            case 2: {
                return ORGAN;
            }
        }
        return null;
    }

    private Part(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

