/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation.strategy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.strategy.IWriterFactory;
import org.eclipse.acceleo.aql.evaluation.writer.AbstractAcceleoWriter;
import org.eclipse.acceleo.aql.evaluation.writer.AcceleoFileWriter;
import org.eclipse.acceleo.aql.evaluation.writer.AcceleoURIWriter;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public class DefaultWriterFactory
implements IWriterFactory {
    private static final Map<String, Object> EMPTY_OPTION_MAP = Collections.emptyMap();

    @Override
    public IAcceleoWriter createWriter(OpenModeKind openModeKind, URI uri, URIConverter uriConverter, Charset charset, String lineDelimiter) throws IOException {
        AbstractAcceleoWriter res;
        switch (openModeKind) {
            case APPEND: {
                boolean exists = uriConverter.exists(uri, EMPTY_OPTION_MAP);
                String fileString = uri.toFileString();
                if (fileString != null) {
                    res = new AcceleoFileWriter(new File(fileString), charset, true);
                    break;
                }
                res = new AcceleoURIWriter(uri, uriConverter, charset);
                if (!exists) break;
                Throwable throwable = null;
                Object var10_11 = null;
                try (InputStream contentInputStream = uriConverter.createInputStream(uri);){
                    String content = AcceleoUtil.getContent(contentInputStream, charset.name());
                    res.append(content);
                    break;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            default: {
                res = new AcceleoURIWriter(uri, uriConverter, charset);
            }
        }
        return res;
    }
}

