/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.validation.quickfixes;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoAstSerializer;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.parser.quickfixes.AstQuickFix;
import org.eclipse.acceleo.query.parser.quickfixes.AstTextReplacement;
import org.eclipse.acceleo.query.parser.quickfixes.CreateResource;
import org.eclipse.acceleo.query.parser.quickfixes.IAstQuickFix;
import org.eclipse.acceleo.query.parser.quickfixes.MoveResource;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModuleQuickFixesSwitch
extends AcceleoSwitch<List<IAstQuickFix>> {
    private final IQualifiedNameQueryEnvironment queryEnvironment;
    private IAcceleoValidationResult validationResult;
    private final Module module;
    private String moduleQualifiedName;
    private String moduleText;
    final int[][] linesAndColumns;
    private final URI uri;
    private final String newLine;

    public ModuleQuickFixesSwitch(IQualifiedNameQueryEnvironment queryEnvironment, IAcceleoValidationResult validationResult, String moduleQualifiedName, String moduleText, String newLine) {
        this.queryEnvironment = queryEnvironment;
        this.validationResult = validationResult;
        this.module = validationResult.getAcceleoAstResult().getModule();
        this.moduleQualifiedName = moduleQualifiedName;
        this.moduleText = moduleText;
        this.linesAndColumns = AQLUtils.getLinesAndColumns((String)moduleText);
        this.newLine = newLine;
        IQualifiedNameResolver resolver = queryEnvironment.getLookupEngine().getResolver();
        this.uri = resolver.getSourceURI(moduleQualifiedName);
    }

    @Override
    public List<IAstQuickFix> caseModule(Module object) {
        ArrayList<IAstQuickFix> res = new ArrayList<IAstQuickFix>();
        if (this.needRename(this.module)) {
            String lastSegment;
            String newModuleName;
            String[] segments = this.uri.getPath().split("/");
            if (segments.length > 0 && this.isJavaIdentifier(newModuleName = (lastSegment = segments[segments.length - 1]).substring(0, lastSegment.length() - "mtl".length() - 1))) {
                res.add(this.getRenameModuleQuickFix(this.uri, this.module, newModuleName));
            }
            res.add(this.getRenameModuleResourceQuickFix(this.uri, this.module));
        }
        return res;
    }

    private boolean needRename(Module module) {
        return this.validationResult.getValidationMessages(module).stream().anyMatch(m -> m.getMessage().contains(" doesn't match resource name "));
    }

    private boolean isJavaIdentifier(String name) {
        boolean res;
        if (name != null && !name.isBlank()) {
            char[] chars = name.toCharArray();
            if (Character.isJavaIdentifierStart(chars[0])) {
                boolean hasNotIdentifierPart = false;
                int i = 1;
                while (i < chars.length) {
                    if (!Character.isJavaIdentifierPart(chars[i])) {
                        hasNotIdentifierPart = true;
                        break;
                    }
                    ++i;
                }
                res = !hasNotIdentifierPart;
            } else {
                res = false;
            }
        } else {
            res = false;
        }
        return res;
    }

    private IAstQuickFix getRenameModuleQuickFix(URI uri, Module module, String newModuleName) {
        AstQuickFix res = new AstQuickFix("Rename module " + module.getName() + " to " + newModuleName);
        AcceleoAstResult acceleoAstResult = this.validationResult.getAcceleoAstResult();
        int startOffset = acceleoAstResult.getIdentifierStartPosition(module);
        int startLine = acceleoAstResult.getIdentifierStartLine(module);
        int startColumn = acceleoAstResult.getIdentifierStartColumn(module);
        int endOffset = acceleoAstResult.getIdentifierEndPosition(module);
        int endLine = acceleoAstResult.getIdentifierEndLine(module);
        int endColumn = acceleoAstResult.getIdentifierEndColumn(module);
        res.getTextReplacements().add(new AstTextReplacement(uri, newModuleName, startOffset, startLine, startColumn, endOffset, endLine, endColumn));
        return res;
    }

    private IAstQuickFix getRenameModuleResourceQuickFix(URI uri, Module module) {
        URI newUri = uri.resolve(module.getName() + ".mtl");
        AstQuickFix res = new AstQuickFix("Rename module resource " + String.valueOf(uri) + " to " + String.valueOf(newUri));
        res.getResourceChanges().add(new MoveResource(uri, newUri));
        IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
        String oldQualifiedName = this.moduleQualifiedName;
        int lastIndexOfQualifierSeparator = oldQualifiedName.lastIndexOf("::");
        Object newQualifiedName = lastIndexOfQualifierSeparator >= 0 ? oldQualifiedName.substring(0, lastIndexOfQualifierSeparator) + "::" + module.getName() : module.getName();
        for (String dependent : resolver.getDependOn(oldQualifiedName)) {
            Object resolved = resolver.resolve(dependent);
            if (!(resolved instanceof Module)) continue;
            Module dependentModule = (Module)resolved;
            URI dependentModuleURI = resolver.getSourceURI(dependent);
            ArrayList<ModuleReference> dependentModuleReferences = new ArrayList<ModuleReference>();
            if (dependentModule.getExtends() != null) {
                dependentModuleReferences.add(dependentModule.getExtends());
            }
            for (Import imp : dependentModule.getImports()) {
                dependentModuleReferences.add(imp.getModule());
            }
            for (ModuleReference dependentModuleReference : dependentModuleReferences) {
                if (!oldQualifiedName.equals(dependentModuleReference.getQualifiedName())) continue;
                AcceleoAstResult acceleoAstResult = dependentModule.getAst();
                int startOffset = acceleoAstResult.getStartPosition(dependentModuleReference);
                int startLine = acceleoAstResult.getStartLine(dependentModuleReference);
                int startColumn = acceleoAstResult.getStartColumn(dependentModuleReference);
                int endOffset = acceleoAstResult.getEndPosition(dependentModuleReference);
                int endLine = acceleoAstResult.getEndLine(dependentModuleReference);
                int endColumn = acceleoAstResult.getEndColumn(dependentModuleReference);
                res.getTextReplacements().add(new AstTextReplacement(dependentModuleURI, (String)newQualifiedName, startOffset, startLine, startColumn, endOffset, endLine, endColumn));
            }
        }
        return res;
    }

    @Override
    public List<IAstQuickFix> caseModuleReference(ModuleReference moduleReference) {
        ArrayList<IAstQuickFix> res = new ArrayList<IAstQuickFix>();
        if (moduleReference.getQualifiedName() != null) {
            IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
            URI uri = resolver.getSourceURI(this.moduleQualifiedName);
            String pathFragment = this.moduleQualifiedName.replace("::", "/");
            URI baseURI = URI.create(uri.toString().substring(0, uri.toString().lastIndexOf(pathFragment)));
            if (this.isServiceQualifiedName(moduleReference.getQualifiedName())) {
                if (moduleReference.eContainingFeature() != AcceleoPackage.eINSTANCE.getModule_Extends()) {
                    res.add(this.getCreateClassQuickFix(baseURI, moduleReference));
                }
            } else {
                res.add(this.getCreateModuleQuickFix(baseURI, moduleReference));
            }
        }
        return res;
    }

    private boolean isServiceQualifiedName(String qualifiedName) {
        return qualifiedName.contains("::services::");
    }

    private IAstQuickFix getCreateModuleQuickFix(URI baseURI, ModuleReference moduleReference) {
        AstQuickFix fix = new AstQuickFix("Create Module");
        URI moduleURI = baseURI.resolve(moduleReference.getQualifiedName().replace("::", "/") + ".mtl");
        CreateResource createModule = new CreateResource(moduleURI);
        fix.getResourceChanges().add(createModule);
        Module newModule = AcceleoPackage.eINSTANCE.getAcceleoFactory().createModule();
        String moduleName = moduleReference.getQualifiedName().substring(moduleReference.getQualifiedName().lastIndexOf("::") + "::".length(), moduleReference.getQualifiedName().length());
        newModule.setName(moduleName);
        Collection metamodels = EcoreUtil.copyAll(this.module.getMetamodels());
        newModule.getMetamodels().addAll(metamodels);
        String replacement = new AcceleoAstSerializer(this.newLine).serialize(newModule);
        AstTextReplacement contentReplacement = new AstTextReplacement(moduleURI, replacement, 0, 0, 0, 0, 0, 0);
        fix.getTextReplacements().add(contentReplacement);
        return fix;
    }

    private IAstQuickFix getCreateClassQuickFix(URI baseURI, ModuleReference moduleReference) {
        AstQuickFix fix = new AstQuickFix("Create Class");
        URI classURI = baseURI.resolve(moduleReference.getQualifiedName().replace("::", "/") + ".java");
        CreateResource createClass = new CreateResource(classURI);
        fix.getResourceChanges().add(createClass);
        int lastQualifierSeparatorIndex = moduleReference.getQualifiedName().lastIndexOf("::");
        String packageName = moduleReference.getQualifiedName().substring(0, lastQualifierSeparatorIndex).replace("::", ".");
        String className = moduleReference.getQualifiedName().substring(lastQualifierSeparatorIndex + "::".length(), moduleReference.getQualifiedName().length());
        String replacement = "package " + packageName + ";" + this.newLine + this.newLine + "public class " + className + " {" + this.newLine + this.newLine + "}" + this.newLine;
        AstTextReplacement contentReplacement = new AstTextReplacement(classURI, replacement, 0, 0, 0, 0, 0, 0);
        fix.getTextReplacements().add(contentReplacement);
        return fix;
    }
}

