/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.module.services;

import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

public class Services {
    private static IQualifiedNameQueryEnvironment queryEnvironment;
    private static IQualifiedNameResolver workspaceResolver;

    public static void initialize(IQualifiedNameQueryEnvironment queryEnvironment, IQualifiedNameResolver workspaceResolver) {
        Services.queryEnvironment = queryEnvironment;
        Services.workspaceResolver = workspaceResolver;
    }

    public String getQualifiedName(Module module) {
        String tmpQualifiedName = module.eResource().getURI().toString();
        int firstSeparatorIndex = tmpQualifiedName.indexOf("::");
        String res = firstSeparatorIndex >= 0 ? tmpQualifiedName.substring(firstSeparatorIndex + "::".length()) : "";
        return res;
    }

    public String getJavaPackage(Module module) {
        String qualifiedName = this.getQualifiedName(module);
        int lastSeparatorIndex = qualifiedName.lastIndexOf("::");
        String res = lastSeparatorIndex >= 0 ? qualifiedName.substring(0, lastSeparatorIndex).replace("::", ".") : "";
        return res;
    }

    public String getUserName(Object object) {
        return System.getProperty("user.name");
    }

    public String getJavaImport(EPackage ePkg) {
        return "import " + ePkg.getClass().getInterfaces()[0].getCanonicalName() + ";";
    }

    public String getJavaInitialize(EPackage ePkg) {
        return ePkg.getClass().getInterfaces()[0].getSimpleName() + ".eINSTANCE.getName();";
    }

    public Set<EPackage> getAllEPackages(Module module) {
        return AcceleoUtil.getAllNeededEPackages((IQualifiedNameResolver)workspaceResolver, (Module)module);
    }

    public String getReceiverQualifiedClassName(Module module) {
        String res;
        List mains = AcceleoUtil.getMainTemplates((Module)module);
        if (!mains.isEmpty()) {
            Template main = (Template)mains.get(0);
            if (!main.getParameters().isEmpty()) {
                Variable receiver = (Variable)main.getParameters().get(0);
                if (receiver.getTypeAql() instanceof EClassifierTypeLiteral) {
                    EClassifierTypeLiteral type = (EClassifierTypeLiteral)receiver.getTypeAql();
                    EClassifier eClassifier = (EClassifier)queryEnvironment.getEPackageProvider().getTypes(type.getEPackageName(), type.getEClassifierName()).iterator().next();
                    res = eClassifier.getInstanceClassName();
                } else {
                    res = "";
                }
            } else {
                res = "";
            }
        } else {
            res = "";
        }
        return res;
    }

    public EClassifier getReceiverEClassifier(Module module) {
        EClassifier res;
        List mains = AcceleoUtil.getMainTemplates((Module)module);
        if (!mains.isEmpty()) {
            Template main = (Template)mains.get(0);
            if (!main.getParameters().isEmpty()) {
                Variable receiver = (Variable)main.getParameters().get(0);
                if (receiver.getTypeAql() instanceof EClassifierTypeLiteral) {
                    EClassifier eClassifier;
                    EClassifierTypeLiteral type = (EClassifierTypeLiteral)receiver.getTypeAql();
                    res = eClassifier = (EClassifier)queryEnvironment.getEPackageProvider().getTypes(type.getEPackageName(), type.getEClassifierName()).iterator().next();
                } else {
                    res = null;
                }
            } else {
                res = null;
            }
        } else {
            res = null;
        }
        return res;
    }

    public String getReceiverClassName(Module module) {
        String qualifiedClassName = this.getReceiverQualifiedClassName(module);
        int lastDotIndex = qualifiedClassName.lastIndexOf(".");
        String res = lastDotIndex >= 0 ? qualifiedClassName.substring(lastDotIndex + 1) : "";
        return res;
    }
}

