/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.namespace;

import java.util.Optional;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.impl.AbstractService;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;

public abstract class AbstractQualifiedNameService<O>
extends AbstractService<O> {
    private final String contextQualifiedName;
    private IQualifiedNameLookupEngine lookupEngine;

    protected AbstractQualifiedNameService(O serviceOrigin, IQualifiedNameLookupEngine lookupEngine, String contextQualifiedName) {
        super(serviceOrigin);
        this.lookupEngine = lookupEngine;
        this.contextQualifiedName = contextQualifiedName;
    }

    @Override
    public Object invoke(Object ... arguments) throws AcceleoQueryEvaluationException {
        Object result;
        this.startInvoke();
        try {
            result = super.invoke(arguments);
        }
        finally {
            this.endInvoke();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startInvoke() {
        String startQualifiedName = this.lookupEngine.getCurrentContext().getStartingQualifiedName();
        if (startQualifiedName != this.contextQualifiedName) {
            if (this.lookupEngine.isInExtends(startQualifiedName, this.contextQualifiedName)) {
                this.lookupEngine.pushContext(this.contextQualifiedName);
                return;
            } else {
                String currentQualifiedName = this.lookupEngine.getCurrentContext().peek();
                Optional<String> importedModule = this.lookupEngine.getImports(currentQualifiedName).stream().filter(imported -> this.lookupEngine.isInExtends((String)imported, this.contextQualifiedName)).findFirst();
                if (!importedModule.isPresent()) throw new IllegalStateException("The called service " + this.getLongSignature() + " was not imported nor extended from the current context: " + currentQualifiedName);
                this.lookupEngine.pushImportsContext(importedModule.get(), this.contextQualifiedName);
            }
            return;
        } else {
            this.lookupEngine.pushContext(this.contextQualifiedName);
        }
    }

    private void endInvoke() {
        this.lookupEngine.popContext(this.contextQualifiedName);
    }

    protected String getContextQualifiedName() {
        return this.contextQualifiedName;
    }

    protected IQualifiedNameLookupEngine getLookupEngine() {
        return this.lookupEngine;
    }
}

