/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.impl.completion.EFeatureCompletionProposal;
import org.eclipse.acceleo.query.services.EAllContentsService;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassImpl;

@ServiceProvider(value="Services available for EObjects")
public class EObjectServices
extends AbstractServiceProvider {
    private static final String ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S = "Only EClass can be contained into other EClasses not %s";
    private static final String S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S = "%s can't contain directly or indirectly %s";
    private static final String UNKNOWN_FEATURE = "Feature %s not found in EClass %s";
    private static final String NON_EOBJECT_FEATURE_ACCESS = "Attempt to access feature (%s) on a non ModelObject value (%s).";
    private static final String DON_T_KNOW_WHAT_TO_DO_WITH = "don't know what to do with ";
    private final CrossReferenceProvider crossReferencer;
    private final IRootEObjectProvider rootProvider;
    private final IReadOnlyQueryEnvironment queryEnvironment;

    public EObjectServices(IReadOnlyQueryEnvironment queryEnvironment, CrossReferenceProvider crossReferencer, IRootEObjectProvider rootProvider) {
        this.queryEnvironment = queryEnvironment;
        this.crossReferencer = crossReferencer;
        this.rootProvider = rootProvider;
    }

    @Override
    protected IService<Method> getService(Method publicMethod, boolean forWorkspace) {
        JavaMethodService result = "eContents".equals(publicMethod.getName()) ? new EContentsService(publicMethod, this, forWorkspace) : ("eAllContents".equals(publicMethod.getName()) ? new EAllContentsService(publicMethod, this, forWorkspace) : ("eContainer".equals(publicMethod.getName()) ? new EContainerService(publicMethod, this, forWorkspace) : ("eContainerOrSelf".equals(publicMethod.getName()) ? new EContainerOrSelfService(publicMethod, this, forWorkspace) : ("eInverse".equals(publicMethod.getName()) ? (publicMethod.getParameterTypes().length == 2 && publicMethod.getParameterTypes()[1] == String.class ? new EInverseService(publicMethod, this, 10, forWorkspace) : new EInverseService(publicMethod, this, forWorkspace)) : ("allInstances".equals(publicMethod.getName()) ? new AllInstancesService(publicMethod, this, forWorkspace) : ("aqlFeatureAccess".equals(publicMethod.getName()) ? new EObjectFeatureAccess(publicMethod, this, forWorkspace) : ("eGet".equals(publicMethod.getName()) ? new EGetService(publicMethod, this, forWorkspace) : new JavaMethodService(publicMethod, this, forWorkspace))))))));
        return result;
    }

    @Documentation(value="Returns a sequence of the EObjects recursively contained in the specified root eObject.", params={@Param(name="eObject", value="The root of the content tree")}, result="The recursive content of the specified eObject.", examples={@Example(expression="anEPackage.eAllContents()", result="Sequence{firstEClass, firstEAttribute, secondEClass, firstDataType}")})
    public List<EObject> eAllContents(EObject eObject) {
        ArrayList<EObject> res = new ArrayList<EObject>();
        TreeIterator it = eObject.eAllContents();
        while (it.hasNext()) {
            res.add((EObject)it.next());
        }
        return res;
    }

    @Documentation(value="Returns a sequence of the EObjects recursively contained in the specified root eObject and that are instances of the specified EClass", params={@Param(name="eObject", value="The root of the content tree"), @Param(name="type", value="The type used to select elements")}, result="The recursive content of the specified eObject.", examples={@Example(expression="anEPackage.eAllContents(ecore::EClass)", result="Sequence{firstEClass, secondEClass}")})
    public List<EObject> eAllContents(EObject eObject, EClass type) {
        if (type == EcorePackage.eINSTANCE.getEObject()) {
            return this.eAllContents(eObject);
        }
        LinkedHashSet<EClass> types = new LinkedHashSet<EClass>();
        types.add(type);
        return this.eAllContents(eObject, types);
    }

    @Documentation(value="Returns a sequence of the EObjects recursively contained in the specified root eObject and that are instances of the specified EClass", params={@Param(name="eObject", value="The root of the content tree"), @Param(name="types", value="The set of types used to select elements")}, result="The recursive content of the specified eObject.", examples={@Example(expression="anEPackage.eAllContents({ecore::EPackage | ecore::EClass})", result="Sequence{ePackage, eClass, ...}")})
    public List<EObject> eAllContents(EObject eObject, Set<EClass> types) {
        List<EObject> result;
        if (types != null) {
            LinkedHashSet<EStructuralFeature> features = new LinkedHashSet<EStructuralFeature>();
            for (EClass type : types) {
                features.addAll(this.queryEnvironment.getEPackageProvider().getAllContainingEStructuralFeatures(type));
            }
            result = this.eAllContents(eObject, types, features);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<EObject> eAllContents(EObject eObject, Set<EClass> types, Set<EStructuralFeature> features) {
        ArrayList<EObject> allChildrens = new ArrayList<EObject>();
        if (eObject == null) {
            throw new NullPointerException();
        }
        if (!features.isEmpty()) {
            FilteredContentIterator treeIterator = new FilteredContentIterator(eObject, false, features);
            while (treeIterator.hasNext()) {
                EObject child = (EObject)treeIterator.next();
                if (!this.eIsInstanceOf(child, types)) continue;
                allChildrens.add(child);
            }
        }
        return allChildrens;
    }

    private boolean eIsInstanceOf(EObject value, Set<EClass> types) {
        for (EClass type : types) {
            if (!type.isSuperTypeOf(value.eClass()) && !type.isInstance((Object)value)) continue;
            return true;
        }
        return false;
    }

    @Documentation(value="Returns the contents of the specified EObject instance.", params={@Param(name="eObject", value="The eObject which content is requested.")}, result="The content of the specified eObject.", examples={@Example(expression="anEPackage.eContents()", result="Sequence{firstEClass, secondEClass, firstDataType}")})
    public List<EObject> eContents(EObject eObject) {
        return new ArrayList<EObject>((Collection<EObject>)eObject.eContents());
    }

    @Documentation(value="Returns a sequence made of the instances of the specified type in the contents of the specified eObject.", params={@Param(name="eObject", value="The eObject which content is requested."), @Param(name="type", value="The type filter.")}, result="The filtered content of the specified eObject.", examples={@Example(expression="anEPackage.eContents(ecore::EDataType)", result="Sequence{firstDataType}")})
    public List<EObject> eContents(EObject eObject, EClass type) {
        if (type == EcorePackage.eINSTANCE.getEObject()) {
            return this.eContents(eObject);
        }
        LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
        eClasses.add(type);
        return this.eContents(eObject, eClasses);
    }

    @Documentation(value="Returns a sequence made of the instances of the specified types in the contents of the specified eObject.", params={@Param(name="eObject", value="The eObject which content is requested."), @Param(name="types", value="The Set of types filter.")}, result="The filtered content of the specified eObject.", examples={@Example(expression="anEPackage.eContents({ecore::EPackage | ecore::EClass})", result="Sequence{SubEPackage, eClass, ... }")})
    public List<EObject> eContents(EObject eObject, Set<EClass> types) {
        List<EObject> result;
        if (types != null) {
            LinkedHashSet<EStructuralFeature> features = new LinkedHashSet<EStructuralFeature>();
            for (EClass type : types) {
                features.addAll(this.queryEnvironment.getEPackageProvider().getContainingEStructuralFeatures(type));
            }
            result = this.eContents(eObject, types, features);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<EObject> eContents(EObject eObject, Set<EClass> types, Set<EStructuralFeature> features) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (!features.isEmpty()) {
            EStructuralFeature[] containmentFeatures;
            EStructuralFeature[] eStructuralFeatureArray = containmentFeatures = ((EClassImpl.FeatureSubsetSupplier)eObject.eClass().getEAllStructuralFeatures()).containments();
            int n = containmentFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                Object child;
                EStructuralFeature feature = eStructuralFeatureArray[n2];
                if (features.contains(feature) && (child = eObject.eGet(feature)) != null) {
                    this.eContentsVisitChild(result, child, types, feature.isMany(), features);
                }
                ++n2;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void eContentsVisitChild(List<EObject> result, Object child, Set<EClass> types, boolean isMany, Set<EStructuralFeature> features) {
        if (isMany) {
            if (!(child instanceof Collection)) throw new IllegalStateException(DON_T_KNOW_WHAT_TO_DO_WITH + String.valueOf(child.getClass()));
            this.eContentsVisitCollectionChild(result, (Collection)child, types, features);
            return;
        } else {
            if (!(child instanceof EObject) || !this.eIsInstanceOf((EObject)child, types)) return;
            result.add((EObject)child);
        }
    }

    private void eContentsVisitCollectionChild(List<EObject> result, Collection<?> child, Set<EClass> types, Set<EStructuralFeature> features) {
        for (Object object : child) {
            if (!(object instanceof EObject) || !this.eIsInstanceOf((EObject)object, types)) continue;
            result.add((EObject)object);
        }
    }

    @Documentation(value="Returns the container of the specified EObject", params={@Param(name="eObject", value="The eObject which container is requested.")}, result="The container of the specified eObject.", examples={@Example(expression="firstEAttribute.eContainer()", result="firstEClass")})
    public EObject eContainer(EObject eObject) {
        return eObject.eContainer();
    }

    @Documentation(value="Returns the first container of the specified EObject that matches the given type", params={@Param(name="eObject", value="The eObject which container is requested."), @Param(name="type", value="The type filter.")}, result="The first container of the specified eObject that matches the given type.", examples={@Example(expression="firstEAttribute.eContainer(ecore::EPackage)", result="anEPackage")})
    public EObject eContainer(EObject eObject, EClass type) {
        EObject current = eObject.eContainer();
        while (current != null && !type.isSuperTypeOf(current.eClass()) && !type.isInstance((Object)current)) {
            current = current.eContainer();
        }
        EObject result = current != null && (type.isSuperTypeOf(current.eClass()) || type.isInstance((Object)current)) ? current : null;
        return result;
    }

    @Documentation(value="Returns self or the first container of the specified EObject that matches the given type", params={@Param(name="eObject", value="The eObject which container is requested."), @Param(name="type", value="The type filter.")}, result="Self or the first container of the specified eObject that matches the given type.", examples={@Example(expression="firstEAttribute.eContainerOrSelf(ecore::EAttribute)", result="firstEAttribute")})
    public EObject eContainerOrSelf(EObject eObject, EClass type) {
        EObject result = type.isSuperTypeOf(eObject.eClass()) || type.isInstance((Object)eObject) ? eObject : this.eContainer(eObject, type);
        return result;
    }

    @Documentation(value="Returns the EClass of the specified EObject", params={@Param(name="eObject", value="The eObject which EClass is requested.")}, result="The EClass of the specified EObject", examples={@Example(expression="anEObject.eClass()", result="anEClass")})
    public EClass eClass(EObject eObject) {
        return eObject.eClass();
    }

    @Documentation(value="Returns the containing feature of the specified EObject", params={@Param(name="eObject", value="The eObject which containing feature is requested.")}, result="The containing feature of the specified EObject", examples={@Example(expression="anEObject.eContainingFeature()", result="anEStructuralFeature")})
    public EStructuralFeature eContainingFeature(EObject eObject) {
        return eObject.eContainingFeature();
    }

    @Documentation(value="Returns the containment feature of the specified EObject", params={@Param(name="eObject", value="The eObject which containment feature is requested.")}, result="The containment feature of the specified EObject", examples={@Example(expression="anEObject.eContainmentFeature()", result="anEReference")})
    public EReference eContainmentFeature(EObject eObject) {
        return eObject.eContainmentFeature();
    }

    @Documentation(value="Returns the set containing the inverse references.", params={@Param(name="eObject", value="The eObject which inverse references are requested.")}, result="The set of the inverse references", examples={@Example(expression="anEObject.eInverse()", result="OrderedSet{firstReferencingEObject, secondReferencingEObject...}")})
    public Set<EObject> eInverse(EObject self) {
        Set<EObject> result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null) {
            result = Collections.emptySet();
        } else {
            result = new LinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    @Documentation(value="Returns the elements of the given type from the set of the inverse references of the receiver.", params={@Param(name="eObject", value="The eObject which inverse references are requested."), @Param(name="type", value="The type filter.")}, result="The set of the inverse references", examples={@Example(expression="anEObject.eInverse(anEClass)", result="OrderedSet{firstReferencingEObject, secondReferencingEObject...}")})
    public Set<EObject> eInverse(EObject self, EClassifier type) {
        Set<EObject> result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null || type == null) {
            result = Collections.emptySet();
        } else {
            result = new LinkedHashSet<EObject>();
            for (EStructuralFeature.Setting setting : settings) {
                if (!type.isInstance((Object)setting.getEObject())) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    @Documentation(value="Returns the elements from the set of the inverse references of the receiver that are referencing the receiver using a feature with the given name.", params={@Param(name="eObject", value="The eObject which inverse references are requested."), @Param(name="featureName", value="The feature name.")}, result="The set of the inverse references", examples={@Example(expression="anEObject.eInverse(aFeatureName)", result="OrderedSet{firstReferencingEObject, secondReferencingEObject...}")})
    public Set<EObject> eInverse(EObject self, String featureName) {
        Set<EObject> result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null) {
            result = Collections.emptySet();
        } else {
            result = new LinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                if (!setting.getEStructuralFeature().getName().equals(featureName)) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    @Documentation(value="Handles calls to the operation \"eGet\". This will fetch the value of the feature named \"featureName\" on \"source\"", params={@Param(name="eObject", value="The eObject we seek to retrieve a feature value of."), @Param(name="featureName", value="The name of the feature which value we need to retrieve.")}, result="The value of the given feature on the given EObject", examples={@Example(expression="anEObject.eGet(aFeatureName)", result="aValue")})
    public Object eGet(EObject eObject, String featureName) {
        if (eObject == null || featureName == null) {
            throw new NullPointerException();
        }
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature(featureName);
        Object result = null;
        if (feature != null) {
            result = eObject.eGet(feature);
        }
        if (result instanceof Set) {
            result = new LinkedHashSet((Set)result);
        } else if (result instanceof EMap) {
            result = new BasicEMap(((EMap)result).map());
        } else if (result instanceof Collection) {
            result = new ArrayList((Collection)result);
        }
        return result;
    }

    @Documentation(value="Handles calls to the operation \"eGet\". This will fetch the value of the given feature on \"source\"", params={@Param(name="eObject", value="The eObject we seek to retrieve a feature value of."), @Param(name="feature", value="The feature which value we need to retrieve.")}, result="The value of the given feature on the given EObject", examples={@Example(expression="anEObject.eGet(aFeature)", result="aValue")})
    public Object eGet(EObject eObject, EStructuralFeature feature) {
        if (eObject == null || feature == null) {
            throw new NullPointerException();
        }
        Object value = eObject.eGet(feature);
        Object result = value instanceof Set ? new LinkedHashSet((Set)value) : (value instanceof EMap ? new BasicEMap(((EMap)value).map()) : (value instanceof Collection ? new ArrayList((Collection)value) : value));
        return result;
    }

    @Documentation(value="Handles calls to the operation \"eGet\". This will fetch the value of the given feature on \"source\"; the value is optionally resolved before it is returned.", params={@Param(name="eObject", value="The eObject we seek to retrieve a feature value of."), @Param(name="feature", value="The feature which value we need to retrieve."), @Param(name="resolve", value="whether to resolve the value or not.")}, result="The value of the given feature on the given EObject", examples={@Example(expression="anEObject.eGet(aFeature, true)", result="aValue")})
    public Object eGet(EObject eObject, EStructuralFeature feature, boolean resolve) {
        if (eObject == null || feature == null) {
            throw new NullPointerException();
        }
        Object value = eObject.eGet(feature, resolve);
        Object result = value instanceof Set ? new LinkedHashSet((Set)value) : (value instanceof EMap ? new BasicEMap(((EMap)value).map()) : (value instanceof Collection ? new ArrayList((Collection)value) : value));
        return result;
    }

    @Documentation(value="Returns all instances of the EClass", params={@Param(name="type", value="The EClass")}, result="all instances of the EClass", examples={@Example(expression="anEClass.allInstances()", result="Sequence{firstEObject,secondEObject...}")})
    public List<EObject> allInstances(EClass type) {
        List<EObject> result;
        if (type != null) {
            LinkedHashSet<EClass> types = new LinkedHashSet<EClass>();
            types.add(type);
            result = this.allInstances(types);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    @Documentation(value="Returns all instances of each EClass from the OrderedSet", params={@Param(name="types", value="The OrderedSet of EClass")}, result="all instances of each EClass from the OrderedSet", examples={@Example(expression="{ecore::EPackage | ecore::EClass}->allInstances()", result="Sequence{ePackage, eClass, ...}")})
    public List<EObject> allInstances(Set<EClass> types) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (this.rootProvider != null && types != null) {
            for (EObject root : this.rootProvider.getRoots()) {
                if (this.eIsInstanceOf(root, types)) {
                    result.add(root);
                }
                result.addAll(this.eAllContents(root, types));
            }
        }
        return result;
    }

    @Documentation(value="Returns the list of all EObjects cross-referenced from the receiver.", params={@Param(name="eObject", value="The eObject of which we need the cross-references.")}, result="The list of all EObjects cross-referenced from the receiver.", examples={@Example(expression="anEObject.eCrossReferences()", result="Sequence{firstReferencedEObject, secondReferencedEObject...}")})
    public Object eCrossReferences(EObject eObject) {
        return new ArrayList(eObject.eCrossReferences());
    }

    public Object aqlFeatureAccess(EObject self, String featureName) {
        Object result;
        if (self == null) {
            result = null;
        } else {
            EClass eClass = self.eClass();
            EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
            if (feature == null) {
                String message = String.format(UNKNOWN_FEATURE, featureName, eClass.getName());
                result = new Nothing(message);
            } else {
                result = self.eGet(feature);
            }
        }
        return result;
    }

    private final class AllInstancesService
    extends EAllContentsService {
        private AllInstancesService(Method serviceMethod, Object serviceInstance, boolean forWorkspace) {
            super(serviceMethod, serviceInstance, forWorkspace);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnv, List<IType> argTypes) {
            Set<IType> result;
            if (EObjectServices.this.rootProvider == null) {
                result = new LinkedHashSet<IType>();
                result.add(new SequenceType(queryEnv, services.nothing("No IRootEObjectProvider registered", new Object[0])));
            } else {
                ArrayList<IType> newArgTypes = new ArrayList<IType>(argTypes);
                Set<EClassifier> eObjectEClasses = queryEnv.getEPackageProvider().getTypes("ecore", "EObject");
                for (EClassifier eObjectEClass : eObjectEClasses) {
                    newArgTypes.add(0, new EClassifierType(queryEnv, eObjectEClass));
                }
                result = super.getType(call, services, validationResult, queryEnv, newArgTypes);
            }
            return result;
        }
    }

    private static final class EContainerOrSelfService
    extends FilterService {
        private EContainerOrSelfService(Method serviceMethod, Object serviceInstance, boolean forWorkspace) {
            super(serviceMethod, serviceInstance, forWorkspace);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            Set<EClass> eClasses = services.getEClasses(argTypes.get(0));
            if (!eClasses.isEmpty()) {
                for (EClass eCls : eClasses) {
                    if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                        result.add(new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType()));
                        continue;
                    }
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(services.nothing(EObjectServices.ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S, argTypes.get(0)));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            Set<IType> intersectionSelfTypes = services.intersection(argTypes.get(0), argTypes.get(1));
            result.addAll(intersectionSelfTypes);
            IType filterType = argTypes.get(1);
            for (EClass containingEClass : queryEnvironment.getEPackageProvider().getAllContainingEClasses(receiverEClass)) {
                Set<IType> intersectionTypes = services.intersection(new EClassifierType(queryEnvironment, (EClassifier)containingEClass), filterType);
                result.addAll(intersectionTypes);
            }
            if (result.isEmpty()) {
                result.add(services.nothing(EObjectServices.S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S, filterType, argTypes.get(0)));
            }
            return result;
        }
    }

    private static final class EContainerService
    extends FilterService {
        private EContainerService(Method serviceMethod, Object serviceInstance, boolean forWorkspace) {
            super(serviceMethod, serviceInstance, forWorkspace);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            Set<EClass> eClasses = services.getEClasses(argTypes.get(0));
            if (!eClasses.isEmpty()) {
                for (EClass eCls : eClasses) {
                    if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                        if (argTypes.size() == 1) {
                            result.add(new EClassifierType(queryEnvironment, (EClassifier)eCls));
                            continue;
                        }
                        if (argTypes.size() != 2) continue;
                        result.add(new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType()));
                        continue;
                    }
                    result.addAll(this.getTypeForSpecificType(call, services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(services.nothing(EObjectServices.ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S, argTypes.get(0)));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(Call call, ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass containingEClass : queryEnvironment.getEPackageProvider().getContainingEClasses(receiverEClass)) {
                    result.add(new EClassifierType(queryEnvironment, (EClassifier)containingEClass));
                }
                if (result.isEmpty()) {
                    result.add(services.nothing("%s can't be contained", argTypes.get(0)));
                }
            } else if (argTypes.size() == 2) {
                LinkedHashSet<IType> filterTypes = new LinkedHashSet<IType>();
                if (call != null) {
                    Expression typeExpression = (Expression)call.getArguments().get(1);
                    if (typeExpression instanceof EClassifierTypeLiteral || typeExpression instanceof TypeSetLiteral) {
                        filterTypes.addAll(AQLUtils.getTypes(queryEnvironment, (TypeLiteral)typeExpression));
                    } else {
                        filterTypes.add(argTypes.get(1));
                    }
                } else {
                    filterTypes.add(argTypes.get(1));
                }
                for (EClass containingEClass : queryEnvironment.getEPackageProvider().getAllContainingEClasses(receiverEClass)) {
                    for (IType filterType : filterTypes) {
                        Set<IType> intersectionTypes = services.intersection(new EClassifierType(queryEnvironment, (EClassifier)containingEClass), filterType);
                        result.addAll(intersectionTypes);
                    }
                }
                if (result.isEmpty()) {
                    result.add(services.nothing(EObjectServices.S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S, filterTypes, argTypes.get(0)));
                }
            }
            return result;
        }
    }

    private static final class EContentsService
    extends FilterService {
        private EContentsService(Method serviceMethod, Object serviceInstance, boolean forWorkspace) {
            super(serviceMethod, serviceInstance, forWorkspace);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            Set<EClass> eClasses = services.getEClasses(argTypes.get(0));
            if (!eClasses.isEmpty()) {
                for (EClass eCls : eClasses) {
                    if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                        if (argTypes.size() == 1) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)eCls)));
                            continue;
                        }
                        if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                            continue;
                        }
                        if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                            for (EClassifier eClsFilter : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                                result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClsFilter)));
                            }
                            continue;
                        }
                        if (argTypes.size() != 2) continue;
                        result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                        continue;
                    }
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can contain other EClasses not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                LinkedHashSet<SequenceType> containedTypes = new LinkedHashSet<SequenceType>();
                for (EClass contained : queryEnvironment.getEPackageProvider().getContainedEClasses(receiverEClass)) {
                    containedTypes.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)contained)));
                }
                result.addAll(containedTypes);
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s doesn't contain any other EClass", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                LinkedHashSet<IType> filterTypes = new LinkedHashSet<IType>();
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    filterTypes.add(argTypes.get(1));
                } else {
                    Set<EClassifier> eObjectEClasses = queryEnvironment.getEPackageProvider().getTypes("ecore", "EObject");
                    for (EClassifier eObjectEClass : eObjectEClasses) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eObjectEClass));
                    }
                }
                for (IType filterType : filterTypes) {
                    for (EClass containedEClass : queryEnvironment.getEPackageProvider().getContainedEClasses(receiverEClass)) {
                        IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containedEClass), filterType);
                        if (lowerType == null) continue;
                        result.add(new SequenceType(queryEnvironment, lowerType));
                    }
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't contain %s directly", argTypes.get(0), argTypes.get(1))));
                }
            }
            return result;
        }
    }

    private static final class EGetService
    extends JavaMethodService {
        EGetService(Method method, Object serviceInstance, boolean forWorkspace) {
            super(method, serviceInstance, forWorkspace);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (call.getArguments().get(1) instanceof StringLiteral) {
                String featureName = ((StringLiteral)call.getArguments().get(1)).getValue();
                EClass eCls = (EClass)argTypes.get(0).getType();
                EStructuralFeature feature = eCls.getEStructuralFeature(featureName);
                if (feature != null) {
                    if (feature.isMany()) {
                        result.add(new SetType(queryEnvironment, new EClassifierType(queryEnvironment, feature.getEType())));
                    } else {
                        result.add(new EClassifierType(queryEnvironment, feature.getEType()));
                    }
                } else {
                    result.add(services.nothing("EStructuralFeature %s not found for %s", featureName, argTypes.get(0)));
                }
            } else {
                result.add(new ClassType(queryEnvironment, Object.class));
            }
            return result;
        }
    }

    private static final class EInverseService
    extends FilterService {
        private EInverseService(Method serviceMethod, Object serviceInstance, boolean forWorkspace) {
            super(serviceMethod, serviceInstance, forWorkspace);
        }

        private EInverseService(Method serviceMethod, Object serviceInstance, int filterIndex, boolean forWorkspace) {
            super(serviceMethod, serviceInstance, filterIndex, forWorkspace);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            Set<EClass> eClasses = services.getEClasses(argTypes.get(0));
            if (!eClasses.isEmpty()) {
                for (EClass eCls : eClasses) {
                    if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                        if (argTypes.size() == 1 || !(argTypes.get(1).getType() instanceof EClass)) {
                            result.add(new SetType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)eCls)));
                            continue;
                        }
                        if (argTypes.size() != 2) continue;
                        result.add(new SetType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                        continue;
                    }
                    result.addAll(this.getTypeForSpecificType(call, services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SetType(queryEnvironment, services.nothing("Only EClass can have inverse not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(Call call, ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            Set<EClass> inverseEClasses = queryEnvironment.getEPackageProvider().getInverseEClasses(receiverEClass);
            if (argTypes.size() == 1 || !(argTypes.get(1).getType() instanceof EClass)) {
                result.addAll(this.getTypeForSpecificTypeNoFilterOrName(call, services, queryEnvironment, argTypes, inverseEClasses));
            } else if (argTypes.size() == 2) {
                result.addAll(this.getTypeForSpecificTypeFilter(services, queryEnvironment, argTypes, inverseEClasses));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificTypeNoFilterOrName(Call call, ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, Set<EClass> inverseEClasses) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            String featureName = call.getArguments().size() == 2 && call.getArguments().get(1) instanceof StringLiteral ? ((StringLiteral)call.getArguments().get(1)).getValue() : null;
            for (EClass inverseEClass : inverseEClasses) {
                if (featureName != null && inverseEClass.getEStructuralFeature(featureName) == null) continue;
                result.add(new SetType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)inverseEClass)));
            }
            if (result.isEmpty()) {
                result.add(new SetType(queryEnvironment, services.nothing("%s don't have inverse", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificTypeFilter(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, Set<EClass> inverseEClasses) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            IType filterType = argTypes.get(1);
            for (EClass inverseEClass : inverseEClasses) {
                IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)inverseEClass), filterType);
                if (lowerType == null) continue;
                result.add(new SetType(queryEnvironment, lowerType));
            }
            if (result.isEmpty()) {
                result.add(new SetType(queryEnvironment, services.nothing("%s don't have inverse to %s", argTypes.get(0), filterType)));
            }
            return result;
        }
    }

    private static final class EObjectFeatureAccess
    extends JavaMethodService {
        EObjectFeatureAccess(Method method, Object serviceInstance, boolean forWorkspace) {
            super(method, serviceInstance, forWorkspace);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            String featureName = ((StringLiteral)call.getArguments().get(1)).getValue();
            Set<IType> result = this.featureAccessTypes(services, queryEnvironment, argTypes.get(0), featureName);
            return result;
        }

        public Set<IType> featureAccessTypes(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, IType receiverType, String featureName) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            Set<EClass> eClasses = services.getEClasses(receiverType);
            if (!eClasses.isEmpty()) {
                for (EClass eCls : eClasses) {
                    EStructuralFeature feature = eCls.getEStructuralFeature(featureName);
                    if (feature == null) {
                        result.add(services.nothing(EObjectServices.UNKNOWN_FEATURE, featureName, eCls.getName()));
                        continue;
                    }
                    EClassifierType featureBasicType = new EClassifierType(queryEnvironment, feature.getEType());
                    if (feature.isMany()) {
                        result.add(new SequenceType(queryEnvironment, featureBasicType));
                        continue;
                    }
                    result.add(featureBasicType);
                }
            } else if (receiverType.getType() != null) {
                result.add(services.nothing(EObjectServices.NON_EOBJECT_FEATURE_ACCESS, featureName, receiverType.getType().toString()));
            } else {
                result.add(services.nothing(EObjectServices.NON_EOBJECT_FEATURE_ACCESS, featureName, "null"));
            }
            return result;
        }

        @Override
        public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            LinkedHashSet<IType> knownReceiverTypes = new LinkedHashSet<IType>();
            for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
                if (!knownReceiverTypes.add(entry.getKey().get(0))) continue;
                result.addAll((Collection<IType>)entry.getValue());
            }
            return result;
        }

        @Override
        public List<ICompletionProposal> getProposals(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> receiverTypes) {
            return this.getEStructuralFeatureProposals(queryEnvironment, receiverTypes);
        }

        public List<ICompletionProposal> getEStructuralFeatureProposals(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> receiverTypes) {
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
            for (IType iType : receiverTypes) {
                Set<EClassifier> eClassifiers;
                if (iType.getType() instanceof EClass) {
                    eClasses.add((EClass)iType.getType());
                    continue;
                }
                if (!(iType.getType() instanceof Class) || (eClassifiers = queryEnvironment.getEPackageProvider().getEClassifiers((Class)iType.getType())) == null) continue;
                for (EClassifier eClassifier : eClassifiers) {
                    if (!(eClassifier instanceof EClass)) continue;
                    eClasses.add((EClass)eClassifier);
                }
            }
            for (EStructuralFeature feature : queryEnvironment.getEPackageProvider().getEStructuralFeatures(eClasses)) {
                result.add(new EFeatureCompletionProposal(feature));
            }
            return result;
        }
    }

    private static final class FilteredContentIterator
    extends AbstractTreeIterator<EObject> {
        private static final long serialVersionUID = -1537663884310088034L;
        private final Set<EStructuralFeature> features;

        private FilteredContentIterator(Object object, boolean includeRoot, Set<EStructuralFeature> features) {
            super(object, includeRoot);
            this.features = features;
        }

        public Iterator<EObject> getChildren(Object object) {
            EObject host;
            EStructuralFeature[] eStructuralFeatures;
            ArrayList<EObject> result = new ArrayList<EObject>();
            if (object instanceof EObject && (eStructuralFeatures = ((EClassImpl.FeatureSubsetSupplier)(host = (EObject)object).eClass().getEAllStructuralFeatures()).containments()) != null) {
                EStructuralFeature[] eStructuralFeatureArray = eStructuralFeatures;
                int n = eStructuralFeatures.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature feat = eStructuralFeatureArray[n2];
                    if (this.features.contains(feat)) {
                        this.addChildren(result, host, feat);
                    }
                    ++n2;
                }
            }
            return result.iterator();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addChildren(List<EObject> result, EObject eObject, EStructuralFeature feature) {
            Object value = eObject.eGet(feature);
            if (feature.isMany()) {
                if (!(value instanceof Collection)) throw new IllegalStateException(EObjectServices.DON_T_KNOW_WHAT_TO_DO_WITH + String.valueOf(value.getClass()));
                for (Object childElement : (Collection)value) {
                    if (!(childElement instanceof EObject)) continue;
                    result.add((EObject)childElement);
                }
                return;
            } else {
                if (!(value instanceof EObject)) return;
                result.add((EObject)value);
            }
        }
    }
}

