/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CombineIterator<T>
implements Iterator<List<T>> {
    private final Object[][] objects;
    private final int nbCominations;
    private int currentCombination;

    public CombineIterator(List<Set<T>> objects) {
        this.objects = new Object[objects.size()][];
        int cominations = objects.size() != 0 ? 1 : 0;
        int i = 0;
        while (i < this.objects.length) {
            this.objects[i] = objects.get(i).toArray();
            cominations *= this.objects[i].length;
            ++i;
        }
        this.nbCominations = cominations;
        this.currentCombination = 0;
    }

    @Override
    public boolean hasNext() {
        return this.currentCombination < this.nbCominations;
    }

    @Override
    public List<T> next() {
        ArrayList<Object> res = new ArrayList<Object>(this.objects.length);
        int base = this.nbCominations;
        int remains = this.currentCombination;
        int i = 0;
        while (i < this.objects.length) {
            Object[] array = this.objects[i];
            res.add(this.objects[i][remains / (base /= array.length)]);
            remains %= base;
            ++i;
        }
        ++this.currentCombination;
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

