/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.parser.AstBuilderListener;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.parser.Positions;
import org.eclipse.acceleo.query.parser.QueryLexer;
import org.eclipse.acceleo.query.parser.QueryParser;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class QueryBuilderEngine
implements IQueryBuilderEngine {
    public QueryBuilderEngine(IReadOnlyQueryEnvironment queryEnvironment) {
        this();
    }

    public QueryBuilderEngine() {
    }

    @Override
    public AstResult build(String expression) throws AcceleoQueryEvaluationException {
        AstResult result;
        if (expression != null && expression.length() > 0) {
            int expressionEndPosition;
            AstBuilderListener astBuilder = new AstBuilderListener();
            UnbufferedCharStream input = new UnbufferedCharStream((Reader)new StringReader(expression), expression.length());
            QueryLexer lexer = new QueryLexer((CharStream)input);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            lexer.removeErrorListeners();
            lexer.addErrorListener(astBuilder.getErrorListener());
            UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lexer);
            QueryParser parser = new QueryParser((TokenStream)tokens);
            parser.addParseListener(astBuilder);
            parser.removeErrorListeners();
            parser.addErrorListener(astBuilder.getErrorListener());
            parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy(){

                public void sync(Parser recognizer) throws RecognitionException {
                }
            });
            parser.entry();
            result = astBuilder.getAstResult();
            if (result.getDiagnostic().getSeverity() != 4 && (expressionEndPosition = result.getEndPosition(result.getAst())) < expression.length()) {
                String suffix = expression.substring(expressionEndPosition);
                ((BasicDiagnostic)result.getDiagnostic()).add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.acceleo.query", 0, "text remaining after expression \"" + suffix + "\".", new Object[]{suffix}));
            }
        } else {
            ErrorExpression errorExpression = (ErrorExpression)EcoreUtil.create((EClass)AstPackage.eINSTANCE.getErrorExpression());
            ArrayList<Error> errors = new ArrayList<Error>(1);
            errors.add(errorExpression);
            Positions<ASTNode> positions = new Positions<ASTNode>();
            if (expression != null) {
                positions.setIdentifierStartPositions(errorExpression, 0);
                positions.setIdentifierStartLines(errorExpression, 0);
                positions.setIdentifierStartColumns(errorExpression, 0);
                positions.setIdentifierEndPositions(errorExpression, 0);
                positions.setIdentifierEndLines(errorExpression, 0);
                positions.setIdentifierEndColumns(errorExpression, 0);
                positions.setStartPositions(errorExpression, 0);
                positions.setStartLines(errorExpression, 0);
                positions.setStartColumns(errorExpression, 0);
                positions.setEndPositions(errorExpression, 0);
                positions.setEndLines(errorExpression, 0);
                positions.setEndColumns(errorExpression, 0);
            }
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.acceleo.query", 0, "null or empty string.", new Object[]{errorExpression}));
            result = new AstResult(errorExpression, positions, errors, (Diagnostic)diagnostic);
        }
        return result;
    }
}

