/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common;

import org.eclipse.acceleo.common.internal.utils.AcceleoLogger;
import org.eclipse.acceleo.common.internal.utils.AcceleoServicesEclipseUtil;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.internal.utils.workspace.ClassLoadingCompanionProvider;
import org.eclipse.acceleo.common.internal.utils.workspace.ClassLoadingCompanionsRegistry;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class AcceleoCommonPlugin
extends Plugin {
    public static final String COMPANIONS_EXTENSION_POINT = "org.eclipse.acceleo.common.internal.classloadingcompanion";
    public static final String PLUGIN_ID = "org.eclipse.acceleo.common";
    @Deprecated
    public static final String SERVICES_EXTENSION_POINT = "org.eclipse.acceleo.common.java.services";
    private static final String CLASS_TAG_NAME = "class";
    private static final String FILE_EXTENSION_TAG_NAME = "fileExtension";
    private static final String FILE_TAG_NAME = "file";
    private static AcceleoCommonPlugin plugin;
    private BundleContext context;
    private final AcceleoCompanionsRegistryListener companionsListener = new AcceleoCompanionsRegistryListener();

    public AcceleoCommonPlugin() {
        plugin = this;
    }

    public static AcceleoCommonPlugin getDefault() {
        return plugin;
    }

    @Deprecated
    public static void log(Exception e, boolean blocker) {
        AcceleoLogger.log(e, blocker);
    }

    @Deprecated
    public static void log(IStatus status) {
        AcceleoLogger.log(status);
    }

    @Deprecated
    public static void log(String message, boolean blocker) {
        AcceleoLogger.log(message, blocker);
    }

    @Deprecated
    public static void log(String message, Exception cause, boolean blocker) {
        AcceleoLogger.log(message, cause, blocker);
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        AcceleoWorkspaceUtil.INSTANCE.initialize();
        this.context = bundleContext;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener((IRegistryEventListener)this.companionsListener, COMPANIONS_EXTENSION_POINT);
        this.parseInitialContributions();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.companionsListener);
            AcceleoServicesEclipseUtil.clearRegistry();
            ClassLoadingCompanionsRegistry.INSTANCE.clearRegistry();
            AcceleoWorkspaceUtil.INSTANCE.dispose();
            AcceleoPreferences.save();
            plugin = null;
            this.context = null;
        }
        finally {
            super.stop(bundleContext);
        }
    }

    private void parseInitialContributions() {
        Platform.getExtensionRegistry();
    }

    final class AcceleoCompanionsRegistryListener
    implements IRegistryEventListener {
        AcceleoCompanionsRegistryListener() {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    try {
                        ClassLoadingCompanionsRegistry.INSTANCE.register((ClassLoadingCompanionProvider)service.createExecutableExtension(AcceleoCommonPlugin.CLASS_TAG_NAME));
                    }
                    catch (CoreException e) {
                        AcceleoCommonPlugin.log((Exception)((Object)e), false);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    ClassLoadingCompanionsRegistry.INSTANCE.unregister(service.getAttribute(AcceleoCommonPlugin.CLASS_TAG_NAME));
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    }
}

